/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.ValidationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    protected Project project;
    protected List<ValidationInfo> validationResults = new ArrayList<ValidationInfo>();
    protected int maxSeverity;

    public Validator(Project project) {
        this.project = project;
    }

    public Validator(Project project, ConfigStatus status) {
        this(project);
        if (status.hasFailures()) {
            ProjectPath path = new ProjectPath(project);
            for (String message : status.getOtherFailures()) {
                this.registerError(message, path);
            }
            for (String message : status.getFailedMaps().keySet()) {
                this.registerError("Map failed to load: " + message, path);
            }
            for (String message : status.getFailedAdapters().keySet()) {
                this.registerError("Adapter failed to load: " + message, path);
            }
            for (String message : status.getFailedDataSources().keySet()) {
                this.registerError("DataSource failed to load: " + message, path);
            }
            for (String message : status.getFailedMapRefs()) {
                this.registerError("Map reference failed to load: " + message, path);
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    protected void reset() {
        if (this.validationResults != null) {
            this.validationResults = new ArrayList<ValidationInfo>();
        }
        this.maxSeverity = 0;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public void registerValidated(int severity, String message, ProjectPath treeNodePath) {
        ValidationInfo result = new ValidationInfo(severity, message, treeNodePath);
        this.validationResults.add(result);
        if (this.maxSeverity < severity) {
            this.maxSeverity = severity;
        }
    }

    public void registerError(String message, ProjectPath treeNodePath) {
        this.registerValidated(2, message, treeNodePath);
    }

    public void registerWarning(String message, ProjectPath treeNodePath) {
        this.registerValidated(1, message, treeNodePath);
    }

    public List<ValidationInfo> validationResults() {
        return this.validationResults;
    }

    public synchronized int validate() {
        return this.validate(this.project.treeNodes());
    }

    public synchronized int validate(Iterator treeNodes) {
        this.reset();
        while (treeNodes.hasNext()) {
            TreeNodeValidator.validate((ProjectPath)treeNodes.next(), this);
        }
        return this.getMaxSeverity();
    }
}

