/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.apache.commons.configuration.test.HsqlDB;
import org.apache.commons.dbcp.BasicDataSource;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DatabaseConfigurationTestHelper {
    public final String DATABASE_DRIVER = "org.hsqldb.jdbcDriver";
    public final String DATABASE_URL = "jdbc:hsqldb:mem:testdb";
    public final String DATABASE_USERNAME = "sa";
    public final String DATABASE_PASSWORD = "";
    public static final String TABLE = "configuration";
    public static final String TABLE_MULTI = "configurations";
    public static final String COL_KEY = "key";
    public static final String COL_VALUE = "value";
    public static final String COL_NAME = "name";
    public static final String CONFIG_NAME = "test";
    private HsqlDB hsqlDB;
    private DataSource datasource;
    private boolean autoCommit = true;

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setUp() throws Exception {
        File script = ConfigurationAssert.getTestFile("testdb.script");
        this.hsqlDB = new HsqlDB("jdbc:hsqldb:mem:testdb", "org.hsqldb.jdbcDriver", script.getAbsolutePath());
    }

    public void tearDown() throws Exception {
        if (this.datasource != null) {
            this.datasource.getConnection().close();
        }
        this.hsqlDB.close();
    }

    public DatabaseConfiguration setUpConfig() {
        return new DatabaseConfiguration(this.getDatasource(), TABLE, COL_KEY, COL_VALUE, !this.isAutoCommit());
    }

    public DatabaseConfiguration setUpMultiConfig() {
        return this.setUpMultiConfig(CONFIG_NAME);
    }

    public DatabaseConfiguration setUpMultiConfig(String configName) {
        return new DatabaseConfiguration(this.getDatasource(), TABLE_MULTI, COL_NAME, COL_KEY, COL_VALUE, configName, !this.isAutoCommit());
    }

    public DataSource getDatasource() {
        if (this.datasource == null) {
            try {
                this.datasource = this.setUpDataSource();
            }
            catch (Exception ex) {
                throw new ConfigurationRuntimeException("Could not create data source", (Throwable)ex);
            }
        }
        return this.datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource setUpDataSource() throws Exception {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.hsqldb.jdbcDriver");
        ds.setUrl("jdbc:hsqldb:mem:testdb");
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setDefaultAutoCommit(this.isAutoCommit());
        Connection conn = ds.getConnection();
        DatabaseConnection connection = new DatabaseConnection(conn);
        XmlDataSet dataSet = new XmlDataSet((InputStream)new FileInputStream(ConfigurationAssert.getTestFile("dataset.xml")));
        try {
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)connection, (IDataSet)dataSet);
        }
        finally {
            if (!this.isAutoCommit()) {
                conn.commit();
            }
            connection.close();
        }
        return ds;
    }
}

