/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.dbutils.BaseResultSetHandler;
import org.apache.commons.dbutils.BaseTestCase;
import org.junit.Test;

public final class BaseResultSetHandlerTest
extends BaseTestCase {
    @Test
    public void handleWithoutExplicitResultSetInvocation() throws Exception {
        Collection result = (Collection)new ToMapCollectionHandler().handle(this.createMockResultSet());
        BaseResultSetHandlerTest.assertFalse((boolean)result.isEmpty());
        for (Map current : result) {
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("one"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("two"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("three"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("notInBean"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("intTest"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("integerTest"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("nullObjectTest"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("nullPrimitiveTest"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("notDate"));
            BaseResultSetHandlerTest.assertTrue((boolean)current.containsKey("columnProcessorDoubleTest"));
        }
    }

    private static final class ToMapCollectionHandler
    extends BaseResultSetHandler<Collection<Map<String, Object>>> {
        private ToMapCollectionHandler() {
        }

        protected Collection<Map<String, Object>> handle() throws SQLException {
            LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
            while (this.next()) {
                HashMap<String, Object> current = new HashMap<String, Object>();
                for (int i = 1; i <= this.getMetaData().getColumnCount(); ++i) {
                    current.put(this.getMetaData().getColumnName(i), this.getObject(i));
                }
                result.add(current);
            }
            return result;
        }
    }
}

