/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.Column;
import org.apache.commons.dbutils.MockResultSet;
import org.apache.commons.dbutils.MockResultSetMetaData;
import org.apache.commons.dbutils.ProxyFactory;
import org.apache.commons.dbutils.TestBean;
import org.junit.Assert;

public class BeanProcessorTest
extends BaseTestCase {
    private static final BeanProcessor beanProc = new BeanProcessor();

    public void testCheckAnnotationOnMissingReadMethod() throws Exception {
        String[] colNames = new String[]{"testField"};
        ResultSetMetaData metaData = MockResultSetMetaData.create(colNames);
        String testField = "first";
        Object[][] rows = new Object[][]{{"first"}};
        ResultSet rs = MockResultSet.create(metaData, rows);
        BeanProcessorTest.assertTrue((boolean)rs.next());
        TestNoGetter testCls = new TestNoGetter();
        testCls = (TestNoGetter)beanProc.populateBean(rs, (Object)testCls);
        BeanProcessorTest.assertEquals((String)testCls.testField, (String)"first");
    }

    public void testIndexedPropertyDescriptor() throws Exception {
        List<String> things;
        String[] colNames = new String[]{"name", "things", "stuff"};
        ResultSetMetaData metaData = MockResultSetMetaData.create(colNames);
        String name = "first";
        List<String> stuff = things = Arrays.asList("1", "2", "3", "4");
        Object[][] rows = new Object[][]{{"first", things, stuff}};
        ResultSet rs = MockResultSet.create(metaData, rows);
        BeanProcessorTest.assertTrue((boolean)rs.next());
        IndexedPropertyTestClass testCls = new IndexedPropertyTestClass();
        testCls = (IndexedPropertyTestClass)beanProc.populateBean(rs, (Object)testCls);
        BeanProcessorTest.assertEquals((String)"first", (String)testCls.getName());
        Assert.assertArrayEquals((Object[])things.toArray(), (Object[])testCls.getThings().toArray());
        Assert.assertArrayEquals((Object[])stuff.toArray(), (Object[])testCls.getStuff().toArray());
    }

    public void testMapColumnToAnnotationField() throws Exception {
        String[] columnNames = new String[]{"test", "test", "three_"};
        String[] columnLabels = new String[]{"one", "two", null};
        ResultSetMetaData rsmd = ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames, columnLabels));
        PropertyDescriptor[] props = Introspector.getBeanInfo(MapColumnToAnnotationFieldBean.class).getPropertyDescriptors();
        int[] columns = beanProc.mapColumnsToProperties(rsmd, props);
        for (int i = 1; i < columns.length; ++i) {
            BeanProcessorTest.assertTrue((columns[i] != -1 ? 1 : 0) != 0);
        }
    }

    public void testMapColumnToProperties() throws Exception {
        String[] columnNames = new String[]{"test", "test", "three"};
        String[] columnLabels = new String[]{"one", "two", null};
        ResultSetMetaData rsmd = ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames, columnLabels));
        PropertyDescriptor[] props = Introspector.getBeanInfo(MapColumnToPropertiesBean.class).getPropertyDescriptors();
        int[] columns = beanProc.mapColumnsToProperties(rsmd, props);
        for (int i = 1; i < columns.length; ++i) {
            BeanProcessorTest.assertTrue((columns[i] != -1 ? 1 : 0) != 0);
        }
    }

    public void testMapColumnToPropertiesWithOverrides() throws Exception {
        HashMap<String, String> columnToPropertyOverrides = new HashMap<String, String>();
        columnToPropertyOverrides.put("five", "four");
        BeanProcessor beanProc = new BeanProcessor(columnToPropertyOverrides);
        String[] columnNames = new String[]{"test", "test", "three", "five"};
        String[] columnLabels = new String[]{"one", "two", null, null};
        ResultSetMetaData rsmd = ProxyFactory.instance().createResultSetMetaData((InvocationHandler)new MockResultSetMetaData(columnNames, columnLabels));
        PropertyDescriptor[] props = Introspector.getBeanInfo(MapColumnToPropertiesBean.class).getPropertyDescriptors();
        int[] columns = beanProc.mapColumnsToProperties(rsmd, props);
        for (int i = 1; i < columns.length; ++i) {
            BeanProcessorTest.assertTrue((columns[i] != -1 ? 1 : 0) != 0);
        }
    }

    public void testProcessWithPopulateBean() throws SQLException {
        TestBean b = new TestBean();
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        b = (TestBean)beanProc.populateBean(this.rs, (Object)b);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.THREE));
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        b = (TestBean)beanProc.populateBean(this.rs, (Object)b);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.SIX));
        BeanProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testProcessWithToBean() throws SQLException {
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        TestBean b = (TestBean)beanProc.toBean(this.rs, TestBean.class);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.THREE));
        BeanProcessorTest.assertTrue((boolean)this.rs.next());
        b = (TestBean)beanProc.toBean(this.rs, TestBean.class);
        BeanProcessorTest.assertEquals((double)13.0, (double)b.getColumnProcessorDoubleTest(), (double)0.0);
        BeanProcessorTest.assertEquals((Object)((Object)b.getThree()), (Object)((Object)TestBean.Ordinal.SIX));
        BeanProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testWrongSetterParamCount() throws Exception {
        String[] colNames = new String[]{"testField"};
        ResultSetMetaData metaData = MockResultSetMetaData.create(colNames);
        Integer testField = 1;
        Object[][] rows = new Object[][]{{testField}};
        ResultSet rs = MockResultSet.create(metaData, rows);
        BeanProcessorTest.assertTrue((boolean)rs.next());
        TestWrongSetter testCls = new TestWrongSetter();
        testCls = (TestWrongSetter)beanProc.populateBean(rs, (Object)testCls);
        BeanProcessorTest.assertNull((Object)testCls.testField);
    }

    private static final class TestNoGetter {
        public String testField;

        private TestNoGetter() {
        }

        public void setTestField(String testField) {
            this.testField = testField;
        }
    }

    private static class IndexedPropertyTestClass {
        private String name;
        private List<String> things;
        private List<String> stuff;

        private IndexedPropertyTestClass() {
        }

        public String getName() {
            return this.name;
        }

        public List<String> getStuff() {
            return this.stuff;
        }

        public String getThing(int idx) {
            return this.things.get(idx);
        }

        public List<String> getThings() {
            return this.things;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStuff(List<String> stuff) {
            this.stuff = stuff;
        }

        public void setThing(int idx, String thing) {
            this.things.set(idx, thing);
        }

        public void setThings(List<String> things) {
            this.things = things;
        }
    }

    public static class MapColumnToAnnotationFieldBean {
        private String one;
        private String two;
        private String three;
        private String four;

        public String getFour() {
            return this.four;
        }

        public String getOne() {
            return this.one;
        }

        @Column(name="three_")
        public String getThree() {
            return this.three;
        }

        public String getTwo() {
            return this.two;
        }

        public void setFour(String four) {
            this.four = four;
        }

        public void setOne(String one) {
            this.one = one;
        }

        public void setThree(String three) {
            this.three = three;
        }

        public void setTwo(String two) {
            this.two = two;
        }
    }

    public static class MapColumnToPropertiesBean {
        private String one;
        private String two;
        private String three;
        private String four;

        public String getFour() {
            return this.four;
        }

        public String getOne() {
            return this.one;
        }

        public String getThree() {
            return this.three;
        }

        public String getTwo() {
            return this.two;
        }

        public void setFour(String four) {
            this.four = four;
        }

        public void setOne(String one) {
            this.one = one;
        }

        public void setThree(String three) {
            this.three = three;
        }

        public void setTwo(String two) {
            this.two = two;
        }
    }

    private static final class TestWrongSetter {
        public Integer testField;

        private TestWrongSetter() {
        }

        public Integer getTestField() {
            return this.testField;
        }

        public void setTestField(int idx, Integer testField) {
            this.testField = testField;
        }
    }
}

