/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.PamFileInfo;
import org.apache.commons.imaging.formats.pnm.PamWriter;
import org.apache.commons.imaging.formats.pnm.PbmFileInfo;
import org.apache.commons.imaging.formats.pnm.PbmWriter;
import org.apache.commons.imaging.formats.pnm.PgmFileInfo;
import org.apache.commons.imaging.formats.pnm.PgmWriter;
import org.apache.commons.imaging.formats.pnm.PnmImagingParameters;
import org.apache.commons.imaging.formats.pnm.PnmWriter;
import org.apache.commons.imaging.formats.pnm.PpmFileInfo;
import org.apache.commons.imaging.formats.pnm.PpmWriter;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;
import org.apache.commons.imaging.palette.PaletteFactory;

public class PnmImageParser
extends AbstractImageParser<PnmImagingParameters> {
    private static final String TOKEN_ENDHDR = "ENDHDR";
    private static final String TOKEN_TUPLTYPE = "TUPLTYPE";
    private static final String TOKEN_MAXVAL = "MAXVAL";
    private static final String TOKEN_DEPTH = "DEPTH";
    private static final String TOKEN_HEIGHT = "HEIGHT";
    private static final String TOKEN_WIDTH = "WIDTH";
    private static final int DPI = 72;
    private static final ImageFormat[] IMAGE_FORMATS;
    private static final String DEFAULT_EXTENSION;
    private static final String[] ACCEPTED_EXTENSIONS;

    public PnmImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    private void check(boolean value, String type) throws ImagingException {
        if (!value) {
            throw new ImagingException("PAM header has no " + type + " value");
        }
    }

    private void checkFound(int value, String type) throws ImagingException {
        this.check(value != -1, type);
    }

    private String checkNextTokens(StringTokenizer tokenizer, String type) throws ImagingException {
        this.check(tokenizer.hasMoreTokens(), type);
        return tokenizer.nextToken();
    }

    private int checkNextTokensAsInt(StringTokenizer tokenizer, String type) throws ImagingException {
        return Integer.parseInt(this.checkNextTokens(tokenizer, type));
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        pw.println("pnm.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        pw.println("");
        return true;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return (String[])ACCEPTED_EXTENSIONS.clone();
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return (ImageFormat[])IMAGE_FORMATS.clone();
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, PnmImagingParameters params) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            AbstractFileInfo info = this.readHeader(is);
            int width = info.width;
            int height = info.height;
            boolean hasAlpha = info.hasAlpha();
            ImageBuilder imageBuilder = new ImageBuilder(width, height, hasAlpha);
            info.readImage(imageBuilder, is);
            BufferedImage bufferedImage = imageBuilder.getBufferedImage();
            return bufferedImage;
        }
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public PnmImagingParameters getDefaultParameters() {
        return new PnmImagingParameters();
    }

    @Override
    public byte[] getIccProfileBytes(ByteSource byteSource, PnmImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, PnmImagingParameters params) throws ImagingException, IOException {
        AbstractFileInfo info = this.readHeader(byteSource);
        ArrayList<String> comments = new ArrayList<String>();
        int bitsPerPixel = info.getBitDepth() * info.getNumComponents();
        ImageFormat format = info.getImageType();
        String formatName = info.getImageTypeDescription();
        String mimeType = info.getMimeType();
        boolean numberOfImages = true;
        boolean progressive = false;
        int physicalWidthDpi = 72;
        float physicalWidthInch = (float)((double)info.width / 72.0);
        int physicalHeightDpi = 72;
        float physicalHeightInch = (float)((double)info.height / 72.0);
        String formatDetails = info.getImageTypeDescription();
        boolean transparent = info.hasAlpha();
        boolean usesPalette = false;
        ImageInfo.ColorType colorType = info.getColorType();
        ImageInfo.CompressionAlgorithm compressionAlgorithm = ImageInfo.CompressionAlgorithm.NONE;
        return new ImageInfo(formatDetails, bitsPerPixel, comments, format, formatName, info.height, mimeType, 1, 72, physicalHeightInch, 72, physicalWidthInch, info.width, false, transparent, false, colorType, compressionAlgorithm);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, PnmImagingParameters params) throws ImagingException, IOException {
        AbstractFileInfo info = this.readHeader(byteSource);
        return new Dimension(info.width, info.height);
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, PnmImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public String getName() {
        return "Pbm-Custom";
    }

    private AbstractFileInfo readHeader(ByteSource byteSource) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            AbstractFileInfo abstractFileInfo = this.readHeader(is);
            return abstractFileInfo;
        }
    }

    private AbstractFileInfo readHeader(InputStream inputStream) throws ImagingException, IOException {
        byte identifier1 = BinaryFunctions.readByte("Identifier1", inputStream, "Not a Valid PNM File");
        byte identifier2 = BinaryFunctions.readByte("Identifier2", inputStream, "Not a Valid PNM File");
        if (identifier1 != 80) {
            throw new ImagingException("PNM file has invalid prefix byte 1");
        }
        WhiteSpaceReader wsReader = new WhiteSpaceReader(inputStream);
        if (identifier2 == 49 || identifier2 == 52 || identifier2 == 50 || identifier2 == 53 || identifier2 == 51 || identifier2 == 54) {
            int height;
            int width;
            try {
                width = Integer.parseInt(wsReader.readtoWhiteSpace());
            }
            catch (NumberFormatException e) {
                throw new ImagingException("Invalid width specified.", e);
            }
            try {
                height = Integer.parseInt(wsReader.readtoWhiteSpace());
            }
            catch (NumberFormatException e) {
                throw new ImagingException("Invalid height specified.", e);
            }
            switch (identifier2) {
                case 49: {
                    return new PbmFileInfo(width, height, false);
                }
                case 52: {
                    return new PbmFileInfo(width, height, true);
                }
                case 50: {
                    int maxgray = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PgmFileInfo(width, height, false, maxgray);
                }
                case 53: {
                    int maxgray = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PgmFileInfo(width, height, true, maxgray);
                }
                case 51: {
                    int max = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PpmFileInfo(width, height, false, max);
                }
                case 54: {
                    int max = Integer.parseInt(wsReader.readtoWhiteSpace());
                    return new PpmFileInfo(width, height, true, max);
                }
            }
        } else if (identifier2 == 55) {
            String line;
            int width = -1;
            int height = -1;
            int depth = -1;
            int maxVal = -1;
            StringBuilder tupleType = new StringBuilder();
            wsReader.readLine();
            while ((line = wsReader.readLine()) != null) {
                String type;
                if ((line = line.trim()).charAt(0) == '#') continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ", false);
                switch (type = tokenizer.nextToken()) {
                    case "WIDTH": {
                        width = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "HEIGHT": {
                        height = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "DEPTH": {
                        depth = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "MAXVAL": {
                        maxVal = this.checkNextTokensAsInt(tokenizer, type);
                        break;
                    }
                    case "TUPLTYPE": {
                        tupleType.append(this.checkNextTokens(tokenizer, type));
                        break;
                    }
                    case "ENDHDR": {
                        break;
                    }
                    default: {
                        throw new ImagingException("Invalid PAM file header type " + type);
                    }
                }
                if (!TOKEN_ENDHDR.equals(type)) continue;
                break;
            }
            this.checkFound(width, TOKEN_WIDTH);
            this.checkFound(height, TOKEN_HEIGHT);
            this.checkFound(depth, TOKEN_DEPTH);
            this.checkFound(maxVal, TOKEN_MAXVAL);
            this.check(tupleType.length() > 0, TOKEN_TUPLTYPE);
            return new PamFileInfo(width, height, depth, maxVal, tupleType.toString());
        }
        throw new ImagingException("PNM file has invalid prefix byte 2");
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, PnmImagingParameters params) throws ImagingException, IOException {
        PnmWriter writer = null;
        boolean useRawbits = true;
        if (params != null) {
            useRawbits = params.isRawBits();
            ImageFormats subtype = params.getSubtype();
            if (subtype != null) {
                switch (subtype) {
                    case PBM: {
                        writer = new PbmWriter(useRawbits);
                        break;
                    }
                    case PGM: {
                        writer = new PgmWriter(useRawbits);
                        break;
                    }
                    case PPM: {
                        writer = new PpmWriter(useRawbits);
                        break;
                    }
                    case PAM: {
                        writer = new PamWriter();
                        break;
                    }
                }
            }
        }
        if (writer == null) {
            writer = new PaletteFactory().hasTransparency(src) ? new PamWriter() : new PpmWriter(useRawbits);
        }
        writer.writeImage(src, os, params);
    }

    static {
        DEFAULT_EXTENSION = ImageFormats.PNM.getDefaultExtension();
        IMAGE_FORMATS = new ImageFormat[]{ImageFormats.PAM, ImageFormats.PBM, ImageFormats.PGM, ImageFormats.PNM, ImageFormats.PPM};
        ACCEPTED_EXTENSIONS = (String[])Stream.of(IMAGE_FORMATS).map(ImageFormat::getDefaultExtension).toArray(String[]::new);
    }
}

