/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.ExpressionImpl;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlThreadedArithmetic;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.JexlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlTestCase
extends TestCase {
    private static final Class<?>[] noParms = new Class[0];
    private static final Class<?>[] stringParm = new Class[]{String.class};
    protected final JexlEngine JEXL;

    public JexlTestCase(String name) {
        this(name, new JexlEngine());
    }

    protected JexlTestCase(String name, JexlEngine jexl) {
        super(name);
        this.JEXL = jexl;
        this.JEXL.setCache(512);
    }

    public JexlTestCase() {
        this(new JexlEngine());
    }

    protected JexlTestCase(JexlEngine jexl) {
        this.JEXL = jexl;
        this.JEXL.setCache(512);
    }

    protected void tearDown() throws Exception {
        JexlTestCase.debuggerCheck(this.JEXL);
    }

    public static JexlEngine createEngine(boolean lenient) {
        return new JexlEngine(null, new JexlArithmetic(lenient), null, null);
    }

    public static JexlEngine createThreadedArithmeticEngine(boolean lenient) {
        return new JexlEngine(null, (JexlArithmetic)new JexlThreadedArithmetic(lenient), null, null);
    }

    public static void debuggerCheck(JexlEngine jexl) throws Exception {
        if (jexl.cache == null) {
            return;
        }
        JexlEngine jdbg = new JexlEngine();
        jdbg.parser.ALLOW_REGISTERS = true;
        Debugger dbg = new Debugger();
        for (Map.Entry entry : jexl.cache.entrySet()) {
            JexlNode node = (JexlNode)entry.getValue();
            dbg.debug(node);
            String expressiondbg = dbg.data();
            Script exprdbg = jdbg.createScript(expressiondbg);
            ASTJexlScript root = ((ExpressionImpl)exprdbg).script;
            while (root.jjtGetParent() != null) {
                root = root.jjtGetParent();
            }
            String reason = JexlTestCase.checkEquals((JexlNode)root, node);
            if (reason == null) continue;
            throw new RuntimeException("debugger equal failed: " + expressiondbg + " /**** " + reason + " **** */ " + (String)entry.getKey());
        }
    }

    protected static ArrayList<JexlNode> flatten(JexlNode node) {
        ArrayList<JexlNode> list = new ArrayList<JexlNode>();
        JexlTestCase.flatten(list, node);
        return list;
    }

    private static void flatten(List<JexlNode> list, JexlNode node) {
        int nc = node.jjtGetNumChildren();
        list.add(node);
        for (int c = 0; c < nc; ++c) {
            JexlTestCase.flatten(list, node.jjtGetChild(c));
        }
    }

    private static String checkEquals(JexlNode lhs, JexlNode rhs) {
        if (lhs != rhs) {
            ArrayList<JexlNode> lhsl = JexlTestCase.flatten(lhs);
            ArrayList<JexlNode> rhsl = JexlTestCase.flatten(rhs);
            if (lhsl.size() != rhsl.size()) {
                return "size: " + lhsl.size() + " != " + rhsl.size();
            }
            for (int n = 0; n < lhsl.size(); ++n) {
                lhs = lhsl.get(n);
                rhs = rhsl.get(n);
                if (lhs.getClass() != rhs.getClass()) {
                    return "class: " + lhs.getClass() + " != " + rhs.getClass();
                }
                if (lhs.image == null && rhs.image != null || lhs.image != null && rhs.image == null) {
                    return "image: " + lhs.image + " != " + rhs.image;
                }
                if (lhs.image == null || lhs.image.equals(rhs.image)) continue;
                return "image: " + lhs.image + " != " + rhs.image;
            }
        }
        return null;
    }

    protected String flattenedStr(Script e) {
        return e.getText() + "\n" + this.flattenedStr((JexlNode)((ExpressionImpl)e).script);
    }

    private static String indent(JexlNode node) {
        StringBuilder strb = new StringBuilder();
        while (node != null) {
            strb.append("  ");
            node = node.jjtGetParent();
        }
        return strb.toString();
    }

    private String flattenedStr(JexlNode node) {
        ArrayList<JexlNode> flattened = JexlTestCase.flatten(node);
        StringBuilder strb = new StringBuilder();
        for (JexlNode flat : flattened) {
            strb.append(JexlTestCase.indent(flat));
            strb.append(flat.getClass().getSimpleName());
            if (flat.image != null) {
                strb.append(" = ");
                strb.append(flat.image);
            }
            strb.append("\n");
        }
        return strb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String name) throws Exception {
        if ("runTest".equals(name)) {
            return;
        }
        Method method = null;
        try {
            method = ((Object)((Object)this)).getClass().getDeclaredMethod(name, noParms);
        }
        catch (Exception xany) {
            JexlTestCase.fail((String)("no such test: " + name));
            return;
        }
        try {
            this.setUp();
            method.invoke((Object)this, new Object[0]);
        }
        finally {
            this.tearDown();
        }
    }

    public static void runTest(String tname, String mname) throws Exception {
        String testClassName = "org.apache.commons.jexl2." + tname;
        Class<?> clazz = null;
        JexlTestCase test = null;
        try {
            clazz = Class.forName(testClassName);
        }
        catch (ClassNotFoundException xclass) {
            JexlTestCase.fail((String)("no such class: " + testClassName));
            return;
        }
        Constructor<?> ctor = null;
        try {
            ctor = clazz.getConstructor(stringParm);
            test = (JexlTestCase)((Object)ctor.newInstance("debug"));
        }
        catch (NoSuchMethodException xctor) {
            try {
                test = (JexlTestCase)((Object)clazz.newInstance());
            }
            catch (Exception xany) {
                JexlTestCase.fail((String)("cant instantiate test: " + xany));
                return;
            }
        }
        catch (Exception xany) {
            JexlTestCase.fail((String)("cant instantiate test: " + xany));
            return;
        }
        test.runTest(mname);
    }

    public static void main(String[] args) throws Exception {
        JexlTestCase.runTest(args[0], args[1]);
    }
}

