/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import org.apache.commons.math3.ExtendedFieldElementAbstractTest;
import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpTest
extends ExtendedFieldElementAbstractTest<Dfp> {
    private DfpField field;
    private Dfp pinf;
    private Dfp ninf;
    private Dfp nan;
    private Dfp snan;
    private Dfp qnan;

    @Override
    protected Dfp build(double x) {
        return this.field.newDfp(x);
    }

    @Before
    public void setUp() {
        this.field = new DfpField(20);
        this.pinf = this.field.newDfp("1").divide(this.field.newDfp("0"));
        this.ninf = this.field.newDfp("-1").divide(this.field.newDfp("0"));
        this.nan = this.field.newDfp("0").divide(this.field.newDfp("0"));
        this.snan = this.field.newDfp((byte)1, (byte)2);
        this.qnan = this.field.newDfp((byte)1, (byte)3);
        this.ninf.getField().clearIEEEFlags();
    }

    @After
    public void tearDown() {
        this.field = null;
        this.pinf = null;
        this.ninf = null;
        this.nan = null;
        this.snan = null;
        this.qnan = null;
    }

    private void test(Dfp x, Dfp y, int flags, String desc) {
        boolean b = x.equals((Object)y);
        if (!x.equals((Object)y) && !x.unequal(y)) {
            b = x.toString().equals(y.toString());
        }
        if (x.equals((Object)this.field.newDfp("0"))) {
            b = b && x.toString().equals(y.toString());
        }
        boolean bl = b = b && x.getField().getIEEEFlags() == flags;
        if (!b) {
            Assert.assertTrue((String)("assersion failed " + desc + " x = " + x.toString() + " flags = " + x.getField().getIEEEFlags()), (boolean)b);
        }
        x.getField().clearIEEEFlags();
    }

    @Test
    public void testByteConstructor() {
        Assert.assertEquals((Object)"0.", (Object)new Dfp(this.field, 0).toString());
        Assert.assertEquals((Object)"1.", (Object)new Dfp(this.field, 1).toString());
        Assert.assertEquals((Object)"-1.", (Object)new Dfp(this.field, -1).toString());
        Assert.assertEquals((Object)"-128.", (Object)new Dfp(this.field, -128).toString());
        Assert.assertEquals((Object)"127.", (Object)new Dfp(this.field, 127).toString());
    }

    @Test
    public void testIntConstructor() {
        Assert.assertEquals((Object)"0.", (Object)new Dfp(this.field, 0).toString());
        Assert.assertEquals((Object)"1.", (Object)new Dfp(this.field, 1).toString());
        Assert.assertEquals((Object)"-1.", (Object)new Dfp(this.field, -1).toString());
        Assert.assertEquals((Object)"1234567890.", (Object)new Dfp(this.field, 1234567890).toString());
        Assert.assertEquals((Object)"-1234567890.", (Object)new Dfp(this.field, -1234567890).toString());
        Assert.assertEquals((Object)"-2147483648.", (Object)new Dfp(this.field, Integer.MIN_VALUE).toString());
        Assert.assertEquals((Object)"2147483647.", (Object)new Dfp(this.field, Integer.MAX_VALUE).toString());
    }

    @Test
    public void testLongConstructor() {
        Assert.assertEquals((Object)"0.", (Object)new Dfp(this.field, 0L).toString());
        Assert.assertEquals((Object)"1.", (Object)new Dfp(this.field, 1L).toString());
        Assert.assertEquals((Object)"-1.", (Object)new Dfp(this.field, -1L).toString());
        Assert.assertEquals((Object)"1234567890.", (Object)new Dfp(this.field, 1234567890L).toString());
        Assert.assertEquals((Object)"-1234567890.", (Object)new Dfp(this.field, -1234567890L).toString());
        Assert.assertEquals((Object)"-9223372036854775808.", (Object)new Dfp(this.field, Long.MIN_VALUE).toString());
        Assert.assertEquals((Object)"9223372036854775807.", (Object)new Dfp(this.field, Long.MAX_VALUE).toString());
    }

    @Test
    public void testAdd() {
        this.test(this.field.newDfp("1").add(this.field.newDfp("1")), this.field.newDfp("2"), 0, "Add #1");
        this.test(this.field.newDfp("1").add(this.field.newDfp("-1")), this.field.newDfp("0"), 0, "Add #2");
        this.test(this.field.newDfp("-1").add(this.field.newDfp("1")), this.field.newDfp("0"), 0, "Add #3");
        this.test(this.field.newDfp("-1").add(this.field.newDfp("-1")), this.field.newDfp("-2"), 0, "Add #4");
        this.test(this.field.newDfp("1").add(this.field.newDfp("1e-16")), this.field.newDfp("1.0000000000000001"), 0, "Add #5");
        this.test(this.field.newDfp("1").add(this.field.newDfp("1e-17")), this.field.newDfp("1"), 16, "Add #6");
        this.test(this.field.newDfp("0.90999999999999999999").add(this.field.newDfp("0.1")), this.field.newDfp("1.01"), 16, "Add #7");
        this.test(this.field.newDfp(".10000000000000005000").add(this.field.newDfp(".9")), this.field.newDfp("1."), 16, "Add #8");
        this.test(this.field.newDfp(".10000000000000015000").add(this.field.newDfp(".9")), this.field.newDfp("1.0000000000000002"), 16, "Add #9");
        this.test(this.field.newDfp(".10000000000000014999").add(this.field.newDfp(".9")), this.field.newDfp("1.0000000000000001"), 16, "Add #10");
        this.test(this.field.newDfp(".10000000000000015001").add(this.field.newDfp(".9")), this.field.newDfp("1.0000000000000002"), 16, "Add #11");
        this.test(this.field.newDfp(".11111111111111111111").add(this.field.newDfp("11.1111111111111111")), this.field.newDfp("11.22222222222222222222"), 16, "Add #12");
        this.test(this.field.newDfp(".11111111111111111111").add(this.field.newDfp("1111111111111111.1111")), this.field.newDfp("1111111111111111.2222"), 16, "Add #13");
        this.test(this.field.newDfp(".11111111111111111111").add(this.field.newDfp("11111111111111111111")), this.field.newDfp("11111111111111111111"), 16, "Add #14");
        this.test(this.field.newDfp("9.9999999999999999999e131071").add(this.field.newDfp("-1e131052")), this.field.newDfp("9.9999999999999999998e131071"), 0, "Add #15");
        this.test(this.field.newDfp("9.9999999999999999999e131071").add(this.field.newDfp("1e131052")), this.pinf, 4, "Add #16");
        this.test(this.field.newDfp("-9.9999999999999999999e131071").add(this.field.newDfp("-1e131052")), this.ninf, 4, "Add #17");
        this.test(this.field.newDfp("-9.9999999999999999999e131071").add(this.field.newDfp("1e131052")), this.field.newDfp("-9.9999999999999999998e131071"), 0, "Add #18");
        this.test(this.field.newDfp("1e-131072").add(this.field.newDfp("1e-131072")), this.field.newDfp("2e-131072"), 0, "Add #19");
        this.test(this.field.newDfp("1.0000000000000001e-131057").add(this.field.newDfp("-1e-131057")), this.field.newDfp("1e-131073"), 8, "Add #20");
        this.test(this.field.newDfp("1.1e-131072").add(this.field.newDfp("-1e-131072")), this.field.newDfp("1e-131073"), 8, "Add #21");
        this.test(this.field.newDfp("1.0000000000000001e-131072").add(this.field.newDfp("-1e-131072")), this.field.newDfp("1e-131088"), 8, "Add #22");
        this.test(this.field.newDfp("1.0000000000000001e-131078").add(this.field.newDfp("-1e-131078")), this.field.newDfp("0"), 8, "Add #23");
        this.test(this.field.newDfp("1.0").add(this.field.newDfp("-1e-20")), this.field.newDfp("0.99999999999999999999"), 0, "Add #23.1");
        this.test(this.field.newDfp("-0.99999999999999999999").add(this.field.newDfp("1")), this.field.newDfp("0.00000000000000000001"), 0, "Add #23.2");
        this.test(this.field.newDfp("1").add(this.field.newDfp("0")), this.field.newDfp("1"), 0, "Add #24");
        this.test(this.field.newDfp("0").add(this.field.newDfp("0")), this.field.newDfp("0"), 0, "Add #25");
        this.test(this.field.newDfp("-0").add(this.field.newDfp("0")), this.field.newDfp("0"), 0, "Add #26");
        this.test(this.field.newDfp("0").add(this.field.newDfp("-0")), this.field.newDfp("0"), 0, "Add #27");
        this.test(this.field.newDfp("-0").add(this.field.newDfp("-0")), this.field.newDfp("-0"), 0, "Add #28");
        this.test(this.field.newDfp("1e-20").add(this.field.newDfp("0")), this.field.newDfp("1e-20"), 0, "Add #29");
        this.test(this.field.newDfp("1e-40").add(this.field.newDfp("0")), this.field.newDfp("1e-40"), 0, "Add #30");
        this.test(this.pinf.add(this.ninf), this.nan, 1, "Add #31");
        this.test(this.ninf.add(this.pinf), this.nan, 1, "Add #32");
        this.test(this.ninf.add(this.ninf), this.ninf, 0, "Add #33");
        this.test(this.pinf.add(this.pinf), this.pinf, 0, "Add #34");
        this.test(this.pinf.add(this.field.newDfp("0")), this.pinf, 0, "Add #35");
        this.test(this.pinf.add(this.field.newDfp("-1e131071")), this.pinf, 0, "Add #36");
        this.test(this.pinf.add(this.field.newDfp("1e131071")), this.pinf, 0, "Add #37");
        this.test(this.field.newDfp("0").add(this.pinf), this.pinf, 0, "Add #38");
        this.test(this.field.newDfp("-1e131071").add(this.pinf), this.pinf, 0, "Add #39");
        this.test(this.field.newDfp("1e131071").add(this.pinf), this.pinf, 0, "Add #40");
        this.test(this.ninf.add(this.field.newDfp("0")), this.ninf, 0, "Add #41");
        this.test(this.ninf.add(this.field.newDfp("-1e131071")), this.ninf, 0, "Add #42");
        this.test(this.ninf.add(this.field.newDfp("1e131071")), this.ninf, 0, "Add #43");
        this.test(this.field.newDfp("0").add(this.ninf), this.ninf, 0, "Add #44");
        this.test(this.field.newDfp("-1e131071").add(this.ninf), this.ninf, 0, "Add #45");
        this.test(this.field.newDfp("1e131071").add(this.ninf), this.ninf, 0, "Add #46");
        this.test(this.field.newDfp("9.9999999999999999999e131071").add(this.field.newDfp("5e131051")), this.pinf, 4, "Add #47");
        this.test(this.field.newDfp("9.9999999999999999999e131071").add(this.field.newDfp("4.9999999999999999999e131051")), this.field.newDfp("9.9999999999999999999e131071"), 16, "Add #48");
        this.test(this.nan.add(this.field.newDfp("1")), this.nan, 0, "Add #49");
        this.test(this.field.newDfp("1").add(this.nan), this.nan, 0, "Add #50");
        this.test(this.field.newDfp("12345678123456781234").add(this.field.newDfp("0.12345678123456781234")), this.field.newDfp("12345678123456781234"), 16, "Add #51");
        this.test(this.field.newDfp("12345678123456781234").add(this.field.newDfp("123.45678123456781234")), this.field.newDfp("12345678123456781357"), 16, "Add #52");
        this.test(this.field.newDfp("123.45678123456781234").add(this.field.newDfp("12345678123456781234")), this.field.newDfp("12345678123456781357"), 16, "Add #53");
        this.test(this.field.newDfp("12345678123456781234").add(this.field.newDfp(".00001234567812345678")), this.field.newDfp("12345678123456781234"), 16, "Add #54");
        this.test(this.field.newDfp("12345678123456781234").add(this.field.newDfp(".00000000123456781234")), this.field.newDfp("12345678123456781234"), 16, "Add #55");
        this.test(this.field.newDfp("-0").add(this.field.newDfp("-0")), this.field.newDfp("-0"), 0, "Add #56");
        this.test(this.field.newDfp("0").add(this.field.newDfp("-0")), this.field.newDfp("0"), 0, "Add #57");
        this.test(this.field.newDfp("-0").add(this.field.newDfp("0")), this.field.newDfp("0"), 0, "Add #58");
        this.test(this.field.newDfp("0").add(this.field.newDfp("0")), this.field.newDfp("0"), 0, "Add #59");
    }

    private void cmptst(Dfp a, Dfp b, String op, boolean result, double num) {
        if (op == "equal" && a.equals((Object)b) != result) {
            Assert.fail((String)("assersion failed.  " + op + " compare #" + num));
        }
        if (op == "unequal" && a.unequal(b) != result) {
            Assert.fail((String)("assersion failed.  " + op + " compare #" + num));
        }
        if (op == "lessThan" && a.lessThan(b) != result) {
            Assert.fail((String)("assersion failed.  " + op + " compare #" + num));
        }
        if (op == "greaterThan" && a.greaterThan(b) != result) {
            Assert.fail((String)("assersion failed.  " + op + " compare #" + num));
        }
    }

    @Test
    public void testCompare() {
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("0"), "equal", true, 1.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-0"), "equal", true, 2.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("-0"), "equal", true, 3.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("0"), "equal", true, 4.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1"), "equal", false, 5.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("0"), "equal", false, 6.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("0"), "equal", false, 7.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-1"), "equal", false, 8.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131072"), "equal", false, 9.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131078"), "equal", false, 10.0);
        if (this.field.getIEEEFlags() != 8) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e+131071"), "equal", false, 11.0);
        this.cmptst(this.field.newDfp("0"), this.pinf, "equal", false, 12.0);
        this.cmptst(this.field.newDfp("0"), this.ninf, "equal", false, 13.0);
        this.cmptst(this.field.newDfp("-0"), this.pinf, "equal", false, 14.0);
        this.cmptst(this.field.newDfp("-0"), this.ninf, "equal", false, 15.0);
        this.cmptst(this.pinf, this.field.newDfp("0"), "equal", false, 16.0);
        this.cmptst(this.ninf, this.field.newDfp("0"), "equal", false, 17.0);
        this.cmptst(this.pinf, this.field.newDfp("-0"), "equal", false, 18.0);
        this.cmptst(this.ninf, this.field.newDfp("-0"), "equal", false, 19.0);
        this.cmptst(this.ninf, this.pinf, "equal", false, 19.1);
        this.cmptst(this.pinf, this.ninf, "equal", false, 19.11);
        this.cmptst(this.pinf, this.pinf, "equal", true, 19.12);
        this.cmptst(this.ninf, this.ninf, "equal", true, 19.13);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1"), "equal", true, 20.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("-1"), "equal", false, 21.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("-1"), "equal", true, 22.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1.0000000000000001"), "equal", false, 23.0);
        this.cmptst(this.field.newDfp("1e20"), this.field.newDfp("1.0000000000000001"), "equal", false, 24.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0.000001"), this.field.newDfp("1e-6"), "equal", true, 25.0);
        this.cmptst(this.snan, this.snan, "equal", false, 27.0);
        this.cmptst(this.qnan, this.qnan, "equal", false, 28.0);
        this.cmptst(this.snan, this.qnan, "equal", false, 29.0);
        this.cmptst(this.qnan, this.snan, "equal", false, 30.0);
        this.cmptst(this.qnan, this.field.newDfp("0"), "equal", false, 31.0);
        this.cmptst(this.snan, this.field.newDfp("0"), "equal", false, 32.0);
        this.cmptst(this.field.newDfp("0"), this.snan, "equal", false, 33.0);
        this.cmptst(this.field.newDfp("0"), this.qnan, "equal", false, 34.0);
        this.cmptst(this.qnan, this.pinf, "equal", false, 35.0);
        this.cmptst(this.snan, this.pinf, "equal", false, 36.0);
        this.cmptst(this.pinf, this.snan, "equal", false, 37.0);
        this.cmptst(this.pinf, this.qnan, "equal", false, 38.0);
        this.cmptst(this.qnan, this.ninf, "equal", false, 39.0);
        this.cmptst(this.snan, this.ninf, "equal", false, 40.0);
        this.cmptst(this.ninf, this.snan, "equal", false, 41.0);
        this.cmptst(this.ninf, this.qnan, "equal", false, 42.0);
        this.cmptst(this.qnan, this.field.newDfp("-1"), "equal", false, 43.0);
        this.cmptst(this.snan, this.field.newDfp("-1"), "equal", false, 44.0);
        this.cmptst(this.field.newDfp("-1"), this.snan, "equal", false, 45.0);
        this.cmptst(this.field.newDfp("-1"), this.qnan, "equal", false, 46.0);
        this.cmptst(this.qnan, this.field.newDfp("1"), "equal", false, 47.0);
        this.cmptst(this.snan, this.field.newDfp("1"), "equal", false, 48.0);
        this.cmptst(this.field.newDfp("1"), this.snan, "equal", false, 49.0);
        this.cmptst(this.field.newDfp("1"), this.qnan, "equal", false, 50.0);
        this.cmptst(this.snan.negate(), this.snan, "equal", false, 51.0);
        this.cmptst(this.qnan.negate(), this.qnan, "equal", false, 52.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("0"), "unequal", false, 1.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-0"), "unequal", false, 2.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("-0"), "unequal", false, 3.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("0"), "unequal", false, 4.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1"), "unequal", true, 5.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("0"), "unequal", true, 6.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("0"), "unequal", true, 7.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-1"), "unequal", true, 8.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131072"), "unequal", true, 9.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131078"), "unequal", true, 10.0);
        if (this.field.getIEEEFlags() != 8) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e+131071"), "unequal", true, 11.0);
        this.cmptst(this.field.newDfp("0"), this.pinf, "unequal", true, 12.0);
        this.cmptst(this.field.newDfp("0"), this.ninf, "unequal", true, 13.0);
        this.cmptst(this.field.newDfp("-0"), this.pinf, "unequal", true, 14.0);
        this.cmptst(this.field.newDfp("-0"), this.ninf, "unequal", true, 15.0);
        this.cmptst(this.pinf, this.field.newDfp("0"), "unequal", true, 16.0);
        this.cmptst(this.ninf, this.field.newDfp("0"), "unequal", true, 17.0);
        this.cmptst(this.pinf, this.field.newDfp("-0"), "unequal", true, 18.0);
        this.cmptst(this.ninf, this.field.newDfp("-0"), "unequal", true, 19.0);
        this.cmptst(this.ninf, this.pinf, "unequal", true, 19.1);
        this.cmptst(this.pinf, this.ninf, "unequal", true, 19.11);
        this.cmptst(this.pinf, this.pinf, "unequal", false, 19.12);
        this.cmptst(this.ninf, this.ninf, "unequal", false, 19.13);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1"), "unequal", false, 20.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("-1"), "unequal", true, 21.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("-1"), "unequal", false, 22.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1.0000000000000001"), "unequal", true, 23.0);
        this.cmptst(this.field.newDfp("1e20"), this.field.newDfp("1.0000000000000001"), "unequal", true, 24.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0.000001"), this.field.newDfp("1e-6"), "unequal", false, 25.0);
        this.cmptst(this.snan, this.snan, "unequal", false, 27.0);
        this.cmptst(this.qnan, this.qnan, "unequal", false, 28.0);
        this.cmptst(this.snan, this.qnan, "unequal", false, 29.0);
        this.cmptst(this.qnan, this.snan, "unequal", false, 30.0);
        this.cmptst(this.qnan, this.field.newDfp("0"), "unequal", false, 31.0);
        this.cmptst(this.snan, this.field.newDfp("0"), "unequal", false, 32.0);
        this.cmptst(this.field.newDfp("0"), this.snan, "unequal", false, 33.0);
        this.cmptst(this.field.newDfp("0"), this.qnan, "unequal", false, 34.0);
        this.cmptst(this.qnan, this.pinf, "unequal", false, 35.0);
        this.cmptst(this.snan, this.pinf, "unequal", false, 36.0);
        this.cmptst(this.pinf, this.snan, "unequal", false, 37.0);
        this.cmptst(this.pinf, this.qnan, "unequal", false, 38.0);
        this.cmptst(this.qnan, this.ninf, "unequal", false, 39.0);
        this.cmptst(this.snan, this.ninf, "unequal", false, 40.0);
        this.cmptst(this.ninf, this.snan, "unequal", false, 41.0);
        this.cmptst(this.ninf, this.qnan, "unequal", false, 42.0);
        this.cmptst(this.qnan, this.field.newDfp("-1"), "unequal", false, 43.0);
        this.cmptst(this.snan, this.field.newDfp("-1"), "unequal", false, 44.0);
        this.cmptst(this.field.newDfp("-1"), this.snan, "unequal", false, 45.0);
        this.cmptst(this.field.newDfp("-1"), this.qnan, "unequal", false, 46.0);
        this.cmptst(this.qnan, this.field.newDfp("1"), "unequal", false, 47.0);
        this.cmptst(this.snan, this.field.newDfp("1"), "unequal", false, 48.0);
        this.cmptst(this.field.newDfp("1"), this.snan, "unequal", false, 49.0);
        this.cmptst(this.field.newDfp("1"), this.qnan, "unequal", false, 50.0);
        this.cmptst(this.snan.negate(), this.snan, "unequal", false, 51.0);
        this.cmptst(this.qnan.negate(), this.qnan, "unequal", false, 52.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare unequal flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("0"), "lessThan", false, 1.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-0"), "lessThan", false, 2.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("-0"), "lessThan", false, 3.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("0"), "lessThan", false, 4.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1"), "lessThan", true, 5.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("0"), "lessThan", false, 6.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("0"), "lessThan", true, 7.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-1"), "lessThan", false, 8.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131072"), "lessThan", true, 9.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131078"), "lessThan", true, 10.0);
        if (this.field.getIEEEFlags() != 8) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e+131071"), "lessThan", true, 11.0);
        this.cmptst(this.field.newDfp("0"), this.pinf, "lessThan", true, 12.0);
        this.cmptst(this.field.newDfp("0"), this.ninf, "lessThan", false, 13.0);
        this.cmptst(this.field.newDfp("-0"), this.pinf, "lessThan", true, 14.0);
        this.cmptst(this.field.newDfp("-0"), this.ninf, "lessThan", false, 15.0);
        this.cmptst(this.pinf, this.field.newDfp("0"), "lessThan", false, 16.0);
        this.cmptst(this.ninf, this.field.newDfp("0"), "lessThan", true, 17.0);
        this.cmptst(this.pinf, this.field.newDfp("-0"), "lessThan", false, 18.0);
        this.cmptst(this.ninf, this.field.newDfp("-0"), "lessThan", true, 19.0);
        this.cmptst(this.ninf, this.pinf, "lessThan", true, 19.1);
        this.cmptst(this.pinf, this.ninf, "lessThan", false, 19.11);
        this.cmptst(this.pinf, this.pinf, "lessThan", false, 19.12);
        this.cmptst(this.ninf, this.ninf, "lessThan", false, 19.13);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1"), "lessThan", false, 20.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("-1"), "lessThan", false, 21.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("-1"), "lessThan", false, 22.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1.0000000000000001"), "lessThan", true, 23.0);
        this.cmptst(this.field.newDfp("1e20"), this.field.newDfp("1.0000000000000001"), "lessThan", false, 24.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0.000001"), this.field.newDfp("1e-6"), "lessThan", false, 25.0);
        this.cmptst(this.snan, this.snan, "lessThan", false, 27.0);
        this.cmptst(this.qnan, this.qnan, "lessThan", false, 28.0);
        this.cmptst(this.snan, this.qnan, "lessThan", false, 29.0);
        this.cmptst(this.qnan, this.snan, "lessThan", false, 30.0);
        this.cmptst(this.qnan, this.field.newDfp("0"), "lessThan", false, 31.0);
        this.cmptst(this.snan, this.field.newDfp("0"), "lessThan", false, 32.0);
        this.cmptst(this.field.newDfp("0"), this.snan, "lessThan", false, 33.0);
        this.cmptst(this.field.newDfp("0"), this.qnan, "lessThan", false, 34.0);
        this.cmptst(this.qnan, this.pinf, "lessThan", false, 35.0);
        this.cmptst(this.snan, this.pinf, "lessThan", false, 36.0);
        this.cmptst(this.pinf, this.snan, "lessThan", false, 37.0);
        this.cmptst(this.pinf, this.qnan, "lessThan", false, 38.0);
        this.cmptst(this.qnan, this.ninf, "lessThan", false, 39.0);
        this.cmptst(this.snan, this.ninf, "lessThan", false, 40.0);
        this.cmptst(this.ninf, this.snan, "lessThan", false, 41.0);
        this.cmptst(this.ninf, this.qnan, "lessThan", false, 42.0);
        this.cmptst(this.qnan, this.field.newDfp("-1"), "lessThan", false, 43.0);
        this.cmptst(this.snan, this.field.newDfp("-1"), "lessThan", false, 44.0);
        this.cmptst(this.field.newDfp("-1"), this.snan, "lessThan", false, 45.0);
        this.cmptst(this.field.newDfp("-1"), this.qnan, "lessThan", false, 46.0);
        this.cmptst(this.qnan, this.field.newDfp("1"), "lessThan", false, 47.0);
        this.cmptst(this.snan, this.field.newDfp("1"), "lessThan", false, 48.0);
        this.cmptst(this.field.newDfp("1"), this.snan, "lessThan", false, 49.0);
        this.cmptst(this.field.newDfp("1"), this.qnan, "lessThan", false, 50.0);
        this.cmptst(this.snan.negate(), this.snan, "lessThan", false, 51.0);
        this.cmptst(this.qnan.negate(), this.qnan, "lessThan", false, 52.0);
        if (this.field.getIEEEFlags() != 1) {
            Assert.fail((String)("assersion failed.  compare lessThan flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("0"), "greaterThan", false, 1.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-0"), "greaterThan", false, 2.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("-0"), "greaterThan", false, 3.0);
        this.cmptst(this.field.newDfp("-0"), this.field.newDfp("0"), "greaterThan", false, 4.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1"), "greaterThan", false, 5.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("0"), "greaterThan", true, 6.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("0"), "greaterThan", false, 7.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("-1"), "greaterThan", true, 8.0);
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131072"), "greaterThan", false, 9.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e-131078"), "greaterThan", false, 10.0);
        if (this.field.getIEEEFlags() != 8) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
        this.cmptst(this.field.newDfp("0"), this.field.newDfp("1e+131071"), "greaterThan", false, 11.0);
        this.cmptst(this.field.newDfp("0"), this.pinf, "greaterThan", false, 12.0);
        this.cmptst(this.field.newDfp("0"), this.ninf, "greaterThan", true, 13.0);
        this.cmptst(this.field.newDfp("-0"), this.pinf, "greaterThan", false, 14.0);
        this.cmptst(this.field.newDfp("-0"), this.ninf, "greaterThan", true, 15.0);
        this.cmptst(this.pinf, this.field.newDfp("0"), "greaterThan", true, 16.0);
        this.cmptst(this.ninf, this.field.newDfp("0"), "greaterThan", false, 17.0);
        this.cmptst(this.pinf, this.field.newDfp("-0"), "greaterThan", true, 18.0);
        this.cmptst(this.ninf, this.field.newDfp("-0"), "greaterThan", false, 19.0);
        this.cmptst(this.ninf, this.pinf, "greaterThan", false, 19.1);
        this.cmptst(this.pinf, this.ninf, "greaterThan", true, 19.11);
        this.cmptst(this.pinf, this.pinf, "greaterThan", false, 19.12);
        this.cmptst(this.ninf, this.ninf, "greaterThan", false, 19.13);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1"), "greaterThan", false, 20.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("-1"), "greaterThan", true, 21.0);
        this.cmptst(this.field.newDfp("-1"), this.field.newDfp("-1"), "greaterThan", false, 22.0);
        this.cmptst(this.field.newDfp("1"), this.field.newDfp("1.0000000000000001"), "greaterThan", false, 23.0);
        this.cmptst(this.field.newDfp("1e20"), this.field.newDfp("1.0000000000000001"), "greaterThan", true, 24.0);
        if (this.field.getIEEEFlags() != 0) {
            Assert.fail((String)("assersion failed.  compare flags = " + this.field.getIEEEFlags()));
        }
        this.cmptst(this.field.newDfp("0.000001"), this.field.newDfp("1e-6"), "greaterThan", false, 25.0);
        this.cmptst(this.snan, this.snan, "greaterThan", false, 27.0);
        this.cmptst(this.qnan, this.qnan, "greaterThan", false, 28.0);
        this.cmptst(this.snan, this.qnan, "greaterThan", false, 29.0);
        this.cmptst(this.qnan, this.snan, "greaterThan", false, 30.0);
        this.cmptst(this.qnan, this.field.newDfp("0"), "greaterThan", false, 31.0);
        this.cmptst(this.snan, this.field.newDfp("0"), "greaterThan", false, 32.0);
        this.cmptst(this.field.newDfp("0"), this.snan, "greaterThan", false, 33.0);
        this.cmptst(this.field.newDfp("0"), this.qnan, "greaterThan", false, 34.0);
        this.cmptst(this.qnan, this.pinf, "greaterThan", false, 35.0);
        this.cmptst(this.snan, this.pinf, "greaterThan", false, 36.0);
        this.cmptst(this.pinf, this.snan, "greaterThan", false, 37.0);
        this.cmptst(this.pinf, this.qnan, "greaterThan", false, 38.0);
        this.cmptst(this.qnan, this.ninf, "greaterThan", false, 39.0);
        this.cmptst(this.snan, this.ninf, "greaterThan", false, 40.0);
        this.cmptst(this.ninf, this.snan, "greaterThan", false, 41.0);
        this.cmptst(this.ninf, this.qnan, "greaterThan", false, 42.0);
        this.cmptst(this.qnan, this.field.newDfp("-1"), "greaterThan", false, 43.0);
        this.cmptst(this.snan, this.field.newDfp("-1"), "greaterThan", false, 44.0);
        this.cmptst(this.field.newDfp("-1"), this.snan, "greaterThan", false, 45.0);
        this.cmptst(this.field.newDfp("-1"), this.qnan, "greaterThan", false, 46.0);
        this.cmptst(this.qnan, this.field.newDfp("1"), "greaterThan", false, 47.0);
        this.cmptst(this.snan, this.field.newDfp("1"), "greaterThan", false, 48.0);
        this.cmptst(this.field.newDfp("1"), this.snan, "greaterThan", false, 49.0);
        this.cmptst(this.field.newDfp("1"), this.qnan, "greaterThan", false, 50.0);
        this.cmptst(this.snan.negate(), this.snan, "greaterThan", false, 51.0);
        this.cmptst(this.qnan.negate(), this.qnan, "greaterThan", false, 52.0);
        if (this.field.getIEEEFlags() != 1) {
            Assert.fail((String)("assersion failed.  compare greaterThan flags = " + this.field.getIEEEFlags()));
        }
        this.field.clearIEEEFlags();
    }

    @Test
    public void testMultiply() {
        this.test(this.field.newDfp("1").multiply(this.field.newDfp("1")), this.field.newDfp("1"), 0, "Multiply #1");
        this.test(this.field.newDfp("1").multiply(1), this.field.newDfp("1"), 0, "Multiply #2");
        this.test(this.field.newDfp("-1").multiply(this.field.newDfp("1")), this.field.newDfp("-1"), 0, "Multiply #3");
        this.test(this.field.newDfp("-1").multiply(1), this.field.newDfp("-1"), 0, "Multiply #4");
        this.test(this.field.newDfp("2").multiply(this.field.newDfp("3")), this.field.newDfp("6"), 0, "Multiply #5");
        this.test(this.field.newDfp("2").multiply(3), this.field.newDfp("6"), 0, "Multiply #6");
        this.test(this.field.newDfp("-2").multiply(this.field.newDfp("3")), this.field.newDfp("-6"), 0, "Multiply #7");
        this.test(this.field.newDfp("-2").multiply(3), this.field.newDfp("-6"), 0, "Multiply #8");
        this.test(this.field.newDfp("2").multiply(this.field.newDfp("-3")), this.field.newDfp("-6"), 0, "Multiply #9");
        this.test(this.field.newDfp("-2").multiply(this.field.newDfp("-3")), this.field.newDfp("6"), 0, "Multiply #10");
        this.test(this.field.newDfp("-2").multiply(this.field.newDfp("0")), this.field.newDfp("-0"), 0, "Multiply #11");
        this.test(this.field.newDfp("-2").multiply(0), this.field.newDfp("-0"), 0, "Multiply #12");
        this.test(this.field.newDfp("2").multiply(this.field.newDfp("0")), this.field.newDfp("0"), 0, "Multiply #13");
        this.test(this.field.newDfp("2").multiply(0), this.field.newDfp("0"), 0, "Multiply #14");
        this.test(this.field.newDfp("2").multiply(this.pinf), this.pinf, 0, "Multiply #15");
        this.test(this.field.newDfp("2").multiply(this.ninf), this.ninf, 0, "Multiply #16");
        this.test(this.field.newDfp("-2").multiply(this.pinf), this.ninf, 0, "Multiply #17");
        this.test(this.field.newDfp("-2").multiply(this.ninf), this.pinf, 0, "Multiply #18");
        this.test(this.ninf.multiply(this.field.newDfp("-2")), this.pinf, 0, "Multiply #18.1");
        this.test(this.field.newDfp("5e131071").multiply(2), this.pinf, 4, "Multiply #19");
        this.test(this.field.newDfp("5e131071").multiply(this.field.newDfp("1.999999999999999")), this.field.newDfp("9.9999999999999950000e131071"), 0, "Multiply #20");
        this.test(this.field.newDfp("-5e131071").multiply(2), this.ninf, 4, "Multiply #22");
        this.test(this.field.newDfp("-5e131071").multiply(this.field.newDfp("1.999999999999999")), this.field.newDfp("-9.9999999999999950000e131071"), 0, "Multiply #23");
        this.test(this.field.newDfp("1e-65539").multiply(this.field.newDfp("1e-65539")), this.field.newDfp("1e-131078"), 8, "Multiply #24");
        this.test(this.field.newDfp("1").multiply(this.nan), this.nan, 0, "Multiply #25");
        this.test(this.nan.multiply(this.field.newDfp("1")), this.nan, 0, "Multiply #26");
        this.test(this.nan.multiply(this.pinf), this.nan, 0, "Multiply #27");
        this.test(this.pinf.multiply(this.nan), this.nan, 0, "Multiply #27");
        this.test(this.pinf.multiply(this.field.newDfp("0")), this.nan, 1, "Multiply #28");
        this.test(this.field.newDfp("0").multiply(this.pinf), this.nan, 1, "Multiply #29");
        this.test(this.pinf.multiply(this.pinf), this.pinf, 0, "Multiply #30");
        this.test(this.ninf.multiply(this.pinf), this.ninf, 0, "Multiply #31");
        this.test(this.pinf.multiply(this.ninf), this.ninf, 0, "Multiply #32");
        this.test(this.ninf.multiply(this.ninf), this.pinf, 0, "Multiply #33");
        this.test(this.pinf.multiply(1), this.pinf, 0, "Multiply #34");
        this.test(this.pinf.multiply(0), this.nan, 1, "Multiply #35");
        this.test(this.nan.multiply(1), this.nan, 0, "Multiply #36");
        this.test(this.field.newDfp("1").multiply(10000), this.field.newDfp("10000"), 0, "Multiply #37");
        this.test(this.field.newDfp("2").multiply(1000000), this.field.newDfp("2000000"), 0, "Multiply #38");
        this.test(this.field.newDfp("1").multiply(-1), this.field.newDfp("-1"), 0, "Multiply #39");
    }

    @Test
    public void testDivide() {
        this.test(this.field.newDfp("1").divide(this.nan), this.nan, 0, "Divide #1");
        this.test(this.nan.divide(this.field.newDfp("1")), this.nan, 0, "Divide #2");
        this.test(this.pinf.divide(this.field.newDfp("1")), this.pinf, 0, "Divide #3");
        this.test(this.pinf.divide(this.field.newDfp("-1")), this.ninf, 0, "Divide #4");
        this.test(this.pinf.divide(this.pinf), this.nan, 1, "Divide #5");
        this.test(this.ninf.divide(this.pinf), this.nan, 1, "Divide #6");
        this.test(this.pinf.divide(this.ninf), this.nan, 1, "Divide #7");
        this.test(this.ninf.divide(this.ninf), this.nan, 1, "Divide #8");
        this.test(this.field.newDfp("0").divide(this.field.newDfp("0")), this.nan, 2, "Divide #9");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("0")), this.pinf, 2, "Divide #10");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("-0")), this.ninf, 2, "Divide #11");
        this.test(this.field.newDfp("-1").divide(this.field.newDfp("0")), this.ninf, 2, "Divide #12");
        this.test(this.field.newDfp("-1").divide(this.field.newDfp("-0")), this.pinf, 2, "Divide #13");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("3")), this.field.newDfp("0.33333333333333333333"), 16, "Divide #14");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("6")), this.field.newDfp("0.16666666666666666667"), 16, "Divide #15");
        this.test(this.field.newDfp("10").divide(this.field.newDfp("6")), this.field.newDfp("1.6666666666666667"), 16, "Divide #16");
        this.test(this.field.newDfp("100").divide(this.field.newDfp("6")), this.field.newDfp("16.6666666666666667"), 16, "Divide #17");
        this.test(this.field.newDfp("1000").divide(this.field.newDfp("6")), this.field.newDfp("166.6666666666666667"), 16, "Divide #18");
        this.test(this.field.newDfp("10000").divide(this.field.newDfp("6")), this.field.newDfp("1666.6666666666666667"), 16, "Divide #19");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("1")), this.field.newDfp("1"), 0, "Divide #20");
        this.test(this.field.newDfp("1").divide(this.field.newDfp("-1")), this.field.newDfp("-1"), 0, "Divide #21");
        this.test(this.field.newDfp("-1").divide(this.field.newDfp("1")), this.field.newDfp("-1"), 0, "Divide #22");
        this.test(this.field.newDfp("-1").divide(this.field.newDfp("-1")), this.field.newDfp("1"), 0, "Divide #23");
        this.test(this.field.newDfp("1e-65539").divide(this.field.newDfp("1e65539")), this.field.newDfp("1e-131078"), 8, "Divide #24");
        this.test(this.field.newDfp("1e65539").divide(this.field.newDfp("1e-65539")), this.pinf, 4, "Divide #24");
        this.test(this.field.newDfp("2").divide(this.field.newDfp("1.5")), this.field.newDfp("1.3333333333333333"), 16, "Divide #25");
        this.test(this.field.newDfp("2").divide(this.pinf), this.field.newDfp("0"), 0, "Divide #26");
        this.test(this.field.newDfp("2").divide(this.ninf), this.field.newDfp("-0"), 0, "Divide #27");
        this.test(this.field.newDfp("0").divide(this.field.newDfp("1")), this.field.newDfp("0"), 0, "Divide #28");
    }

    @Test
    public void testReciprocal() {
        this.test(this.nan.reciprocal(), this.nan, 0, "Reciprocal #1");
        this.test(this.field.newDfp("0").reciprocal(), this.pinf, 2, "Reciprocal #2");
        this.test(this.field.newDfp("-0").reciprocal(), this.ninf, 2, "Reciprocal #3");
        this.test(this.field.newDfp("3").reciprocal(), this.field.newDfp("0.33333333333333333333"), 16, "Reciprocal #4");
        this.test(this.field.newDfp("6").reciprocal(), this.field.newDfp("0.16666666666666666667"), 16, "Reciprocal #5");
        this.test(this.field.newDfp("1").reciprocal(), this.field.newDfp("1"), 0, "Reciprocal #6");
        this.test(this.field.newDfp("-1").reciprocal(), this.field.newDfp("-1"), 0, "Reciprocal #7");
        this.test(this.pinf.reciprocal(), this.field.newDfp("0"), 0, "Reciprocal #8");
        this.test(this.ninf.reciprocal(), this.field.newDfp("-0"), 0, "Reciprocal #9");
    }

    @Test
    public void testDivideInt() {
        this.test(this.nan.divide(1), this.nan, 0, "DivideInt #1");
        this.test(this.pinf.divide(1), this.pinf, 0, "DivideInt #2");
        this.test(this.field.newDfp("0").divide(0), this.nan, 2, "DivideInt #3");
        this.test(this.field.newDfp("1").divide(0), this.pinf, 2, "DivideInt #4");
        this.test(this.field.newDfp("-1").divide(0), this.ninf, 2, "DivideInt #5");
        this.test(this.field.newDfp("1").divide(3), this.field.newDfp("0.33333333333333333333"), 16, "DivideInt #6");
        this.test(this.field.newDfp("1").divide(6), this.field.newDfp("0.16666666666666666667"), 16, "DivideInt #7");
        this.test(this.field.newDfp("10").divide(6), this.field.newDfp("1.6666666666666667"), 16, "DivideInt #8");
        this.test(this.field.newDfp("100").divide(6), this.field.newDfp("16.6666666666666667"), 16, "DivideInt #9");
        this.test(this.field.newDfp("1000").divide(6), this.field.newDfp("166.6666666666666667"), 16, "DivideInt #10");
        this.test(this.field.newDfp("10000").divide(6), this.field.newDfp("1666.6666666666666667"), 16, "DivideInt #20");
        this.test(this.field.newDfp("1").divide(1), this.field.newDfp("1"), 0, "DivideInt #21");
        this.test(this.field.newDfp("1e-131077").divide(10), this.field.newDfp("1e-131078"), 8, "DivideInt #22");
        this.test(this.field.newDfp("0").divide(1), this.field.newDfp("0"), 0, "DivideInt #23");
        this.test(this.field.newDfp("1").divide(10000), this.nan, 1, "DivideInt #24");
        this.test(this.field.newDfp("1").divide(-1), this.nan, 1, "DivideInt #25");
    }

    @Test
    public void testNextAfter() {
        this.test(this.field.newDfp("1").nextAfter(this.pinf), this.field.newDfp("1.0000000000000001"), 0, "NextAfter #1");
        this.test(this.field.newDfp("1.0000000000000001").nextAfter(this.ninf), this.field.newDfp("1"), 0, "NextAfter #1.5");
        this.test(this.field.newDfp("1").nextAfter(this.ninf), this.field.newDfp("0.99999999999999999999"), 0, "NextAfter #2");
        this.test(this.field.newDfp("0.99999999999999999999").nextAfter(this.field.newDfp("2")), this.field.newDfp("1"), 0, "NextAfter #3");
        this.test(this.field.newDfp("-1").nextAfter(this.ninf), this.field.newDfp("-1.0000000000000001"), 0, "NextAfter #4");
        this.test(this.field.newDfp("-1").nextAfter(this.pinf), this.field.newDfp("-0.99999999999999999999"), 0, "NextAfter #5");
        this.test(this.field.newDfp("-0.99999999999999999999").nextAfter(this.field.newDfp("-2")), this.field.newDfp("-1"), 0, "NextAfter #6");
        this.test(this.field.newDfp("2").nextAfter(this.field.newDfp("2")), this.field.newDfp("2"), 0, "NextAfter #7");
        this.test(this.field.newDfp("0").nextAfter(this.field.newDfp("0")), this.field.newDfp("0"), 0, "NextAfter #8");
        this.test(this.field.newDfp("-2").nextAfter(this.field.newDfp("-2")), this.field.newDfp("-2"), 0, "NextAfter #9");
        this.test(this.field.newDfp("0").nextAfter(this.field.newDfp("1")), this.field.newDfp("1e-131092"), 8, "NextAfter #10");
        this.test(this.field.newDfp("0").nextAfter(this.field.newDfp("-1")), this.field.newDfp("-1e-131092"), 8, "NextAfter #11");
        this.test(this.field.newDfp("-1e-131092").nextAfter(this.pinf), this.field.newDfp("-0"), 24, "Next After #12");
        this.test(this.field.newDfp("1e-131092").nextAfter(this.ninf), this.field.newDfp("0"), 24, "Next After #13");
        this.test(this.field.newDfp("9.9999999999999999999e131078").nextAfter(this.pinf), this.pinf, 20, "Next After #14");
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"toString #1", (Object)"Infinity", (Object)this.pinf.toString());
        Assert.assertEquals((String)"toString #2", (Object)"-Infinity", (Object)this.ninf.toString());
        Assert.assertEquals((String)"toString #3", (Object)"NaN", (Object)this.nan.toString());
        Assert.assertEquals((String)"toString #4", (Object)"NaN", (Object)this.field.newDfp((byte)1, (byte)3).toString());
        Assert.assertEquals((String)"toString #5", (Object)"NaN", (Object)this.field.newDfp((byte)1, (byte)2).toString());
        Assert.assertEquals((String)"toString #6", (Object)"1.2300000000000000e100", (Object)this.field.newDfp("1.23e100").toString());
        Assert.assertEquals((String)"toString #7", (Object)"-1.2300000000000000e100", (Object)this.field.newDfp("-1.23e100").toString());
        Assert.assertEquals((String)"toString #8", (Object)"12345678.1234", (Object)this.field.newDfp("12345678.1234").toString());
        Assert.assertEquals((String)"toString #9", (Object)"0.00001234", (Object)this.field.newDfp("0.00001234").toString());
    }

    @Override
    @Test
    public void testRound() {
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_DOWN);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.9")), this.field.newDfp("12345678901234567890"), 16, "Round #1");
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.99999999")), this.field.newDfp("12345678901234567890"), 16, "Round #2");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.99999999")), this.field.newDfp("-12345678901234567890"), 16, "Round #3");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_UP);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.1")), this.field.newDfp("12345678901234567891"), 16, "Round #4");
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.0001")), this.field.newDfp("12345678901234567891"), 16, "Round #5");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.1")), this.field.newDfp("-12345678901234567891"), 16, "Round #6");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.0001")), this.field.newDfp("-12345678901234567891"), 16, "Round #7");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_HALF_UP);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.4999")), this.field.newDfp("12345678901234567890"), 16, "Round #8");
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.5000")), this.field.newDfp("12345678901234567891"), 16, "Round #9");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.4999")), this.field.newDfp("-12345678901234567890"), 16, "Round #10");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.5000")), this.field.newDfp("-12345678901234567891"), 16, "Round #11");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_HALF_DOWN);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.5001")), this.field.newDfp("12345678901234567891"), 16, "Round #12");
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.5000")), this.field.newDfp("12345678901234567890"), 16, "Round #13");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.5001")), this.field.newDfp("-12345678901234567891"), 16, "Round #14");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.5000")), this.field.newDfp("-12345678901234567890"), 16, "Round #15");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_HALF_ODD);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.5000")), this.field.newDfp("12345678901234567891"), 16, "Round #16");
        this.test(this.field.newDfp("12345678901234567891").add(this.field.newDfp("0.5000")), this.field.newDfp("12345678901234567891"), 16, "Round #17");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.5000")), this.field.newDfp("-12345678901234567891"), 16, "Round #18");
        this.test(this.field.newDfp("-12345678901234567891").add(this.field.newDfp("-0.5000")), this.field.newDfp("-12345678901234567891"), 16, "Round #19");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_CEIL);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.0001")), this.field.newDfp("12345678901234567891"), 16, "Round #20");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.9999")), this.field.newDfp("-12345678901234567890"), 16, "Round #21");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_FLOOR);
        this.test(this.field.newDfp("12345678901234567890").add(this.field.newDfp("0.9999")), this.field.newDfp("12345678901234567890"), 16, "Round #22");
        this.test(this.field.newDfp("-12345678901234567890").add(this.field.newDfp("-0.0001")), this.field.newDfp("-12345678901234567891"), 16, "Round #23");
        this.field.setRoundingMode(DfpField.RoundingMode.ROUND_HALF_EVEN);
    }

    @Override
    @Test
    public void testCeil() {
        this.test(this.field.newDfp("1234.0000000000000001").ceil(), this.field.newDfp("1235"), 16, "Ceil #1");
    }

    @Override
    @Test
    public void testFloor() {
        this.test(this.field.newDfp("1234.9999999999999999").floor(), this.field.newDfp("1234"), 16, "Floor #1");
    }

    @Override
    @Test
    public void testRint() {
        this.test(this.field.newDfp("1234.50000000001").rint(), this.field.newDfp("1235"), 16, "Rint #1");
        this.test(this.field.newDfp("1234.5000").rint(), this.field.newDfp("1234"), 16, "Rint #2");
        this.test(this.field.newDfp("1235.5000").rint(), this.field.newDfp("1236"), 16, "Rint #3");
    }

    @Test
    public void testCopySign() {
        this.test(Dfp.copysign((Dfp)this.field.newDfp("1234."), (Dfp)this.field.newDfp("-1")), this.field.newDfp("-1234"), 0, "CopySign #1");
        this.test(Dfp.copysign((Dfp)this.field.newDfp("-1234."), (Dfp)this.field.newDfp("-1")), this.field.newDfp("-1234"), 0, "CopySign #2");
        this.test(Dfp.copysign((Dfp)this.field.newDfp("-1234."), (Dfp)this.field.newDfp("1")), this.field.newDfp("1234"), 0, "CopySign #3");
        this.test(Dfp.copysign((Dfp)this.field.newDfp("1234."), (Dfp)this.field.newDfp("1")), this.field.newDfp("1234"), 0, "CopySign #4");
    }

    @Test
    public void testIntValue() {
        Assert.assertEquals((String)"intValue #1", (long)1234L, (long)this.field.newDfp("1234").intValue());
        Assert.assertEquals((String)"intValue #2", (long)-1234L, (long)this.field.newDfp("-1234").intValue());
        Assert.assertEquals((String)"intValue #3", (long)1234L, (long)this.field.newDfp("1234.5").intValue());
        Assert.assertEquals((String)"intValue #4", (long)1235L, (long)this.field.newDfp("1234.500001").intValue());
        Assert.assertEquals((String)"intValue #5", (long)Integer.MAX_VALUE, (long)this.field.newDfp("1e1000").intValue());
        Assert.assertEquals((String)"intValue #6", (long)Integer.MIN_VALUE, (long)this.field.newDfp("-1e1000").intValue());
    }

    @Test
    public void testLog10K() {
        Assert.assertEquals((String)"log10K #1", (long)1L, (long)this.field.newDfp("123456").log10K());
        Assert.assertEquals((String)"log10K #2", (long)2L, (long)this.field.newDfp("123456789").log10K());
        Assert.assertEquals((String)"log10K #3", (long)0L, (long)this.field.newDfp("2").log10K());
        Assert.assertEquals((String)"log10K #3", (long)0L, (long)this.field.newDfp("1").log10K());
        Assert.assertEquals((String)"log10K #4", (long)-1L, (long)this.field.newDfp("0.1").log10K());
    }

    @Test
    public void testPower10K() {
        Dfp d = this.field.newDfp();
        this.test(d.power10K(0), this.field.newDfp("1"), 0, "Power10 #1");
        this.test(d.power10K(1), this.field.newDfp("10000"), 0, "Power10 #2");
        this.test(d.power10K(2), this.field.newDfp("100000000"), 0, "Power10 #3");
        this.test(d.power10K(-1), this.field.newDfp("0.0001"), 0, "Power10 #4");
        this.test(d.power10K(-2), this.field.newDfp("0.00000001"), 0, "Power10 #5");
        this.test(d.power10K(-3), this.field.newDfp("0.000000000001"), 0, "Power10 #6");
    }

    @Test
    public void testLog10() {
        Assert.assertEquals((String)"log10 #1", (long)1L, (long)this.field.newDfp("12").intLog10());
        Assert.assertEquals((String)"log10 #2", (long)2L, (long)this.field.newDfp("123").intLog10());
        Assert.assertEquals((String)"log10 #3", (long)3L, (long)this.field.newDfp("1234").intLog10());
        Assert.assertEquals((String)"log10 #4", (long)4L, (long)this.field.newDfp("12345").intLog10());
        Assert.assertEquals((String)"log10 #5", (long)5L, (long)this.field.newDfp("123456").intLog10());
        Assert.assertEquals((String)"log10 #6", (long)6L, (long)this.field.newDfp("1234567").intLog10());
        Assert.assertEquals((String)"log10 #6", (long)7L, (long)this.field.newDfp("12345678").intLog10());
        Assert.assertEquals((String)"log10 #7", (long)8L, (long)this.field.newDfp("123456789").intLog10());
        Assert.assertEquals((String)"log10 #8", (long)9L, (long)this.field.newDfp("1234567890").intLog10());
        Assert.assertEquals((String)"log10 #9", (long)10L, (long)this.field.newDfp("12345678901").intLog10());
        Assert.assertEquals((String)"log10 #10", (long)11L, (long)this.field.newDfp("123456789012").intLog10());
        Assert.assertEquals((String)"log10 #11", (long)12L, (long)this.field.newDfp("1234567890123").intLog10());
        Assert.assertEquals((String)"log10 #12", (long)0L, (long)this.field.newDfp("2").intLog10());
        Assert.assertEquals((String)"log10 #13", (long)0L, (long)this.field.newDfp("1").intLog10());
        Assert.assertEquals((String)"log10 #14", (long)-1L, (long)this.field.newDfp("0.12").intLog10());
        Assert.assertEquals((String)"log10 #15", (long)-2L, (long)this.field.newDfp("0.012").intLog10());
    }

    @Test
    public void testPower10() {
        Dfp d = this.field.newDfp();
        this.test(d.power10(0), this.field.newDfp("1"), 0, "Power10 #1");
        this.test(d.power10(1), this.field.newDfp("10"), 0, "Power10 #2");
        this.test(d.power10(2), this.field.newDfp("100"), 0, "Power10 #3");
        this.test(d.power10(3), this.field.newDfp("1000"), 0, "Power10 #4");
        this.test(d.power10(4), this.field.newDfp("10000"), 0, "Power10 #5");
        this.test(d.power10(5), this.field.newDfp("100000"), 0, "Power10 #6");
        this.test(d.power10(6), this.field.newDfp("1000000"), 0, "Power10 #7");
        this.test(d.power10(7), this.field.newDfp("10000000"), 0, "Power10 #8");
        this.test(d.power10(8), this.field.newDfp("100000000"), 0, "Power10 #9");
        this.test(d.power10(9), this.field.newDfp("1000000000"), 0, "Power10 #10");
        this.test(d.power10(-1), this.field.newDfp(".1"), 0, "Power10 #11");
        this.test(d.power10(-2), this.field.newDfp(".01"), 0, "Power10 #12");
        this.test(d.power10(-3), this.field.newDfp(".001"), 0, "Power10 #13");
        this.test(d.power10(-4), this.field.newDfp(".0001"), 0, "Power10 #14");
        this.test(d.power10(-5), this.field.newDfp(".00001"), 0, "Power10 #15");
        this.test(d.power10(-6), this.field.newDfp(".000001"), 0, "Power10 #16");
        this.test(d.power10(-7), this.field.newDfp(".0000001"), 0, "Power10 #17");
        this.test(d.power10(-8), this.field.newDfp(".00000001"), 0, "Power10 #18");
        this.test(d.power10(-9), this.field.newDfp(".000000001"), 0, "Power10 #19");
        this.test(d.power10(-10), this.field.newDfp(".0000000001"), 0, "Power10 #20");
    }

    @Test
    public void testRemainder() {
        this.test(this.field.newDfp("10").remainder(this.field.newDfp("3")), this.field.newDfp("1"), 16, "Remainder #1");
        this.test(this.field.newDfp("9").remainder(this.field.newDfp("3")), this.field.newDfp("0"), 0, "Remainder #2");
        this.test(this.field.newDfp("-9").remainder(this.field.newDfp("3")), this.field.newDfp("-0"), 0, "Remainder #3");
    }

    @Override
    @Test
    public void testSqrt() {
        this.test(this.field.newDfp("0").sqrt(), this.field.newDfp("0"), 0, "Sqrt #1");
        this.test(this.field.newDfp("-0").sqrt(), this.field.newDfp("-0"), 0, "Sqrt #2");
        this.test(this.field.newDfp("1").sqrt(), this.field.newDfp("1"), 0, "Sqrt #3");
        this.test(this.field.newDfp("2").sqrt(), this.field.newDfp("1.4142135623730950"), 16, "Sqrt #4");
        this.test(this.field.newDfp("3").sqrt(), this.field.newDfp("1.7320508075688773"), 16, "Sqrt #5");
        this.test(this.field.newDfp("5").sqrt(), this.field.newDfp("2.2360679774997897"), 16, "Sqrt #6");
        this.test(this.field.newDfp("500").sqrt(), this.field.newDfp("22.3606797749978970"), 16, "Sqrt #6.2");
        this.test(this.field.newDfp("50000").sqrt(), this.field.newDfp("223.6067977499789696"), 16, "Sqrt #6.3");
        this.test(this.field.newDfp("-1").sqrt(), this.nan, 1, "Sqrt #7");
        this.test(this.pinf.sqrt(), this.pinf, 0, "Sqrt #8");
        this.test(this.field.newDfp((byte)1, (byte)3).sqrt(), this.nan, 0, "Sqrt #9");
        this.test(this.field.newDfp((byte)1, (byte)2).sqrt(), this.nan, 1, "Sqrt #9");
    }

    @Test
    public void testIssue567() {
        DfpField field = new DfpField(100);
        Assert.assertEquals((double)0.0, (double)field.getZero().toDouble(), (double)Precision.SAFE_MIN);
        Assert.assertEquals((double)0.0, (double)field.newDfp(0.0).toDouble(), (double)Precision.SAFE_MIN);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)field.newDfp(-0.0).toDouble()), (double)Precision.EPSILON);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)field.newDfp(0.0).toDouble()), (double)Precision.EPSILON);
    }

    @Test
    public void testIsZero() {
        Assert.assertTrue((boolean)this.field.getZero().isZero());
        Assert.assertTrue((boolean)this.field.getZero().negate().isZero());
        Assert.assertTrue((boolean)this.field.newDfp(0.0).isZero());
        Assert.assertTrue((boolean)this.field.newDfp(-0.0).isZero());
        Assert.assertFalse((boolean)this.field.newDfp(1.0E-90).isZero());
        Assert.assertFalse((boolean)this.nan.isZero());
        Assert.assertFalse((boolean)this.nan.negate().isZero());
        Assert.assertFalse((boolean)this.pinf.isZero());
        Assert.assertFalse((boolean)this.pinf.negate().isZero());
        Assert.assertFalse((boolean)this.ninf.isZero());
        Assert.assertFalse((boolean)this.ninf.negate().isZero());
    }

    @Test
    public void testSignPredicates() {
        Assert.assertTrue((boolean)this.field.getZero().negativeOrNull());
        Assert.assertTrue((boolean)this.field.getZero().positiveOrNull());
        Assert.assertFalse((boolean)this.field.getZero().strictlyNegative());
        Assert.assertFalse((boolean)this.field.getZero().strictlyPositive());
        Assert.assertTrue((boolean)this.field.getZero().negate().negativeOrNull());
        Assert.assertTrue((boolean)this.field.getZero().negate().positiveOrNull());
        Assert.assertFalse((boolean)this.field.getZero().negate().strictlyNegative());
        Assert.assertFalse((boolean)this.field.getZero().negate().strictlyPositive());
        Assert.assertFalse((boolean)this.field.getOne().negativeOrNull());
        Assert.assertTrue((boolean)this.field.getOne().positiveOrNull());
        Assert.assertFalse((boolean)this.field.getOne().strictlyNegative());
        Assert.assertTrue((boolean)this.field.getOne().strictlyPositive());
        Assert.assertTrue((boolean)this.field.getOne().negate().negativeOrNull());
        Assert.assertFalse((boolean)this.field.getOne().negate().positiveOrNull());
        Assert.assertTrue((boolean)this.field.getOne().negate().strictlyNegative());
        Assert.assertFalse((boolean)this.field.getOne().negate().strictlyPositive());
        Assert.assertFalse((boolean)this.nan.negativeOrNull());
        Assert.assertFalse((boolean)this.nan.positiveOrNull());
        Assert.assertFalse((boolean)this.nan.strictlyNegative());
        Assert.assertFalse((boolean)this.nan.strictlyPositive());
        Assert.assertFalse((boolean)this.nan.negate().negativeOrNull());
        Assert.assertFalse((boolean)this.nan.negate().positiveOrNull());
        Assert.assertFalse((boolean)this.nan.negate().strictlyNegative());
        Assert.assertFalse((boolean)this.nan.negate().strictlyPositive());
        Assert.assertFalse((boolean)this.pinf.negativeOrNull());
        Assert.assertTrue((boolean)this.pinf.positiveOrNull());
        Assert.assertFalse((boolean)this.pinf.strictlyNegative());
        Assert.assertTrue((boolean)this.pinf.strictlyPositive());
        Assert.assertTrue((boolean)this.pinf.negate().negativeOrNull());
        Assert.assertFalse((boolean)this.pinf.negate().positiveOrNull());
        Assert.assertTrue((boolean)this.pinf.negate().strictlyNegative());
        Assert.assertFalse((boolean)this.pinf.negate().strictlyPositive());
        Assert.assertTrue((boolean)this.ninf.negativeOrNull());
        Assert.assertFalse((boolean)this.ninf.positiveOrNull());
        Assert.assertTrue((boolean)this.ninf.strictlyNegative());
        Assert.assertFalse((boolean)this.ninf.strictlyPositive());
        Assert.assertFalse((boolean)this.ninf.negate().negativeOrNull());
        Assert.assertTrue((boolean)this.ninf.negate().positiveOrNull());
        Assert.assertFalse((boolean)this.ninf.negate().strictlyNegative());
        Assert.assertTrue((boolean)this.ninf.negate().strictlyPositive());
    }

    @Test
    public void testSpecialConstructors() {
        Assert.assertEquals((Object)this.ninf, (Object)this.field.newDfp(Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)this.ninf, (Object)this.field.newDfp("-Infinity"));
        Assert.assertEquals((Object)this.pinf, (Object)this.field.newDfp(Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)this.pinf, (Object)this.field.newDfp("Infinity"));
        Assert.assertTrue((boolean)this.field.newDfp(Double.NaN).isNaN());
        Assert.assertTrue((boolean)this.field.newDfp("NaN").isNaN());
    }

    @Test
    public void testEqualsHashcodeContract() {
        DfpField var1 = new DfpField(1);
        Dfp var6 = var1.newDfp(-0.0);
        Dfp var5 = var1.newDfp(0L);
        Assert.assertTrue((boolean)(var5.equals((Object)var6) ? var5.hashCode() == var6.hashCode() : true));
    }
}

