/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class GeometricDistributionTest
extends IntegerDistributionAbstractTest {
    public GeometricDistributionTest() {
        this.setTolerance(1.0E-12);
    }

    public IntegerDistribution makeDistribution() {
        return new GeometricDistribution(0.4);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.4, 0.24, 0.144, 0.0864, 0.05184, 0.031104, 0.0186624, 0.01119744, 0.006718464, 0.0040310784, 0.00241864704, 0.001451188224, 8.707129344E-4, 5.2242776064E-4, 3.13456656384E-4, 1.8807399383E-4, 1.12844396298E-4, 6.77066377789E-5, 4.06239826674E-5, 2.43743896004E-5, 1.46246337603E-5, 8.77478025615E-6, 5.26486815369E-6, 3.15892089221E-6, 1.89535253533E-6, 1.1372115212E-6, 6.82326912718E-7, 4.09396147631E-7, 2.45637688579E-7};
    }

    public double[] makeLogDensityTestValues() {
        return new double[]{Double.NEGATIVE_INFINITY, -0.916290731874155, -1.42711635564015, -1.93794197940614, -2.44876760317213, -2.95959322693812, -3.47041885070411, -3.9812444744701, -4.49207009823609, -5.00289572200208, -5.51372134576807, -6.02454696953406, -6.53537259330005, -7.04619821706604, -7.55702384083203, -8.06784946459802, -8.57867508836402, -9.08950071213001, -9.600326335896, -10.111151959662, -10.621977583428, -11.132803207194, -11.64362883096, -12.154454454726, -12.6652800784919, -13.1761057022579, -13.6869313260239, -14.1977569497899, -14.7085825735559, -15.2194081973219};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        double[] densities = this.makeDensityTestValues();
        int n = densities.length;
        double[] ret = new double[n];
        ret[0] = densities[0];
        for (int i = 1; i < n; ++i) {
            ret[i] = ret[i - 1] + densities[i];
        }
        return ret;
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.055, 0.06, 0.065, 0.07, 0.075, 0.08, 0.085, 0.09, 0.095, 0.1, 0.105, 0.11, 0.115, 0.12, 0.125, 0.13, 0.135, 0.14, 0.145, 0.15, 0.155, 0.16, 0.165, 0.17, 0.175, 0.18, 0.185, 0.19, 0.195, 0.2, 0.205, 0.21, 0.215, 0.22, 0.225, 0.23, 0.235, 0.24, 0.245, 0.25, 0.255, 0.26, 0.265, 0.27, 0.275, 0.28, 0.285, 0.29, 0.295, 0.3, 0.305, 0.31, 0.315, 0.32, 0.325, 0.33, 0.335, 0.34, 0.345, 0.35, 0.355, 0.36, 0.365, 0.37, 0.375, 0.38, 0.385, 0.39, 0.395, 0.4, 0.405, 0.41, 0.415, 0.42, 0.425, 0.43, 0.435, 0.44, 0.445, 0.45, 0.455, 0.46, 0.465, 0.47, 0.475, 0.48, 0.485, 0.49, 0.495, 0.5, 0.505, 0.51, 0.515, 0.52, 0.525, 0.53, 0.535, 0.54, 0.545, 0.55, 0.555, 0.56, 0.565, 0.57, 0.575, 0.58, 0.585, 0.59, 0.595, 0.6, 0.605, 0.61, 0.615, 0.62, 0.625, 0.63, 0.635, 0.64, 0.645, 0.65, 0.655, 0.66, 0.665, 0.67, 0.675, 0.68, 0.685, 0.69, 0.695, 0.7, 0.705, 0.71, 0.715, 0.72, 0.725, 0.73, 0.735, 0.74, 0.745, 0.75, 0.755, 0.76, 0.765, 0.77, 0.775, 0.78, 0.785, 0.79, 0.795, 0.8, 0.805, 0.81, 0.815, 0.82, 0.825, 0.83, 0.835, 0.84, 0.845, 0.85, 0.855, 0.86, 0.865, 0.87, 0.875, 0.88, 0.885, 0.89, 0.895, 0.9, 0.905, 0.91, 0.915, 0.92, 0.925, 0.93, 0.935, 0.94, 0.945, 0.95, 0.955, 0.96, 0.965, 0.97, 0.975, 0.98, 0.985, 0.99, 0.995, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 8, 9, 10, Integer.MAX_VALUE};
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        GeometricDistribution dist = new GeometricDistribution(0.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)2.0, (double)1.0E-9);
        dist = new GeometricDistribution(0.3);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)2.3333333333333335, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)7.777777777777778, (double)1.0E-9);
    }
}

