/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class InverseHilbertMatrix
extends RealLinearOperator {
    private final int n;

    public InverseHilbertMatrix(int n) {
        this.n = n;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public long getEntry(int i, int j) {
        long val = i + j + 1;
        long aux = CombinatoricsUtils.binomialCoefficient((int)(this.n + i), (int)(this.n - j - 1));
        val = ArithmeticUtils.mulAndCheck((long)val, (long)aux);
        aux = CombinatoricsUtils.binomialCoefficient((int)(this.n + j), (int)(this.n - i - 1));
        val = ArithmeticUtils.mulAndCheck((long)val, (long)aux);
        aux = CombinatoricsUtils.binomialCoefficient((int)(i + j), (int)i);
        val = ArithmeticUtils.mulAndCheck((long)val, (long)aux);
        val = ArithmeticUtils.mulAndCheck((long)val, (long)aux);
        return (i + j & 1) == 0 ? val : -val;
    }

    public int getRowDimension() {
        return this.n;
    }

    public RealVector operate(RealVector x) {
        if (x.getDimension() != this.n) {
            throw new DimensionMismatchException(x.getDimension(), this.n);
        }
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double pos = 0.0;
            double neg = 0.0;
            for (int j = 0; j < this.n; ++j) {
                double xj = x.getEntry(j);
                long coeff = this.getEntry(i, j);
                double daux = (double)coeff * xj;
                if (daux > 0.0) {
                    pos += daux;
                    continue;
                }
                neg += daux;
            }
            y[i] = pos + neg;
        }
        return new ArrayRealVector(y, false);
    }
}

