/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.SquareNeighbourhood;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.junit.Assert;
import org.junit.Test;

public class LocationFinderTest {
    final FeatureInitializer init = FeatureInitializerFactory.uniform((double)0.0, (double)2.0);

    @Test
    public void test2x2Network() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D map = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray);
        LocationFinder finder = new LocationFinder(map);
        Network net = map.getNetwork();
        LocationFinder.Location loc = finder.getLocation(net.getNeuron(0L));
        Assert.assertEquals((long)0L, (long)loc.getRow());
        Assert.assertEquals((long)0L, (long)loc.getColumn());
        loc = finder.getLocation(net.getNeuron(1L));
        Assert.assertEquals((long)0L, (long)loc.getRow());
        Assert.assertEquals((long)1L, (long)loc.getColumn());
        loc = finder.getLocation(net.getNeuron(2L));
        Assert.assertEquals((long)1L, (long)loc.getRow());
        Assert.assertEquals((long)0L, (long)loc.getColumn());
        loc = finder.getLocation(net.getNeuron(3L));
        Assert.assertEquals((long)1L, (long)loc.getRow());
        Assert.assertEquals((long)1L, (long)loc.getColumn());
    }
}

