/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.TextStringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TextStringBuilderAppendInsertTest {
    private static final String SEP = System.lineSeparator();
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    TextStringBuilderAppendInsertTest() {
    }

    @Test
    void testAppend_Boolean() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(true);
        Assertions.assertEquals((Object)"true", (Object)sb.toString());
        sb.append(false);
        Assertions.assertEquals((Object)"truefalse", (Object)sb.toString());
        sb.append('!');
        Assertions.assertEquals((Object)"truefalse!", (Object)sb.toString());
    }

    @Test
    void testAppend_CharArray() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((char[])null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append(ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(new char[]{'f', 'o', 'o'});
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
    }

    @Test
    void testAppend_CharArray_int_int() {
        TextStringBuilder sb0 = new TextStringBuilder();
        sb0.setNullText("NULL").append((char[])null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb0.toString());
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, -1, 1), (String)"append(char[], -1,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, 3, 1), (String)"append(char[], 3,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, 1, -1), (String)"append(char[],, -1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, 1, 3), (String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, -1, 3), (String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new char[]{'b', 'a', 'r'}, 4, 0), (String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_FormattedString() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("Hi", (Object[])null);
        Assertions.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append("Hi", new Object[]{"Alice"});
        Assertions.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append("Hi %s", new Object[]{"Alice"});
        Assertions.assertEquals((Object)"Hi Alice", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append("Hi %s %,d", new Object[]{"Alice", 5000});
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        String expected = "Hi Alice 5" + groupingSeparator + "000";
        Assertions.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    void testAppend_Object() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendNull();
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(FOO);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assertions.assertEquals((Object)"foobaz", (Object)sb.toString());
        sb.append(new TextStringBuilder("yes"));
        Assertions.assertEquals((Object)"foobazyes", (Object)sb.toString());
        sb.append((CharSequence)"Seq");
        Assertions.assertEquals((Object)"foobazyesSeq", (Object)sb.toString());
        sb.append(new StringBuilder("bld"));
        Assertions.assertEquals((Object)"foobazyesSeqbld", (Object)sb.toString());
    }

    @Test
    void testAppend_PrimitiveNumber() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(0);
        Assertions.assertEquals((Object)"0", (Object)sb.toString());
        sb.append(1L);
        Assertions.assertEquals((Object)"01", (Object)sb.toString());
        sb.append(2.3f);
        Assertions.assertEquals((Object)"012.3", (Object)sb.toString());
        sb.append(4.5);
        Assertions.assertEquals((Object)"012.34.5", (Object)sb.toString());
    }

    @Test
    void testAppend_String() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("bar");
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_String_int_int() {
        TextStringBuilder sb0 = new TextStringBuilder();
        sb0.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb0.toString());
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("foo", 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", -1, 1), (String)"append(char[], -1,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", 3, 1), (String)"append(char[], 3,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", 1, -1), (String)"append(char[],, -1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", 1, 3), (String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", -1, 3), (String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append("bar", 4, 0), (String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append((CharSequence)"bar", 2, 1), (String)"append(char[], 2, 1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append((CharSequence)"bar", 2, 2), (String)"append(char[], 2, 2) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append((CharSequence)"bar", 2, -2), (String)"append(char[], 2, -2) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append((CharSequence)"bar", 2, 0), (String)"append(char[], 2, 0) expected IndexOutOfBoundsException");
        sb.append("bar", 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("abcbardef", 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append((CharSequence)"abcbardef", 4, 7);
        Assertions.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuffer() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append(new StringBuffer("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuffer_int_int() {
        TextStringBuilder sb0 = new TextStringBuilder();
        sb0.setNullText("NULL").append((StringBuffer)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb0.toString());
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), -1, 1), (String)"append(char[], -1,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), 3, 1), (String)"append(char[], 3,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), 1, -1), (String)"append(char[],, -1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), 1, 3), (String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), -1, 3), (String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuffer("bar"), 4, 0), (String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new StringBuffer("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuilder() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append(new StringBuilder("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuilder_int_int() {
        TextStringBuilder sb0 = new TextStringBuilder();
        sb0.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb0.toString());
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(new StringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), -1, 1), (String)"append(StringBuilder, -1,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), 3, 1), (String)"append(StringBuilder, 3,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), 1, -1), (String)"append(StringBuilder,, -1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), 1, 3), (String)"append(StringBuilder, 1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), -1, 3), (String)"append(StringBuilder, -1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new StringBuilder("bar"), 4, 0), (String)"append(StringBuilder, 4, 0) expected IndexOutOfBoundsException");
        sb.append(new StringBuilder("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 4, 3);
        Assertions.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    void testAppend_TextStringBuilder() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL").append((TextStringBuilder)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new TextStringBuilder();
        sb.append(new TextStringBuilder("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new TextStringBuilder(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new TextStringBuilder("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_TextStringBuilder_int_int() {
        TextStringBuilder sb0 = new TextStringBuilder();
        sb0.setNullText("NULL").append((TextStringBuilder)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb0.toString());
        TextStringBuilder sb = new TextStringBuilder();
        sb.append(new TextStringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), -1, 1), (String)"append(char[], -1,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), 3, 1), (String)"append(char[], 3,) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), 1, -1), (String)"append(char[],, -1) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), 1, 3), (String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), -1, 3), (String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.append(new TextStringBuilder("bar"), 4, 0), (String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new TextStringBuilder("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new TextStringBuilder("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Array() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Object[])null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(new Object[0]);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Collection() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Iterable)null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Iterator() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendAll((Iterator)null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadLeft() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"o", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        Assertions.assertEquals((Object)"oo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        Assertions.assertEquals((Object)"-foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"-------foo", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        Assertions.assertEquals((Object)"-null", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadLeft_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        Assertions.assertEquals((Object)"3", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        Assertions.assertEquals((Object)"23", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        Assertions.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        Assertions.assertEquals((Object)"-123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"-------123", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadRight() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"f", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        Assertions.assertEquals((Object)"fo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        Assertions.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"foo-------", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        Assertions.assertEquals((Object)"null-", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadRight_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        Assertions.assertEquals((Object)"1", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        Assertions.assertEquals((Object)"12", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        Assertions.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        Assertions.assertEquals((Object)"123-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"123-------", (Object)sb.toString());
    }

    @Test
    void testAppendln_Boolean() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(true);
        Assertions.assertEquals((Object)("true" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(false);
        Assertions.assertEquals((Object)("false" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_CharArray() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        char[] input = "foo".toCharArray();
        sb.appendln(input);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append(input);
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_CharArray_int_int() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        char[] input = "foo".toCharArray();
        sb.appendln(input, 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append(input, 0, 3);
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_FormattedString() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln("Hello %s", new Object[]{"Alice"});
        Assertions.assertEquals((Object)("Hello Alice" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)2))).append(ArgumentMatchers.anyString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_Object() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(null);
        Assertions.assertEquals((Object)("" + SEP), (Object)sb.toString());
        sb.appendln(FOO);
        Assertions.assertEquals((Object)(SEP + "foo" + SEP), (Object)sb.toString());
        sb.appendln((Object)6);
        Assertions.assertEquals((Object)(SEP + "foo" + SEP + "6" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_PrimitiveNumber() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendln(0);
        Assertions.assertEquals((Object)("0" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(1L);
        Assertions.assertEquals((Object)("1" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(2.3f);
        Assertions.assertEquals((Object)("2.3" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(4.5);
        Assertions.assertEquals((Object)("4.5" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_String() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln("foo");
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)2))).append(ArgumentMatchers.anyString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_String_int_int() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln("foo", 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)2))).append(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_StringBuffer() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new StringBuffer("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((StringBuffer)ArgumentMatchers.any(StringBuffer.class));
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_StringBuffer_int_int() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new StringBuffer("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((StringBuffer)ArgumentMatchers.any(StringBuffer.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_StringBuilder() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new StringBuilder("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((StringBuilder)ArgumentMatchers.any(StringBuilder.class));
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_StringBuilder_int_int() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new StringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((StringBuilder)ArgumentMatchers.any(StringBuilder.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_TextStringBuilder() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new TextStringBuilder("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((TextStringBuilder)ArgumentMatchers.any(TextStringBuilder.class));
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendln_TextStringBuilder_int_int() {
        TextStringBuilder sb = (TextStringBuilder)Mockito.spy((Object)new TextStringBuilder());
        sb.appendln(new TextStringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).append((TextStringBuilder)ArgumentMatchers.any(TextStringBuilder.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((TextStringBuilder)Mockito.verify((Object)sb, (VerificationMode)Mockito.times((int)1))).appendNewLine();
    }

    @Test
    void testAppendNewLine() {
        TextStringBuilder sb = new TextStringBuilder("---");
        sb.appendNewLine().append("+++");
        Assertions.assertEquals((Object)("---" + SEP + "+++"), (Object)sb.toString());
        sb = new TextStringBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        Assertions.assertEquals((Object)("---#" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendPadding() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(-1, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(0, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(1, '-');
        Assertions.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.appendPadding(16, '-');
        Assertions.assertEquals((int)20, (int)sb.length());
        Assertions.assertEquals((Object)"foo-----------------", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(',');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',');
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char_char() {
        TextStringBuilder sb = new TextStringBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        Assertions.assertEquals((Object)String.valueOf(':'), (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)(String.valueOf(':') + "foo"), (Object)sb.toString());
        sb.appendSeparator(',', ':');
        Assertions.assertEquals((Object)(String.valueOf(':') + "foo" + ','), (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(',', 0);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',', 1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(',', -1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",");
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String_int() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendSeparator(null, -1);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(null, 0);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(null, 1);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", -1);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", 0);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",", 1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(",", -1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String_String() {
        TextStringBuilder sb = new TextStringBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, null);
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, "order by ");
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"order by foo", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assertions.assertEquals((Object)"order by foo,", (Object)sb.toString());
    }

    @Test
    void testAppendWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("NULL");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendNull();
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb.append(null);
        Assertions.assertEquals((Object)"NULLNULL", (Object)sb.toString());
        sb.append(FOO);
        Assertions.assertEquals((Object)"NULLNULLfoo", (Object)sb.toString());
        sb.append((String)null);
        Assertions.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("");
        Assertions.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("bar");
        Assertions.assertEquals((Object)"NULLNULLfooNULLbar", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assertions.assertEquals((Object)"NULLNULLfooNULLbarNULL", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assertions.assertEquals((Object)"NULLNULLfooNULLbarNULLbaz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Array() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(ArrayUtils.EMPTY_OBJECT_ARRAY, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Collection() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Iterator() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparatorsWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
    }

    @Test
    void testInsert() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, FOO));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, FOO));
        sb.insert(0, null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, "foo"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, "foo"));
        sb.insert(0, (String)null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'f', 'o', 'o'}));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, new char[]{'f', 'o', 'o'}));
        sb.insert(0, (char[])null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'f', 'o', 'o'});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3));
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, ArrayUtils.EMPTY_CHAR_ARRAY, 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10));
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, true));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, true));
        sb.insert(0, true);
        Assertions.assertEquals((Object)"truebarbaz", (Object)sb.toString());
        sb.insert(0, false);
        Assertions.assertEquals((Object)"falsetruebarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, '!'));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, '!'));
        sb.insert(0, '!');
        Assertions.assertEquals((Object)"!barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 0));
        sb.insert(0, '0');
        Assertions.assertEquals((Object)"0barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 1L));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 1L));
        sb.insert(0, 1L);
        Assertions.assertEquals((Object)"1barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 2.3f));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 2.3f));
        sb.insert(0, 2.3f);
        Assertions.assertEquals((Object)"2.3barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 4.5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, 4.5));
        sb.insert(0, 4.5);
        Assertions.assertEquals((Object)"4.5barbaz", (Object)sb.toString());
    }

    @Test
    void testInsertAtEnd() {
        TextStringBuilder sb = new TextStringBuilder();
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.insert(0, "Hello");
        Assertions.assertEquals((Object)"Hello", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, "World"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(6, "World"));
        sb.insert(5, true);
        Assertions.assertEquals((Object)"Hellotrue", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(10, false));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-20, false));
        sb.insert(9, 'A');
        Assertions.assertEquals((Object)"HellotrueA", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(11, 'B'));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-2, 'B'));
        sb.insert(10, new char[]{'B', 'C'});
        Assertions.assertEquals((Object)"HellotrueABC", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(13, new char[]{'D', 'E'}));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'D', 'E'}));
        sb.insert(12, new char[]{'D', 'E', 'F'}, 1, 1);
        Assertions.assertEquals((Object)"HellotrueABCE", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(14, new char[]{'G', 'H', 'I'}, 1, 2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, new char[]{'G', 'H', 'I'}, 1, 1));
        sb.insert(13, 1.2);
        Assertions.assertEquals((Object)"HellotrueABCE1.2", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(17, 1.3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, 1.3));
        sb.insert(16, 1.0f);
        Assertions.assertEquals((Object)"HellotrueABCE1.21.0", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(20, 1.3f));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-3, 1.3f));
        sb.insert(19, 23);
        Assertions.assertEquals((Object)"HellotrueABCE1.21.023", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(22, 20));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-5, -5));
        sb.insert(21, 99L);
        Assertions.assertEquals((Object)"HellotrueABCE1.21.02399", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(24, 22L));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, -1L));
        sb.insert(23, FOO);
        Assertions.assertEquals((Object)"HellotrueABCE1.21.02399foo", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(27, FOO));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-3, FOO));
    }

    @Test
    void testInsertWithNullText() {
        TextStringBuilder sb = new TextStringBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, FOO));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, FOO));
        sb.insert(0, null);
        Assertions.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assertions.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(-1, "foo"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sb.insert(7, "foo"));
        sb.insert(0, (String)null);
        Assertions.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assertions.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.insert(0, (char[])null);
        Assertions.assertEquals((Object)"nullfoonullbarbaz", (Object)sb.toString());
        sb.insert(0, (char[])null, 0, 0);
        Assertions.assertEquals((Object)"nullnullfoonullbarbaz", (Object)sb.toString());
    }

    @Test
    void testLang299() {
        TextStringBuilder sb = new TextStringBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"f", (Object)sb.toString());
    }
}

