/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import org.apache.creadur.tentacles.Configuration;
import org.apache.creadur.tentacles.FileSystem;
import org.apache.creadur.tentacles.Platform;

public class Layout {
    private final File localRootDirectory;
    private final File output;
    private final File repository;
    private final File contentRootDirectory;

    public Layout(Platform platform, Configuration configuration) {
        this.localRootDirectory = new File(configuration.getRootDirectoryForLocalOutput());
        FileSystem fileSystem = platform.getFileSystem();
        fileSystem.mkdirs(this.localRootDirectory);
        this.repository = new File(this.localRootDirectory, "repo");
        this.contentRootDirectory = new File(this.localRootDirectory, "content");
        this.output = this.localRootDirectory;
        fileSystem.mkdirs(this.repository);
        fileSystem.mkdirs(this.contentRootDirectory);
    }

    public File getLocalRootDirectory() {
        return this.localRootDirectory;
    }

    public File getOutputDirectory() {
        return this.output;
    }

    public File getRepositoryDirectory() {
        return this.repository;
    }

    public File getContentRootDirectory() {
        return this.contentRootDirectory;
    }
}

