/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

public class CollectionType
extends ArrayType {
    private AegisType componentType;

    public CollectionType(AegisType componentType) {
        this.componentType = componentType;
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        try {
            return this.readCollection(reader, null, context);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    @Override
    protected Collection<Object> createCollection() {
        Collection<Object> values;
        Class userTypeClass = this.getTypeClass();
        if (userTypeClass.isAssignableFrom(List.class)) {
            values = new ArrayList<Object>();
        } else if (userTypeClass.isAssignableFrom(LinkedList.class)) {
            values = new LinkedList();
        } else if (userTypeClass.isAssignableFrom(Set.class)) {
            values = new HashSet();
        } else if (userTypeClass.isAssignableFrom(SortedSet.class)) {
            values = new TreeSet();
        } else if (userTypeClass.isAssignableFrom(Vector.class)) {
            values = new Vector();
        } else if (userTypeClass.isAssignableFrom(Stack.class)) {
            values = new Stack();
        } else if (userTypeClass.isInterface()) {
            values = new ArrayList();
        } else {
            try {
                values = (Collection)userTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new DatabindingException("Could not create map implementation: " + userTypeClass.getName(), (Throwable)e);
            }
        }
        return values;
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        if (object == null) {
            return;
        }
        try {
            Collection list = (Collection)object;
            AegisType type = this.getComponentType();
            if (type == null) {
                throw new DatabindingException("Couldn't find component type for Collection.");
            }
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                String ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                this.writeValue(itr.next(), writer, context, type, type.getSchemaType().getLocalPart(), ns);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    @Override
    public AegisType getComponentType() {
        return this.componentType;
    }
}

