/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.lucene.document.DateTools;

public class DefaultParamConverterProvider
implements ParamConverterProvider {
    private final Map<Class<?>, ParamConverter<?>> converters = new HashMap();

    public DefaultParamConverterProvider() {
        this.converters.put(Date.class, new DateParamConverter());
        this.converters.put(Long.class, new LongParamConverter());
        this.converters.put(Double.class, new DoubleParamConverter());
        this.converters.put(Float.class, new FloatParamConverter());
        this.converters.put(Integer.class, new IntegerParamConverter());
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        for (Map.Entry<Class<?>, ParamConverter<?>> entry : this.converters.entrySet()) {
            if (!entry.getKey().isAssignableFrom(rawType)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static final class DateParamConverter
    implements ParamConverter<Date> {
        private DateParamConverter() {
        }

        public Date fromString(String value) {
            return SearchUtils.dateFromStringWithDefaultFormats(value);
        }

        public String toString(Date value) {
            return value != null ? DateTools.dateToString((Date)value, (DateTools.Resolution)DateTools.Resolution.MILLISECOND) : null;
        }
    }

    private static final class LongParamConverter
    implements ParamConverter<Long> {
        private LongParamConverter() {
        }

        public Long fromString(String value) {
            return Long.valueOf(value);
        }

        public String toString(Long value) {
            return Long.toString(value);
        }
    }

    private static final class DoubleParamConverter
    implements ParamConverter<Double> {
        private DoubleParamConverter() {
        }

        public Double fromString(String value) {
            return Double.valueOf(value);
        }

        public String toString(Double value) {
            return Double.toString(value);
        }
    }

    private static final class FloatParamConverter
    implements ParamConverter<Float> {
        private FloatParamConverter() {
        }

        public Float fromString(String value) {
            return Float.valueOf(value);
        }

        public String toString(Float value) {
            return Float.toString(value.floatValue());
        }
    }

    private static final class IntegerParamConverter
    implements ParamConverter<Integer> {
        private IntegerParamConverter() {
        }

        public Integer fromString(String value) {
            return Integer.valueOf(value);
        }

        public String toString(Integer value) {
            return Integer.toString(value);
        }
    }
}

