/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeBoolean
extends ScriptableObject {
    private static final long serialVersionUID = -3716996899943880933L;
    private static final String CLASS_NAME = "Boolean";
    private final boolean booleanValue;

    static void init(Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, NativeBoolean::js_constructorFunc, NativeBoolean::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.setPrototypeScriptable(new NativeBoolean(false));
        constructor.definePrototypeMethod(scope, "toString", 0, NativeBoolean::js_toString);
        constructor.definePrototypeMethod(scope, "toSource", 0, NativeBoolean::js_toSource);
        constructor.definePrototypeMethod(scope, "valueOf", 0, NativeBoolean::js_valueOf);
        ScriptableObject.defineProperty(scope, CLASS_NAME, constructor, 2);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
    }

    NativeBoolean(boolean b) {
        this.booleanValue = b;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static boolean toValue(Scriptable thisObj) {
        return ScriptableObject.ensureType((Object)thisObj, NativeBoolean.class, (String)CLASS_NAME).booleanValue;
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        if (typeHint == ScriptRuntime.BooleanClass) {
            return ScriptRuntime.wrapBoolean(this.booleanValue);
        }
        return super.getDefaultValue(typeHint);
    }

    private static Object js_constructorFunc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean b = ScriptRuntime.toBoolean(args.length > 0 ? args[0] : Undefined.instance);
        return ScriptRuntime.wrapBoolean(b);
    }

    private static NativeBoolean js_constructor(Context cx, Scriptable scope, Object[] args) {
        boolean b = ScriptRuntime.toBoolean(args.length > 0 ? args[0] : Undefined.instance);
        return new NativeBoolean(b);
    }

    private static String js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeBoolean.toValue(thisObj) ? "true" : "false";
    }

    private static Object js_valueOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeBoolean.toValue(thisObj);
    }

    private static Object js_toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return "(new Boolean(" + ScriptRuntime.toString(NativeBoolean.toValue(thisObj)) + "))";
    }
}

