/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import org.apache.daffodil.io.BacktrackingException;
import org.apache.daffodil.io.BucketingInputSource$;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputStreamReadZeroError;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Array$;
import scala.Int$;
import scala.collection.mutable.ArrayBuffer;

public class BucketingInputSource
extends InputSource {
    private final InputStream inputStream;
    private final int bucketSizeExponent;
    private final int maxCacheSizeInBytes;
    public final int org$apache$daffodil$io$BucketingInputSource$$bucketSize;
    private final int bucketMask;
    private final int maxNumberOfNonNullBuckets;
    private final ArrayBuffer<Bucket> buckets;
    private int oldestBucketIndex;
    private long curBytePosition0b;
    private long totalBytesBucketed;
    private long headBucketBytePosition0b;
    private int bytesFilledInLastBucket;
    private boolean hasMoreData;

    public static int $lessinit$greater$default$2() {
        return BucketingInputSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return BucketingInputSource$.MODULE$.$lessinit$greater$default$3();
    }

    public BucketingInputSource(InputStream inputStream, int bucketSizeExponent, int maxCacheSizeInBytes) {
        this.inputStream = inputStream;
        this.bucketSizeExponent = bucketSizeExponent;
        this.maxCacheSizeInBytes = maxCacheSizeInBytes;
        this.org$apache$daffodil$io$BucketingInputSource$$bucketSize = 1 << bucketSizeExponent;
        this.bucketMask = this.org$apache$daffodil$io$BucketingInputSource$$bucketSize - 1;
        this.maxNumberOfNonNullBuckets = Math.max(maxCacheSizeInBytes / this.org$apache$daffodil$io$BucketingInputSource$$bucketSize, 2);
        ArrayBuffer b = new ArrayBuffer();
        b.$plus$eq((Object)new Bucket());
        this.buckets = b;
        this.oldestBucketIndex = 0;
        this.curBytePosition0b = 0L;
        this.totalBytesBucketed = 0L;
        this.headBucketBytePosition0b = 0L;
        this.bytesFilledInLastBucket = 0;
        this.hasMoreData = true;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    @Override
    public boolean hasReachedEndOfData() {
        return !this.hasMoreData;
    }

    private boolean fillBucketsToIndex(int goalBucketIndex, int bytesNeededInBucket) {
        boolean needsMoreData;
        int lastBucketIndex = this.buckets.length() - 1;
        boolean bl = needsMoreData = goalBucketIndex > lastBucketIndex || goalBucketIndex == lastBucketIndex && bytesNeededInBucket > this.bytesFilledInLastBucket;
        while (needsMoreData && this.hasMoreData) {
            int emptyBytesInLastBucket = this.org$apache$daffodil$io$BucketingInputSource$$bucketSize - this.bytesFilledInLastBucket;
            if (emptyBytesInLastBucket <= 0) {
                throw Assert$.MODULE$.abort("Invariant broken: emptyBytesInLastBucket.>(0)");
            }
            int bytesRead = this.inputStream.read(((Bucket)this.buckets.apply(lastBucketIndex)).bytes(), this.bytesFilledInLastBucket, emptyBytesInLastBucket);
            if (bytesRead == 0) {
                throw new InputStreamReadZeroError(this.inputStream);
            }
            if (bytesRead == -1) {
                this.hasMoreData = false;
                continue;
            }
            this.totalBytesBucketed += (long)bytesRead;
            this.bytesFilledInLastBucket += bytesRead;
            if (this.bytesFilledInLastBucket == this.org$apache$daffodil$io$BucketingInputSource$$bucketSize) {
                this.buckets.$plus$eq((Object)new Bucket());
                this.bytesFilledInLastBucket = 0;
                if (++lastBucketIndex - this.oldestBucketIndex >= this.maxNumberOfNonNullBuckets) {
                    this.buckets.update(this.oldestBucketIndex, null);
                    ++this.oldestBucketIndex;
                }
            }
            if ((lastBucketIndex != goalBucketIndex || bytesNeededInBucket > this.bytesFilledInLastBucket) && lastBucketIndex <= goalBucketIndex) continue;
            needsMoreData = false;
        }
        return !needsMoreData;
    }

    private final int getBucketIndex(long bytePos0b) {
        return (int)(bytePos0b - this.headBucketBytePosition0b >>> this.bucketSizeExponent);
    }

    private final int getByteIndex(long bytePos0b) {
        return (int)(bytePos0b - this.headBucketBytePosition0b & (long)this.bucketMask);
    }

    @Override
    public boolean areBytesAvailable(long nBytes) {
        long finalBytePosition0b = this.curBytePosition0b + nBytes;
        if (finalBytePosition0b <= this.totalBytesBucketed) {
            return true;
        }
        int bucketIndex = this.getBucketIndex(finalBytePosition0b);
        int byteIndex = this.getByteIndex(finalBytePosition0b);
        if (bucketIndex < this.oldestBucketIndex) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.>=(BucketingInputSource.this.oldestBucketIndex)");
        }
        boolean filled = this.fillBucketsToIndex(bucketIndex, byteIndex);
        return filled;
    }

    @Override
    public long knownBytesAvailable() {
        long available = 0L;
        int curBucketIndex = this.getBucketIndex(this.curBytePosition0b);
        int curByteIndex = this.getByteIndex(this.curBytePosition0b);
        for (int i = curBucketIndex; i < this.buckets.length(); ++i) {
            int startByteIndex = i == curBucketIndex ? curByteIndex : 0;
            int endByteIndex = i == this.buckets.length() - 1 ? this.bytesFilledInLastBucket : this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
            int bytesAvailableInBucket = endByteIndex - startByteIndex;
            available += (long)bytesAvailableInBucket;
        }
        return available;
    }

    @Override
    public int get() {
        boolean hasByte = this.areBytesAvailable(1L);
        if (!hasByte) {
            return -1;
        }
        int bucketIndex = this.getBucketIndex(this.curBytePosition0b);
        int byteIndex = this.getByteIndex(this.curBytePosition0b);
        if (bucketIndex < 0 || this.buckets.apply(bucketIndex) == null) {
            throw new BacktrackingException(this.curBytePosition0b, this.maxCacheSizeInBytes);
        }
        byte by = ((Bucket)this.buckets.apply(bucketIndex)).bytes()[byteIndex];
        ++this.curBytePosition0b;
        return by & 0xFF;
    }

    @Override
    public boolean get(byte[] dest, int off, int len) {
        if (dest.length - off < len) {
            throw Assert$.MODULE$.abort("Invariant broken: dest.length.-(off).>=(len)");
        }
        boolean hasBytes = this.areBytesAvailable(Int$.MODULE$.int2long(len));
        if (!hasBytes) {
            return false;
        }
        int bucketIndex = this.getBucketIndex(this.curBytePosition0b);
        int byteIndex = this.getByteIndex(this.curBytePosition0b);
        int bytesStillToGet = len;
        int destOffset = off;
        while (bytesStillToGet > 0) {
            int bytesToGetFromCurrentBucket = Math.min(this.org$apache$daffodil$io$BucketingInputSource$$bucketSize - byteIndex, bytesStillToGet);
            if (bucketIndex < 0 || this.buckets.apply(bucketIndex) == null) {
                throw new BacktrackingException(this.curBytePosition0b, this.maxCacheSizeInBytes);
            }
            Array$.MODULE$.copy((Object)((Bucket)this.buckets.apply(bucketIndex)).bytes(), byteIndex, (Object)dest, destOffset, bytesToGetFromCurrentBucket);
            destOffset += bytesToGetFromCurrentBucket;
            bytesStillToGet -= bytesToGetFromCurrentBucket;
            ++bucketIndex;
            byteIndex = 0;
        }
        this.curBytePosition0b += (long)len;
        return true;
    }

    @Override
    public long position() {
        return this.curBytePosition0b;
    }

    @Override
    public void position(long bytePos0b) {
        int bucketIndex = this.getBucketIndex(bytePos0b);
        if (bucketIndex >= this.buckets.length()) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.<(BucketingInputSource.this.buckets.length)");
        }
        this.curBytePosition0b = bytePos0b;
    }

    @Override
    public void lockPosition(long bytePos0b) {
        int bucketIndex = this.getBucketIndex(bytePos0b);
        if (bucketIndex >= this.buckets.length()) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.<(BucketingInputSource.this.buckets.length)");
        }
        if (this.buckets.apply(bucketIndex) != null) {
            Bucket bucket = (Bucket)this.buckets.apply(bucketIndex);
            bucket.refCount_$eq(bucket.refCount() + 1);
            return;
        }
    }

    @Override
    public void releasePosition(long bytePos0b) {
        int bucketIndex = this.getBucketIndex(bytePos0b);
        if (this.buckets.apply(bucketIndex) != null) {
            if (bucketIndex < this.oldestBucketIndex || bucketIndex >= this.buckets.length()) {
                throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.>=(BucketingInputSource.this.oldestBucketIndex).&&(bucketIndex.<(BucketingInputSource.this.buckets.length))");
            }
            Bucket bucket = (Bucket)this.buckets.apply(bucketIndex);
            bucket.refCount_$eq(bucket.refCount() - 1);
        }
        if (((Bucket)this.buckets.apply(this.oldestBucketIndex)).refCount() == 0) {
            this.releaseBuckets();
            return;
        }
    }

    private void releaseBuckets() {
        if (!this.areDebugging()) {
            int curBucketIndex = this.getBucketIndex(this.curBytePosition0b);
            while (this.oldestBucketIndex < curBucketIndex && ((Bucket)this.buckets.apply(this.oldestBucketIndex)).refCount() == 0) {
                this.buckets.update(this.oldestBucketIndex, null);
                ++this.oldestBucketIndex;
            }
            return;
        }
    }

    @Override
    public void compact() {
        this.releaseBuckets();
        this.buckets.remove(0, this.oldestBucketIndex);
        int bytesRemoved = this.oldestBucketIndex * this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
        this.headBucketBytePosition0b += (long)bytesRemoved;
        this.oldestBucketIndex = 0;
    }

    public class Bucket {
        private int refCount;
        private final byte[] bytes;

        public Bucket() {
            if (BucketingInputSource.this == null) {
                throw new NullPointerException();
            }
            this.refCount = 0;
            this.bytes = new byte[BucketingInputSource.this.org$apache$daffodil$io$BucketingInputSource$$bucketSize];
        }

        public int refCount() {
            return this.refCount;
        }

        public void refCount_$eq(int x$1) {
            this.refCount = x$1;
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public final /* synthetic */ BucketingInputSource org$apache$daffodil$io$BucketingInputSource$Bucket$$$outer() {
            return BucketingInputSource.this;
        }
    }
}

