/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToQuantilesSketchUDF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToQuantilesSketchUDFTest {
    @Test
    public void nullSketch() {
        BytesWritable result = new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptySketchZeroColumn() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptySketchColumnOutOfRange() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 2);
    }

    @Test
    public void emptySketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        BytesWritable result = new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        DoublesSketch qs = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertTrue((boolean)qs.isEmpty());
    }

    @Test
    public void nonEmptySketchExplicitColumn() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{10.0});
        BytesWritable result = new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 1);
        Assert.assertNotNull((Object)result);
        DoublesSketch qs = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertFalse((boolean)qs.isEmpty());
        Assert.assertEquals((double)qs.getMinItem(), (double)1.0);
        Assert.assertEquals((double)qs.getMaxItem(), (double)10.0);
    }

    @Test
    public void nonEmptySketchWithTwoColumnsExplicitK() {
        int k = 256;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch.update(1L, new double[]{1.0, 2.0});
        sketch.update(2L, new double[]{10.0, 20.0});
        BytesWritable result = new ArrayOfDoublesSketchToQuantilesSketchUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 2, k);
        Assert.assertNotNull((Object)result);
        DoublesSketch qs = DoublesSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertFalse((boolean)qs.isEmpty());
        Assert.assertEquals((int)qs.getK(), (int)k);
        Assert.assertEquals((double)qs.getMinItem(), (double)2.0);
        Assert.assertEquals((double)qs.getMaxItem(), (double)20.0);
    }
}

