/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapIntersectionTest {
    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)usk1);
        inter.intersect((ThetaSketch)usk2);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        rsk1 = inter.getResult(false, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        Assert.assertFalse((boolean)inter.isSameResource(seg));
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 512; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)usk1);
        inter.intersect((ThetaSketch)usk2);
        boolean ordered = true;
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        rsk1 = inter.getResult(false, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1024;
        int u = 4096;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (i = 0; i < 4096; ++i) {
            usk1.update((long)i);
        }
        for (i = 2048; i < 6144; ++i) {
            usk2.update((long)i);
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)csk1);
        inter.intersect((ThetaSketch)csk2);
        CompactThetaSketch rsk1 = inter.getResult(true, null);
        double result = rsk1.getEstimate();
        double sd2err = 4096.0 / Math.sqrt(1024.0);
        Assert.assertEquals((double)result, (double)2048.0, (double)sd2err);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void checkIntersectionNull() {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        ThetaSketch sk = null;
        try {
            inter.intersect(sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            inter.intersect(sk, sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk);
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        sk.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(1L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(1L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(2L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        HeapIntersectionTest.println("sk1: " + sk1.getEstimate());
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        HeapIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkHeapifyAndWrap() {
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        CompactThetaSketch cSk1 = sk1.compact(true, null);
        double cSk1Est = cSk1.getEstimate();
        HeapIntersectionTest.println("cSk1Est: " + cSk1Est);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)cSk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        CompactThetaSketch cSk2 = sk2.compact(true, null);
        double cSk2Est = cSk2.getEstimate();
        HeapIntersectionTest.println("cSk2Est: " + cSk2Est);
        Assert.assertEquals((double)cSk2Est, (double)cSk1Est, (double)0.0);
        inter.intersect((ThetaSketch)cSk2);
        CompactThetaSketch interResultCSk1 = inter.getResult(false, null);
        double inter1est = interResultCSk1.getEstimate();
        Assert.assertEquals((double)inter1est, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("Inter1Est: " + inter1est);
        byte[] byteArray = inter.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        ThetaIntersection inter2 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)seg);
        CompactThetaSketch heapifiedSk = inter2.getResult(false, null);
        double heapifiedEst = heapifiedSk.getEstimate();
        Assert.assertEquals((double)heapifiedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("HeapifiedEst: " + heapifiedEst);
        ThetaIntersection inter3 = ThetaIntersection.wrap((MemorySegment)seg);
        CompactThetaSketch wrappedSk = inter3.getResult(false, null);
        double wrappedEst = wrappedSk.getEstimate();
        Assert.assertEquals((double)wrappedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("WrappedEst: " + wrappedEst);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkPreject() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setP(0.5f).build();
        sk.update(7L);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
    }

    @Test
    public void checkHeapifyVirginEmpty() {
        int lgK = 5;
        int k = 32;
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection();
        MemorySegment srcSeg = MemorySegment.ofArray(inter1.toByteArray()).asReadOnly();
        ThetaIntersection inter2 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)srcSeg);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setP(0.5f).setNominalEntries(32).build();
        sk1.update(7L);
        inter1.intersect((ThetaSketch)sk1);
        Assert.assertFalse((boolean)inter1.isEmpty());
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        srcSeg = MemorySegment.ofArray(inter1.toByteArray()).asReadOnly();
        inter2 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)srcSeg);
        Assert.assertFalse((boolean)inter2.isEmpty());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactThetaSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)2);
        ThetaSetOperation.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)2);
        ThetaSetOperation.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkFamilyID() {
        int k = 32;
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(32).buildUnion();
        byte[] byteArray = union.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        ThetaIntersection inter1 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadEmptyState() {
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection();
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        inter1.intersect((ThetaSketch)sk);
        byte[] byteArray = inter1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, 1);
        ThetaSetOperation.heapify((MemorySegment)seg);
    }

    @Test
    public void checkEmpty() {
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)usk);
        Assert.assertTrue((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(), (int)0);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)0);
    }

    @Test
    public void checkOne() {
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().build();
        usk.update(1L);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)usk);
        Assert.assertFalse((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(), (int)1);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)32);
    }

    @Test
    public void checkGetResult() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk);
        CompactThetaSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkFamily() {
        ThetaIntersectionImpl impl = ThetaIntersectionImpl.initNewHeapInstance((long)9001L);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test
    public void checkPairIntersectSimple() {
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch skB = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        CompactThetaSketch csk = inter.intersect((ThetaSketch)skA, (ThetaSketch)skB);
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void printlnTest() {
        HeapIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

