/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.pig.cpc.AlgebraicInitial;
import org.apache.datasketches.pig.cpc.UnionSketchAlgebraicFinal;
import org.apache.datasketches.pig.cpc.UnionSketchAlgebraicIntermediate;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class UnionSketch
extends EvalFunc<DataByteArray>
implements Accumulator<DataByteArray>,
Algebraic {
    private DataByteArray emptySketch_;
    private final int lgK_;
    private final long seed_;
    private CpcUnion accumUnion_;
    private boolean isFirstCall_;

    public UnionSketch() {
        this(11, 9001L);
    }

    public UnionSketch(String lgK) {
        this(Integer.parseInt(lgK), 9001L);
    }

    public UnionSketch(String lgK, String seed) {
        this(Integer.parseInt(lgK), Long.parseLong(seed));
    }

    public UnionSketch(int lgK, long seed) {
        this.lgK_ = lgK;
        this.seed_ = seed;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Exec was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray());
            }
            return this.emptySketch_;
        }
        CpcUnion union = new CpcUnion(this.lgK_, this.seed_);
        DataBag bag = (DataBag)inputTuple.get(0);
        UnionSketch.updateUnion(bag, union, this.seed_);
        return new DataByteArray(union.getResult().toByteArray());
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Accumulator was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = new CpcUnion(this.lgK_, this.seed_);
        }
        UnionSketch.updateUnion(bag, this.accumUnion_, this.seed_);
    }

    public DataByteArray getValue() {
        if (this.accumUnion_ == null) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray());
            }
            return this.emptySketch_;
        }
        return new DataByteArray(this.accumUnion_.getResult().toByteArray());
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return AlgebraicInitial.class.getName();
    }

    public String getIntermed() {
        return UnionSketchAlgebraicIntermediate.class.getName();
    }

    public String getFinal() {
        return UnionSketchAlgebraicFinal.class.getName();
    }

    static void updateUnion(DataBag bag, CpcUnion union, long seed) throws ExecException {
        for (Tuple innerTuple : bag) {
            Object f0 = innerTuple.get(0);
            if (f0 == null) continue;
            byte type = innerTuple.getType(0);
            if (type == 50) {
                DataByteArray dba = (DataByteArray)f0;
                union.update(CpcSketch.heapify((byte[])dba.get(), (long)seed));
                continue;
            }
            throw new IllegalArgumentException("Field type was not DataType.BYTEARRAY: " + type);
        }
    }
}

