/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.pig.frequencies.Util;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class UnionFrequentItemsSketchAlgebraicIntermediateFinal<T>
extends EvalFunc<Tuple> {
    private int sketchSize_;
    private ArrayOfItemsSerDe<T> serDe_;
    private boolean isFirstCall_ = true;

    public UnionFrequentItemsSketchAlgebraicIntermediateFinal() {
    }

    public UnionFrequentItemsSketchAlgebraicIntermediateFinal(int sketchSize, ArrayOfItemsSerDe<T> serDe) {
        this.sketchSize_ = sketchSize;
        this.serDe_ = serDe;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"algebraic is used");
            this.isFirstCall_ = false;
        }
        ItemsSketch sketch = new ItemsSketch(this.sketchSize_);
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple dataTuple : bag) {
            Object item = dataTuple.get(0);
            if (item instanceof DataBag) {
                for (Tuple innerTuple : (DataBag)item) {
                    ItemsSketch<T> incomingSketch = Util.deserializeSketchFromTuple(innerTuple, this.serDe_);
                    sketch.merge(incomingSketch);
                }
                continue;
            }
            if (item instanceof DataByteArray) {
                ItemsSketch<T> incomingSketch = Util.deserializeSketchFromTuple(dataTuple, this.serDe_);
                if (incomingSketch.isEmpty()) continue;
                sketch.merge(incomingSketch);
                continue;
            }
            throw new IllegalArgumentException("InputTuple.Field0: Bag contains unrecognized types: " + item.getClass().getName());
        }
        return Util.serializeSketchToTuple(sketch, this.serDe_);
    }
}

