/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class UnionSketchAlgebraicIntermediateFinal<S extends Summary>
extends EvalFunc<Tuple> {
    private final int sketchSize_;
    private final SummarySetOperations<S> summarySetOps_;
    private final SummaryDeserializer<S> summaryDeserializer_;
    private boolean isFirstCall_ = true;

    public UnionSketchAlgebraicIntermediateFinal(SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this(4096, summarySetOps, summaryDeserializer);
    }

    public UnionSketchAlgebraicIntermediateFinal(int sketchSize, SummarySetOperations<S> summarySetOps, SummaryDeserializer<S> summaryDeserializer) {
        this.sketchSize_ = sketchSize;
        this.summarySetOps_ = summarySetOps;
        this.summaryDeserializer_ = summaryDeserializer;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"algebraic is used");
            this.isFirstCall_ = false;
        }
        Union union = new Union(this.sketchSize_, this.summarySetOps_);
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        for (Tuple dataTuple : bag) {
            Object item = dataTuple.get(0);
            if (item instanceof DataBag) {
                for (Tuple innerTuple : (DataBag)item) {
                    Sketch<S> incomingSketch = Util.deserializeSketchFromTuple(innerTuple, this.summaryDeserializer_);
                    union.union(incomingSketch);
                }
                continue;
            }
            if (item instanceof DataByteArray) {
                Sketch<S> incomingSketch = Util.deserializeSketchFromTuple(dataTuple, this.summaryDeserializer_);
                union.union(incomingSketch);
                continue;
            }
            throw new IllegalArgumentException("InputTuple.Field0: Bag contains unrecognized types: " + item.getClass().getName());
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }
}

