/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepStmtMetaDataTest
extends BaseJDBCTestCase {
    public PrepStmtMetaDataTest(String string) {
        super(string);
    }

    public void testNoResultSetMeta() throws SQLException {
        this.checkEmptyMetaData("create table ab(a int)", true);
        this.checkEmptyMetaData("alter table ab add column b int", true);
        Statement statement = this.createStatement();
        statement.execute("create procedure testproc() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.PrepStmtMetaDataTest.tstmeth' parameter style java");
        this.checkEmptyMetaData("call testproc()", false);
        this.checkEmptyMetaData("drop procedure testproc", true);
        this.checkEmptyMetaData("create schema myschema", true);
        this.checkEmptyMetaData("drop schema myschema restrict", true);
        statement.execute("CREATE TABLE TRIGTAB (i int)");
        this.checkEmptyMetaData("create trigger mytrig after insert on ab for each row insert into trigtab values(1)", true);
        this.checkEmptyMetaData("drop trigger mytrig", true);
        this.checkEmptyMetaData("create view myview as select * from ab", true);
        this.checkEmptyMetaData("drop view myview", true);
        this.checkEmptyMetaData("drop table ab", false);
        this.checkEmptyMetaData("create index aindex on ab(a)", true);
        this.checkEmptyMetaData("drop index aindex", false);
        this.checkEmptyMetaData("insert into ab values(1,1)", true);
        this.checkEmptyMetaData("update ab set a = 2", false);
        this.checkEmptyMetaData("delete from ab", false);
        statement.executeUpdate("drop table ab");
        statement.close();
    }

    public void testAlterTableMeta() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table bug4579 (c11 int)");
        statement.executeUpdate("insert into bug4579 values (1)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from bug4579");
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)resultSetMetaData.getColumnName(1));
        statement.executeUpdate("alter table bug4579 add column c12 int");
        if (!PrepStmtMetaDataTest.usingDerbyNetClient()) {
            resultSetMetaData = preparedStatement.getMetaData();
            PrepStmtMetaDataTest.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
            PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
            PrepStmtMetaDataTest.assertEquals((String)"C11", (String)resultSetMetaData.getColumnName(1));
            PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(2));
            PrepStmtMetaDataTest.assertEquals((String)"C12", (String)resultSetMetaData.getColumnName(2));
        }
        statement.executeUpdate("alter table bug4579 add column c13 int");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSetMetaData = preparedStatement.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)3, (int)resultSetMetaData.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)resultSetMetaData.getColumnName(1));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"C12", (String)resultSetMetaData.getColumnName(2));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(3));
        PrepStmtMetaDataTest.assertEquals((String)"C13", (String)resultSetMetaData.getColumnName(3));
        resultSetMetaData = preparedStatement.getMetaData();
        PrepStmtMetaDataTest.assertEquals((int)3, (int)resultSetMetaData.getColumnCount());
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"C11", (String)resultSetMetaData.getColumnName(1));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"C12", (String)resultSetMetaData.getColumnName(2));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(3));
        PrepStmtMetaDataTest.assertEquals((String)"C13", (String)resultSetMetaData.getColumnName(3));
        resultSet.close();
        preparedStatement.close();
        statement.executeUpdate("drop table bug4579");
        statement.close();
    }

    private void checkEmptyMetaData(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        this.assertEmptyResultSetMetaData(resultSetMetaData);
        if (bl) {
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    public void testAllDataTypesMetaData() throws SQLException {
        Statement statement = this.createStatement();
        SQLUtilities.createAndPopulateAllDataTypesTable(statement);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * from AllDataTypesTable");
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        PrepStmtMetaDataTest.assertEquals((int)17, (int)n);
        PrepStmtMetaDataTest.assertEquals((String)"", (String)resultSetMetaData.getCatalogName(1));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Integer", (String)resultSetMetaData.getColumnClassName(1));
        PrepStmtMetaDataTest.assertEquals((int)6, (int)resultSetMetaData.getColumnDisplaySize(1));
        PrepStmtMetaDataTest.assertEquals((String)"SMALLINTCOL", (String)resultSetMetaData.getColumnLabel(1));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)resultSetMetaData.getColumnType(1));
        PrepStmtMetaDataTest.assertEquals((String)"SMALLINT", (String)resultSetMetaData.getColumnTypeName(1));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)resultSetMetaData.getPrecision(1));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(1));
        PrepStmtMetaDataTest.assertEquals((String)"APP", (String)resultSetMetaData.getSchemaName(1));
        PrepStmtMetaDataTest.assertEquals((String)"ALLDATATYPESTABLE", (String)resultSetMetaData.getTableName(1));
        PrepStmtMetaDataTest.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
        PrepStmtMetaDataTest.assertFalse((boolean)resultSetMetaData.isCurrency(1));
        PrepStmtMetaDataTest.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        PrepStmtMetaDataTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertFalse((boolean)resultSetMetaData.isReadOnly(1));
        }
        PrepStmtMetaDataTest.assertTrue((boolean)resultSetMetaData.isSearchable(1));
        PrepStmtMetaDataTest.assertTrue((boolean)resultSetMetaData.isSigned(1));
        PrepStmtMetaDataTest.assertFalse((boolean)resultSetMetaData.isWritable(1));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Integer", (String)resultSetMetaData.getColumnClassName(2));
        PrepStmtMetaDataTest.assertEquals((int)11, (int)resultSetMetaData.getColumnDisplaySize(2));
        PrepStmtMetaDataTest.assertEquals((String)"INTEGERCOL", (String)resultSetMetaData.getColumnLabel(2));
        PrepStmtMetaDataTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(2));
        PrepStmtMetaDataTest.assertEquals((String)"INTEGER", (String)resultSetMetaData.getColumnTypeName(2));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(2));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(2));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Long", (String)resultSetMetaData.getColumnClassName(3));
        PrepStmtMetaDataTest.assertEquals((int)20, (int)resultSetMetaData.getColumnDisplaySize(3));
        PrepStmtMetaDataTest.assertEquals((String)"BIGINTCOL", (String)resultSetMetaData.getColumnLabel(3));
        PrepStmtMetaDataTest.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(3));
        PrepStmtMetaDataTest.assertEquals((String)"BIGINT", (String)resultSetMetaData.getColumnTypeName(3));
        PrepStmtMetaDataTest.assertEquals((int)19, (int)resultSetMetaData.getPrecision(3));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(3));
        PrepStmtMetaDataTest.assertEquals((String)"java.math.BigDecimal", (String)resultSetMetaData.getColumnClassName(4));
        PrepStmtMetaDataTest.assertEquals((int)12, (int)resultSetMetaData.getColumnDisplaySize(4));
        PrepStmtMetaDataTest.assertEquals((String)"DECIMALCOL", (String)resultSetMetaData.getColumnLabel(4));
        PrepStmtMetaDataTest.assertEquals((int)3, (int)resultSetMetaData.getColumnType(4));
        PrepStmtMetaDataTest.assertEquals((String)"DECIMAL", (String)resultSetMetaData.getColumnTypeName(4));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(4));
        PrepStmtMetaDataTest.assertEquals((int)5, (int)resultSetMetaData.getScale(4));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Float", (String)resultSetMetaData.getColumnClassName(5));
        PrepStmtMetaDataTest.assertEquals((int)15, (int)resultSetMetaData.getColumnDisplaySize(5));
        PrepStmtMetaDataTest.assertEquals((String)"REALCOL", (String)resultSetMetaData.getColumnLabel(5));
        PrepStmtMetaDataTest.assertEquals((int)7, (int)resultSetMetaData.getColumnType(5));
        PrepStmtMetaDataTest.assertEquals((String)"REAL", (String)resultSetMetaData.getColumnTypeName(5));
        PrepStmtMetaDataTest.assertEquals((int)7, (int)resultSetMetaData.getPrecision(5));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(5));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.Double", (String)resultSetMetaData.getColumnClassName(6));
        PrepStmtMetaDataTest.assertEquals((int)24, (int)resultSetMetaData.getColumnDisplaySize(6));
        PrepStmtMetaDataTest.assertEquals((String)"DOUBLECOL", (String)resultSetMetaData.getColumnLabel(6));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)resultSetMetaData.getColumnType(6));
        PrepStmtMetaDataTest.assertEquals((String)"DOUBLE", (String)resultSetMetaData.getColumnTypeName(6));
        PrepStmtMetaDataTest.assertEquals((int)15, (int)resultSetMetaData.getPrecision(6));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(6));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)resultSetMetaData.getColumnClassName(7));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getColumnDisplaySize(7));
        PrepStmtMetaDataTest.assertEquals((String)"CHARCOL", (String)resultSetMetaData.getColumnLabel(7));
        PrepStmtMetaDataTest.assertEquals((int)1, (int)resultSetMetaData.getColumnType(7));
        PrepStmtMetaDataTest.assertEquals((String)"CHAR", (String)resultSetMetaData.getColumnTypeName(7));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getPrecision(7));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(7));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)resultSetMetaData.getColumnClassName(8));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getColumnDisplaySize(8));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHARCOL", (String)resultSetMetaData.getColumnLabel(8));
        PrepStmtMetaDataTest.assertEquals((int)12, (int)resultSetMetaData.getColumnType(8));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHAR", (String)resultSetMetaData.getColumnTypeName(8));
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getPrecision(8));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(8));
        PrepStmtMetaDataTest.assertEquals((String)"java.lang.String", (String)resultSetMetaData.getColumnClassName(9));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)resultSetMetaData.getColumnDisplaySize(9));
        PrepStmtMetaDataTest.assertEquals((String)"LONGVARCHARCOL", (String)resultSetMetaData.getColumnLabel(9));
        PrepStmtMetaDataTest.assertEquals((int)-1, (int)resultSetMetaData.getColumnType(9));
        PrepStmtMetaDataTest.assertEquals((String)"LONG VARCHAR", (String)resultSetMetaData.getColumnTypeName(9));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)resultSetMetaData.getPrecision(9));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(9));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)resultSetMetaData.getColumnClassName(10));
        PrepStmtMetaDataTest.assertEquals((int)120, (int)resultSetMetaData.getColumnDisplaySize(10));
        PrepStmtMetaDataTest.assertEquals((String)"CHARFORBITCOL", (String)resultSetMetaData.getColumnLabel(10));
        PrepStmtMetaDataTest.assertEquals((int)-2, (int)resultSetMetaData.getColumnType(10));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertEquals((String)"CHAR () FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(10));
        } else {
            PrepStmtMetaDataTest.assertEquals((String)"CHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(10));
        }
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getPrecision(10));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(10));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)resultSetMetaData.getColumnClassName(11));
        PrepStmtMetaDataTest.assertEquals((int)120, (int)resultSetMetaData.getColumnDisplaySize(11));
        PrepStmtMetaDataTest.assertEquals((String)"VARCHARFORBITCOL", (String)resultSetMetaData.getColumnLabel(11));
        PrepStmtMetaDataTest.assertEquals((int)-3, (int)resultSetMetaData.getColumnType(11));
        if (PrepStmtMetaDataTest.usingEmbedded()) {
            PrepStmtMetaDataTest.assertEquals((String)"VARCHAR () FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(11));
        } else {
            PrepStmtMetaDataTest.assertEquals((String)"VARCHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(11));
        }
        PrepStmtMetaDataTest.assertEquals((int)60, (int)resultSetMetaData.getPrecision(11));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(11));
        PrepStmtMetaDataTest.assertEquals((String)"byte[]", (String)resultSetMetaData.getColumnClassName(12));
        PrepStmtMetaDataTest.assertEquals((int)65400, (int)resultSetMetaData.getColumnDisplaySize(12));
        PrepStmtMetaDataTest.assertEquals((String)"LVARCHARFORBITCOL", (String)resultSetMetaData.getColumnLabel(12));
        PrepStmtMetaDataTest.assertEquals((int)-4, (int)resultSetMetaData.getColumnType(12));
        PrepStmtMetaDataTest.assertEquals((String)"LONG VARCHAR FOR BIT DATA", (String)resultSetMetaData.getColumnTypeName(12));
        PrepStmtMetaDataTest.assertEquals((int)32700, (int)resultSetMetaData.getPrecision(12));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(12));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Clob", (String)resultSetMetaData.getColumnClassName(13));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)resultSetMetaData.getColumnDisplaySize(13));
        PrepStmtMetaDataTest.assertEquals((String)"CLOBCOL", (String)resultSetMetaData.getColumnLabel(13));
        PrepStmtMetaDataTest.assertEquals((int)2005, (int)resultSetMetaData.getColumnType(13));
        PrepStmtMetaDataTest.assertEquals((String)"CLOB", (String)resultSetMetaData.getColumnTypeName(13));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)resultSetMetaData.getPrecision(13));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(13));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Date", (String)resultSetMetaData.getColumnClassName(14));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)resultSetMetaData.getColumnDisplaySize(14));
        PrepStmtMetaDataTest.assertEquals((String)"DATECOL", (String)resultSetMetaData.getColumnLabel(14));
        PrepStmtMetaDataTest.assertEquals((int)91, (int)resultSetMetaData.getColumnType(14));
        PrepStmtMetaDataTest.assertEquals((String)"DATE", (String)resultSetMetaData.getColumnTypeName(14));
        PrepStmtMetaDataTest.assertEquals((int)10, (int)resultSetMetaData.getPrecision(14));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(14));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Time", (String)resultSetMetaData.getColumnClassName(15));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)resultSetMetaData.getColumnDisplaySize(15));
        PrepStmtMetaDataTest.assertEquals((String)"TIMECOL", (String)resultSetMetaData.getColumnLabel(15));
        PrepStmtMetaDataTest.assertEquals((int)92, (int)resultSetMetaData.getColumnType(15));
        PrepStmtMetaDataTest.assertEquals((String)"TIME", (String)resultSetMetaData.getColumnTypeName(15));
        PrepStmtMetaDataTest.assertEquals((int)8, (int)resultSetMetaData.getPrecision(15));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(15));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Timestamp", (String)resultSetMetaData.getColumnClassName(16));
        PrepStmtMetaDataTest.assertEquals((int)29, (int)resultSetMetaData.getColumnDisplaySize(16));
        PrepStmtMetaDataTest.assertEquals((String)"TIMESTAMPCOL", (String)resultSetMetaData.getColumnLabel(16));
        PrepStmtMetaDataTest.assertEquals((int)93, (int)resultSetMetaData.getColumnType(16));
        PrepStmtMetaDataTest.assertEquals((String)"TIMESTAMP", (String)resultSetMetaData.getColumnTypeName(16));
        PrepStmtMetaDataTest.assertEquals((int)29, (int)resultSetMetaData.getPrecision(16));
        PrepStmtMetaDataTest.assertEquals((int)9, (int)resultSetMetaData.getScale(16));
        PrepStmtMetaDataTest.assertEquals((String)"java.sql.Blob", (String)resultSetMetaData.getColumnClassName(17));
        PrepStmtMetaDataTest.assertEquals((int)2048, (int)resultSetMetaData.getColumnDisplaySize(17));
        PrepStmtMetaDataTest.assertEquals((String)"BLOBCOL", (String)resultSetMetaData.getColumnLabel(17));
        PrepStmtMetaDataTest.assertEquals((int)2004, (int)resultSetMetaData.getColumnType(17));
        PrepStmtMetaDataTest.assertEquals((String)"BLOB", (String)resultSetMetaData.getColumnTypeName(17));
        PrepStmtMetaDataTest.assertEquals((int)1024, (int)resultSetMetaData.getPrecision(17));
        PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getScale(17));
        preparedStatement.close();
    }

    private void assertEmptyResultSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        if (resultSetMetaData != null) {
            PrepStmtMetaDataTest.assertEquals((int)0, (int)resultSetMetaData.getColumnCount());
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(PrepStmtMetaDataTest.class);
    }

    public static void tstmeth() {
    }
}

