/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.torque.criteria.SqlEnum;

public class WhereClauseExpression {
    private Object lValue;
    private SqlEnum operator;
    private Object rValue;
    private String sql;
    private Object[] preparedStatementReplacements;

    public WhereClauseExpression(Object lValue, SqlEnum operator, Object rValue, String sql, Object[] preparedStatementReplacements) {
        if (operator != null && (sql != null || preparedStatementReplacements != null)) {
            throw new IllegalArgumentException("Either operator or some of (sql, preparedStatementReplacements) can be not null, not both");
        }
        if ((lValue == null || operator == null) && sql == null) {
            throw new IllegalArgumentException("Either the values(lValue, comparison) or sql must be not null");
        }
        this.lValue = lValue;
        this.operator = operator;
        this.rValue = rValue;
        this.sql = sql;
        this.preparedStatementReplacements = preparedStatementReplacements;
    }

    public Object getLValue() {
        return this.lValue;
    }

    public void setLValue(String lValue) {
        this.lValue = lValue;
    }

    public SqlEnum getOperator() {
        return this.operator;
    }

    public void setOperator(SqlEnum operator) {
        this.operator = operator;
    }

    public Object getRValue() {
        return this.rValue;
    }

    public void setRValue(Object rValue) {
        this.rValue = rValue;
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getPreparedStatementReplacements() {
        return this.preparedStatementReplacements;
    }

    public boolean isVerbatimSqlCondition() {
        return this.sql != null;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append(this.lValue).append((Object)this.operator).append(this.rValue).append((Object)this.sql).append(this.preparedStatementReplacements);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WhereClauseExpression other = (WhereClauseExpression)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.lValue, other.lValue).append((Object)this.operator, (Object)other.operator).append(this.rValue, other.rValue).append((Object)this.sql, (Object)other.sql).append(this.preparedStatementReplacements, other.preparedStatementReplacements);
        return equalsBuilder.isEquals();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.lValue.toString());
        if (this.operator != null) {
            result.append(this.operator);
        }
        result.append(this.rValue);
        return result.toString();
    }
}

