/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformDefaultImpl
implements Platform {
    private static final String TIMESTAMP_FORMAT = "''yyyy-MM-dd HH:mm:ss''";
    private Map<SchemaType, SqlType> schemaTypeToSqlTypeMap;

    public PlatformDefaultImpl() {
        this.initialize();
    }

    private void initialize() {
        this.schemaTypeToSqlTypeMap = Collections.synchronizedMap(new HashMap());
        for (SchemaType schemaType : SchemaType.values()) {
            this.setSchemaTypeToSqlTypeMapping(schemaType, new SqlType(schemaType.name()));
        }
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANCHAR, new SqlType("CHAR"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANINT, new SqlType("INTEGER"));
    }

    protected void setSchemaTypeToSqlTypeMapping(SchemaType schemaType, SqlType sqlType) {
        if (schemaType == null) {
            throw new NullPointerException("schemaType must not be null");
        }
        if (sqlType == null) {
            throw new NullPointerException("sqlType must not be null");
        }
        this.schemaTypeToSqlTypeMap.put(schemaType, sqlType);
    }

    public SqlType getSqlTypeForSchemaType(SchemaType schemaType) {
        return this.schemaTypeToSqlTypeMap.get((Object)schemaType);
    }

    public String getNullString(boolean notNull) {
        return notNull ? "NOT NULL" : "";
    }

    public String getAutoIncrement() {
        return "IDENTITY";
    }

    public boolean hasScale(String sqlType) {
        return true;
    }

    public boolean hasSize(String sqlType) {
        return true;
    }

    public String getSizeSuffix(String sqlType) {
        return "";
    }

    public boolean createNotNullBeforeAutoincrement() {
        return true;
    }

    public String quoteAndEscape(String text) {
        String result = text.replace("'", "''");
        if (this.escapeBackslashes()) {
            result = result.replace("\\", "\\\\");
        }
        return "'" + result + "'";
    }

    protected boolean escapeBackslashes() {
        return true;
    }

    public String getDateString(Date date) {
        return this.getTimestampString(date);
    }

    public String getTimeString(Date date) {
        return this.getTimestampString(date);
    }

    public String getTimestampString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public boolean usesStandaloneSchema() {
        return false;
    }
}

