/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;

public class ResultsetSpliterator<T>
extends Spliterators.AbstractSpliterator<T>
implements Runnable {
    private final RecordMapper<T> recordMapper;
    private final Criteria criteria;
    private final Statement statement;
    private final ResultSet resultSet;
    private long offset;
    private long limit;
    private long rowNumber;

    public ResultsetSpliterator(RecordMapper<T> recordMapper, Criteria criteria, Statement statement, ResultSet resultSet) throws TorqueException {
        super(Long.MAX_VALUE, 16);
        this.recordMapper = recordMapper;
        this.criteria = criteria;
        this.statement = statement;
        this.resultSet = resultSet;
        this.offset = 0L;
        this.limit = -1L;
        this.rowNumber = 0L;
        if (criteria != null) {
            Database database = Torque.getDatabase(criteria.getDbName());
            if (!database.getAdapter().supportsNativeOffset()) {
                this.offset = criteria.getOffset();
            }
            if (!database.getAdapter().supportsNativeLimit()) {
                if (database.getAdapter().supportsNativeOffset()) {
                    this.limit = criteria.getLimit();
                } else if (criteria.getLimit() != -1) {
                    this.limit = this.offset + (long)criteria.getLimit();
                }
            }
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        try {
            while (this.resultSet.next()) {
                if (this.rowNumber < this.offset) {
                    ++this.rowNumber;
                    continue;
                }
                if (this.limit >= 0L && this.rowNumber >= this.limit) {
                    return false;
                }
                ++this.rowNumber;
                T result = this.recordMapper.processRow(this.resultSet, 0, this.criteria);
                action.accept(result);
                return true;
            }
        }
        catch (SQLException e) {
            throw new TorqueRuntimeException(e);
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new TorqueRuntimeException(e);
        }
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            throw new TorqueRuntimeException(e);
        }
    }
}

