/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.jcs.engine.ZombieCacheService;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZombieCacheServiceNonLocal<K, V>
extends ZombieCacheService<K, V>
implements ICacheServiceNonLocal<K, V> {
    private static final Log log = LogFactory.getLog(ZombieCacheServiceNonLocal.class);
    private int maxQueueSize = 0;
    private final ConcurrentLinkedQueue<ZombieEvent> queue;

    public ZombieCacheServiceNonLocal() {
        this.queue = new ConcurrentLinkedQueue();
    }

    public ZombieCacheServiceNonLocal(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        this.queue = new ConcurrentLinkedQueue();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    private void addQueue(ZombieEvent event) {
        this.queue.add(event);
        if (this.queue.size() > this.maxQueueSize) {
            this.queue.poll();
        }
    }

    @Override
    public void update(ICacheElement<K, V> item, long listenerId) {
        if (this.maxQueueSize > 0) {
            PutEvent<K, V> event = new PutEvent<K, V>(item, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public void remove(String cacheName, K key, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveEvent<K> event = new RemoveEvent<K>(cacheName, key, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public void removeAll(String cacheName, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveAllEvent event = new RemoveAllEvent(cacheName, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) {
        return new HashMap();
    }

    @Override
    public Set<K> getKeySet(String cacheName) {
        return Collections.emptySet();
    }

    public synchronized void propagateEvents(ICacheServiceNonLocal<K, V> service) throws Exception {
        int cnt = 0;
        if (log.isInfoEnabled()) {
            log.info((Object)"Propagating events to the new ICacheServiceNonLocal.");
        }
        ElapsedTimer timer = new ElapsedTimer();
        while (!this.queue.isEmpty()) {
            ++cnt;
            ZombieEvent event = this.queue.poll();
            if (event instanceof PutEvent) {
                PutEvent putEvent = (PutEvent)event;
                service.update(putEvent.element, event.requesterId);
                continue;
            }
            if (event instanceof RemoveEvent) {
                RemoveEvent removeEvent = (RemoveEvent)event;
                service.remove(event.cacheName, removeEvent.key, event.requesterId);
                continue;
            }
            if (!(event instanceof RemoveAllEvent)) continue;
            service.removeAll(event.cacheName, event.requesterId);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Propagated " + cnt + " events to the new ICacheServiceNonLocal in " + timer.getElapsedTimeString()));
        }
    }

    private static class RemoveAllEvent
    extends ZombieEvent {
        public RemoveAllEvent(String cacheName, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
        }
    }

    private static class RemoveEvent<K>
    extends ZombieEvent {
        K key;

        public RemoveEvent(String cacheName, K key, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
            this.key = key;
        }
    }

    private static class PutEvent<K, V>
    extends ZombieEvent {
        ICacheElement<K, V> element;

        public PutEvent(ICacheElement<K, V> element, long requesterId) {
            this.requesterId = requesterId;
            this.element = element;
        }
    }

    protected static abstract class ZombieEvent {
        String cacheName;
        long requesterId;

        protected ZombieEvent() {
        }
    }
}

