/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;

public class FromElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fromExpression = null;
    private JoinType joinType = null;
    private String joinCondition = null;
    private final List<Object> preparedStatementReplacements = new ArrayList<Object>();

    public FromElement(String tableName) {
        this(tableName, null, null, null);
    }

    public FromElement(String fromExpression, JoinType joinType, String joinCondition) {
        this(fromExpression, joinType, joinCondition, null);
    }

    public FromElement(String fromExpression, JoinType joinType, String joinCondition, List<Object> preparedStatementReplacements) {
        this.fromExpression = fromExpression;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
        if (preparedStatementReplacements != null) {
            this.preparedStatementReplacements.addAll(preparedStatementReplacements);
        }
    }

    public FromElement(String fromExpression, JoinType joinType, PreparedStatementPart joinCondition) {
        this(fromExpression, joinType, joinCondition.getSqlAsString(), joinCondition.getPreparedStatementReplacements());
    }

    public String getJoinCondition() {
        return this.joinCondition;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public String getFromExpression() {
        return this.fromExpression;
    }

    public List<Object> getPreparedStatementReplacements() {
        return this.preparedStatementReplacements;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.joinType != null) {
            result.append((Object)this.joinType);
        }
        result.append(this.fromExpression);
        if (this.joinCondition != null) {
            result.append(SqlEnum.ON);
            result.append(this.joinCondition);
        }
        return result.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.joinCondition).append((Object)this.joinType).append((Object)this.fromExpression).append(this.preparedStatementReplacements).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FromElement other = (FromElement)obj;
        return new EqualsBuilder().append((Object)this.joinCondition, (Object)other.joinCondition).append((Object)this.joinType, (Object)other.joinType).append((Object)this.fromExpression, (Object)other.fromExpression).append(this.preparedStatementReplacements, other.preparedStatementReplacements).isEquals();
    }
}

