/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.paths;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.paths.ProjectPaths;

public abstract class Maven2ProjectPaths
implements ProjectPaths {
    private static Log log = LogFactory.getLog(Maven2ProjectPaths.class);
    protected static final String CONFIG_DIR = "src/main/torque-gen/";
    protected static final String SOURCE_DIR = "src/main/torque-gen/src";
    public static final String MODIFIABLE_OUTPUT_DIR_KEY = "modifiable";
    public static final String MODIFIABLE_OUTPUT_DIR = "src/main/generated-java";
    protected static final String DEFAULT_OUTPUT_DIR = "target/generated-sources";
    protected static final String WORK_DIR = "src/main/torque-gen/work";
    protected static final String CACHE_DIR = "target/torque-gen/cache";
    private final File projectRoot;
    private final Map<String, File> outputDirectoryMap = new HashMap<String, File>();

    protected Maven2ProjectPaths(File projectRoot) {
        if (projectRoot == null) {
            log.error((Object)"projectRoot is null");
            throw new NullPointerException("projectRoot is null");
        }
        this.projectRoot = projectRoot;
        this.outputDirectoryMap.put(null, new File(projectRoot, DEFAULT_OUTPUT_DIR));
        this.outputDirectoryMap.put(MODIFIABLE_OUTPUT_DIR_KEY, new File(projectRoot, MODIFIABLE_OUTPUT_DIR));
    }

    @Override
    public abstract File getConfigurationPath();

    @Override
    public abstract String getConfigurationPackage();

    @Override
    public File getDefaultSourcePath() {
        return new File(this.projectRoot, SOURCE_DIR);
    }

    @Override
    public Map<String, File> getOutputDirectoryMap() {
        return Collections.unmodifiableMap(this.outputDirectoryMap);
    }

    @Override
    public File getOutputDirectory(String outputDirKey) {
        File result = this.outputDirectoryMap.get(outputDirKey);
        if (result == null) {
            throw new IllegalArgumentException("unknown outputDirKey " + outputDirKey);
        }
        return result;
    }

    @Override
    public File getWorkDirectory() {
        return new File(this.projectRoot, WORK_DIR);
    }

    @Override
    public File getCacheDirectory() {
        return new File(this.projectRoot, CACHE_DIR);
    }

    protected File getProjectRoot() {
        return this.projectRoot;
    }
}

