/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.navigation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.config.view.navigation.NavigationCaseMapWrapper;
import org.apache.deltaspike.jsf.impl.config.view.navigation.ViewConfigAwareNavigationHandler;
import org.apache.deltaspike.jsf.impl.scope.viewaccess.ViewAccessScopedAwareNavigationHandler;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;

public class DeltaSpikeNavigationHandler
extends ConfigurableNavigationHandler
implements Deactivatable {
    private Set<String> otherOutcomes = new CopyOnWriteArraySet<String>();
    private Map<String, NavigationCase> viewConfigBasedNavigationCaseCache = new ConcurrentHashMap<String, NavigationCase>();
    private final NavigationHandler wrapped;
    private final boolean activated;
    private final boolean vasnhActivated;

    public DeltaSpikeNavigationHandler(NavigationHandler navigationHandler) {
        this.wrapped = navigationHandler;
        this.activated = ClassDeactivationUtils.isActivated(((Object)((Object)this)).getClass());
        this.vasnhActivated = ClassDeactivationUtils.isActivated(ViewAccessScopedAwareNavigationHandler.class);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (!this.activated || this.isUnhandledExceptionQueued(context)) {
            this.wrapped.handleNavigation(context, fromAction, outcome);
        } else {
            this.getWrappedNavigationHandler().handleNavigation(context, fromAction, outcome);
        }
    }

    private boolean isUnhandledExceptionQueued(FacesContext context) {
        return context.getExceptionHandler().getUnhandledExceptionQueuedEvents() != null && context.getExceptionHandler().getUnhandledExceptionQueuedEvents().iterator().hasNext();
    }

    private NavigationHandler getWrappedNavigationHandler() {
        NavigationHandler navigationHandler = new ViewConfigAwareNavigationHandler(this.wrapped);
        if (this.vasnhActivated) {
            navigationHandler = new ViewAccessScopedAwareNavigationHandler(navigationHandler);
        }
        return navigationHandler;
    }

    public NavigationCase getNavigationCase(FacesContext context, String action, String outcome) {
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            if (!this.activated) {
                return ((ConfigurableNavigationHandler)this.wrapped).getNavigationCase(context, action, outcome);
            }
            if (action == null && outcome != null && outcome.contains(".") && outcome.startsWith("class ") && !this.otherOutcomes.contains(outcome)) {
                String originalOutcome = outcome;
                NavigationCase navigationCase = this.viewConfigBasedNavigationCaseCache.get(originalOutcome);
                if (navigationCase != null) {
                    return navigationCase;
                }
                outcome = outcome.substring(6);
                ViewConfigDescriptor entry = null;
                if (DefaultErrorView.class.getName().equals(originalOutcome)) {
                    ViewConfigResolver viewConfigResolver = JsfUtils.getViewConfigResolver();
                    entry = viewConfigResolver.getDefaultErrorViewConfigDescriptor();
                }
                if (entry == null) {
                    Class loadedClass = ClassUtils.tryToLoadClassForName((String)outcome);
                    if (loadedClass == null) {
                        this.otherOutcomes.add(originalOutcome);
                    } else if (ViewConfig.class.isAssignableFrom(loadedClass)) {
                        entry = JsfUtils.getViewConfigResolver().getViewConfigDescriptor(loadedClass);
                    }
                }
                if (entry != null) {
                    View.NavigationMode navigationMode = ((View)entry.getMetaData(View.class).iterator().next()).navigation();
                    navigationCase = new NavigationCase("*", null, null, null, entry.getViewId(), null, View.NavigationMode.REDIRECT.equals((Object)navigationMode), false);
                    this.viewConfigBasedNavigationCaseCache.put(originalOutcome, navigationCase);
                    return navigationCase;
                }
            }
            return ((ConfigurableNavigationHandler)this.wrapped).getNavigationCase(context, action, outcome);
        }
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        HashMap<String, Set<NavigationCase>> result = null;
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            result = ((ConfigurableNavigationHandler)this.wrapped).getNavigationCases();
        }
        if (result == null) {
            result = new HashMap<String, Set<NavigationCase>>();
        }
        if (!this.activated) {
            return result;
        }
        return new NavigationCaseMapWrapper(result, this.wrapped);
    }
}

