/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.control;

import jakarta.servlet.http.HttpServletRequest;
import java.util.StringTokenizer;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SecureBookmarkablePageLink
extends BookmarkablePageLink {
    public <C extends Page> SecureBookmarkablePageLink(String id, Class<C> pageClass, String roleName) {
        super(id, pageClass);
        if (!this.isAuthorized(roleName)) {
            this.setVisible(false);
        }
    }

    public <C extends Page> SecureBookmarkablePageLink(String id, Class<C> pageClass, PageParameters parameters, String roleName) {
        super(id, pageClass, parameters);
        if (!this.isAuthorized(roleName)) {
            this.setVisible(false);
        }
    }

    private boolean isAuthorized(String roleName) {
        HttpServletRequest servletReq = (HttpServletRequest)this.getRequest().getContainerRequest();
        return this.isAuthorized(roleName, servletReq);
    }

    private boolean isAuthorized(String roleNames, HttpServletRequest servletReq) {
        boolean isAuthorized = false;
        StringTokenizer tokenizer = new StringTokenizer(roleNames, ",");
        if (tokenizer.countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                String roleName = tokenizer.nextToken();
                isAuthorized = SecUtils.isAuthorized((String)roleName, (HttpServletRequest)servletReq);
            }
        }
        return isAuthorized;
    }
}

