/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.panel.Displayable;
import org.apache.directory.fortress.web.panel.UserDetailPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDetailPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private AdminMgr adminMgr;
    @SpringBean
    private DelAdminMgr delAdminMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)UserDetailPanel.class.getName());
    private Form editForm = new UserDetailForm(this, "editFields", (IModel)new CompoundPropertyModel((Object)new User()));
    private Displayable display;

    public UserDetailPanel(String id, Displayable display) {
        super(id);
        this.display = display;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.adminMgr.setAdmin(SecUtils.getSession((Component)this));
            this.delAdminMgr.setAdmin(SecUtils.getSession((Component)this));
        }
        this.add(new Component[]{this.editForm});
    }

    private byte[] readJpegFile(String fileName) {
        URL fUrl = UserDetailPanel.class.getClassLoader().getResource(fileName);
        byte[] image = null;
        try {
            if (fUrl != null) {
                image = FileUtils.readFileToByteArray((File)new File(fUrl.toURI()));
            }
        }
        catch (URISyntaxException se) {
            String error = "readJpegFile caught URISyntaxException=" + se;
            LOG.error(error);
        }
        catch (IOException ioe) {
            String error = "readJpegFile caught IOException=" + ioe;
            LOG.error(error);
        }
        return image;
    }

    private String getPolicyName(String rDn) {
        int indx;
        String name = null;
        if (StringUtils.isNotEmpty((String)rDn) && (indx = rDn.indexOf(61)) != -1) {
            name = rDn.substring(indx + 1);
        }
        return name;
    }
}

