/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigDAO
extends LdapDataProvider {
    private static final String CLS_NM = ConfigDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private String CONFIG_ROOT_DN;
    public static final String GID_NUMBER_SEQUENCE = "ftGidNumber";
    public static final String UID_NUMBER_SEQUENCE = "ftUidNumber";
    private final String[] CONFIG_OBJ_CLASS = new String[]{"device", "ftProperties", "ftConfig"};
    private final String[] POSIX_IDS = new String[]{"ftGidNumber", "ftUidNumber"};
    private final String[] CONFIG_ATRS = new String[]{"cn", "ftProps", "ftGidNumber", "ftUidNumber"};

    ConfigDAO() {
        this.CONFIG_ROOT_DN = Config.getInstance().getProperty("config.root");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Configuration create(Configuration cfg) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(cfg.getName());
        LOG.info("create dn [{}]", (Object)dn);
        try {
            DefaultEntry myEntry = new DefaultEntry(dn);
            myEntry.add("objectClass", this.CONFIG_OBJ_CLASS);
            myEntry.add("cn", new String[]{cfg.getName()});
            this.loadProperties(cfg.getProperties(), (Entry)myEntry, "ftProps");
            if (StringUtils.isNotEmpty((CharSequence)cfg.getUidNumber())) {
                myEntry.add(UID_NUMBER_SEQUENCE, new String[]{cfg.getUidNumber()});
            } else {
                myEntry.add(UID_NUMBER_SEQUENCE, new String[]{"0"});
            }
            if (StringUtils.isNotEmpty((CharSequence)cfg.getGidNumber())) {
                myEntry.add(GID_NUMBER_SEQUENCE, new String[]{cfg.getGidNumber()});
            } else {
                myEntry.add(GID_NUMBER_SEQUENCE, new String[]{"0"});
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)myEntry, cfg);
        }
        catch (LdapEntryAlreadyExistsException e) {
            try {
                String warning = "create config dn [" + dn + "] caught LdapEntryAlreadyExistsException=" + e;
                throw new CreateException(125, warning, (Exception)((Object)e));
                catch (LdapException e2) {
                    String error = "create config dn [" + dn + "] caught LDAPException=" + e2;
                    LOG.error(error, (Throwable)e2);
                    throw new CreateException(120, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return cfg;
    }

    Configuration update(Configuration cfg) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(cfg.getName());
        LOG.debug("update dn [{}]", (Object)dn);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (PropUtil.isNotEmpty(cfg.getProperties())) {
                this.loadProperties(cfg.getProperties(), mods, "ftProps", false);
            }
            if (StringUtils.isNotEmpty((CharSequence)cfg.getUidNumber())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, UID_NUMBER_SEQUENCE, new String[]{cfg.getUidNumber()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)cfg.getGidNumber())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, GID_NUMBER_SEQUENCE, new String[]{cfg.getGidNumber()}));
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)cfg);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update dn [" + dn + "] caught LDAPException=" + e;
                throw new UpdateException(121, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return cfg;
    }

    void updateProperty(String name, String key, String value, String newValue) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(name);
        LOG.debug("update dn [{}], key [{}], value [{}], newValue [{}]", new Object[]{dn, key, value, newValue});
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftProps", new String[]{key + ":" + value}));
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftProps", new String[]{key + ":" + newValue}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods);
        }
        catch (LdapException e) {
            try {
                String error = "updateProperty dn [" + dn + "] caught LDAPException=" + e;
                throw new UpdateException(121, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    void remove(String name) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(name);
        LOG.info("remove dn [{}]", (Object)dn);
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn);
        }
        catch (LdapException e) {
            String error = "remove dn [" + dn + "] LDAPException=" + e;
            throw new RemoveException(122, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    Properties remove(String name, Properties props) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(name);
        LOG.info("remove props dn [{}]", (Object)dn);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (PropUtil.isNotEmpty(props)) {
                this.removeProperties(props, mods, "ftProps");
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods);
            }
        }
        catch (LdapException e) {
            try {
                String error = "remove props dn [" + dn + "] caught LDAPException=" + e;
                throw new UpdateException(123, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return props;
    }

    Configuration getConfig(String name) throws FinderException {
        Configuration configuration = new Configuration();
        LdapConnection ld = null;
        String dn = this.getDn(name);
        LOG.info("getConfig dn [{}]", (Object)dn);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, this.CONFIG_ATRS);
            configuration.setName(name);
            configuration.addProperties(PropUtil.getProperties(this.getAttributes(findEntry, "ftProps")));
            configuration.setUidNumber(this.getAttribute(findEntry, UID_NUMBER_SEQUENCE));
            configuration.setGidNumber(this.getAttribute(findEntry, GID_NUMBER_SEQUENCE));
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getConfig COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(107, warning, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "getConfig dn [" + dn + "] caught LdapException=" + e;
            throw new FinderException(124, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return configuration;
    }

    Configuration getPosixIds(String name) throws FinderException {
        Configuration configuration = new Configuration();
        LdapConnection ld = null;
        String dn = this.getDn(name);
        LOG.debug("getPosixIds dn [{}]", (Object)dn);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, this.POSIX_IDS);
            configuration.setName(name);
            configuration.setUidNumber(this.getAttribute(findEntry, UID_NUMBER_SEQUENCE));
            configuration.setGidNumber(this.getAttribute(findEntry, GID_NUMBER_SEQUENCE));
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getPosixIds COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(107, warning, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "getPosixIds dn [" + dn + "] caught LdapException=" + e;
            throw new FinderException(124, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return configuration;
    }

    private String getDn(String name) {
        return "cn=" + name + "," + Config.getInstance().getProperty("config.root");
    }
}

