/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AccessMgrImpl;
import org.apache.directory.fortress.core.impl.AdminRoleUtil;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.PsoUtil;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SDUtil;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.impl.UsoUtil;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public class DelAccessMgrImpl
extends AccessMgrImpl
implements DelAccessMgr,
Serializable {
    private final String CLS_NM = DelAccessMgrImpl.class.getName();
    private UserP userP = new UserP();
    private PermP permP = new PermP();
    private String SUPER_ADMIN = Config.getInstance().getProperty("superadmin.role", "fortress-core-super-admin");
    private String REST_ADMIN = Config.getInstance().getProperty("serviceadmin.role", "fortress-rest-admin");

    @Override
    public boolean canAssign(Session session, User user, Role role) throws SecurityException {
        String methodName = "canAssign";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, user, 1008);
        this.assertContext(this.CLS_NM, methodName, role, 5007);
        return this.checkUserRole(session, user, role);
    }

    @Override
    public boolean canDeassign(Session session, User user, Role role) throws SecurityException {
        String methodName = "canDeassign";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, user, 1008);
        this.assertContext(this.CLS_NM, methodName, role, 5007);
        return this.checkUserRole(session, user, role);
    }

    @Override
    public boolean canGrant(Session session, Role role, Permission perm) throws SecurityException {
        String methodName = "canGrant";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, perm, 3010);
        this.assertContext(this.CLS_NM, methodName, role, 5007);
        return this.checkRolePermission(session, role, perm);
    }

    @Override
    public boolean canRevoke(Session session, Role role, Permission perm) throws SecurityException {
        String methodName = "canRevoke";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, perm, 3010);
        this.assertContext(this.CLS_NM, methodName, role, 5007);
        return this.checkRolePermission(session, role, perm);
    }

    @Override
    public boolean canAdd(Session session, User user) throws SecurityException {
        String methodName = "canAssign";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, user, 1008);
        VUtil.assertNotNullOrEmpty(user.getOu(), 1041, methodName);
        return this.checkUser(session, user, true);
    }

    @Override
    public boolean canEdit(Session session, User user) throws SecurityException {
        String methodName = "canAssign";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, user, 1008);
        return this.checkUser(session, user, false);
    }

    @Override
    public boolean checkAccess(Session session, Permission perm) throws SecurityException {
        String methodName = "checkAccess";
        this.assertContext(this.CLS_NM, methodName, perm, 3008);
        VUtil.assertNotNullOrEmpty(perm.getOpName(), 3009, methodName);
        VUtil.assertNotNullOrEmpty(perm.getObjName(), 3010, methodName);
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        perm.setAdmin(true);
        return super.checkAccess(session, perm);
    }

    @Override
    public void addActiveRole(Session session, UserAdminRole role) throws SecurityException {
        int indx;
        String methodName = "addActiveRole";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, role, 9007);
        role.setUserId(session.getUserId());
        List<UserAdminRole> sRoles = session.getAdminRoles();
        if (sRoles != null && sRoles.contains(role)) {
            String info = this.getFullMethodName(this.CLS_NM, methodName) + " User [" + session.getUserId() + "] Role [" + role.getName() + "] role already activated.";
            throw new SecurityException(9016, info);
        }
        User ue = this.userP.read(session.getUser(), true);
        List<UserAdminRole> uRoles = ue.getAdminRoles();
        if (!CollectionUtils.isNotEmpty(uRoles) || (indx = uRoles.indexOf(role)) == -1) {
            String info = this.getFullMethodName(this.CLS_NM, methodName) + " Admin Role [" + role.getName() + "] User [" + session.getUserId() + "] adminRole not authorized for user.";
            throw new SecurityException(9014, info);
        }
        SDUtil.getInstance().validateDSD(session, role);
        session.setRole(uRoles.get(indx));
    }

    @Override
    public void dropActiveRole(Session session, UserAdminRole role) throws SecurityException {
        String methodName = "dropActiveRole";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, role, 9007);
        role.setUserId(session.getUserId());
        List<UserAdminRole> roles = session.getAdminRoles();
        VUtil.assertNotNull(roles, 9015, methodName);
        int indx = roles.indexOf(role);
        if (indx == -1) {
            String info = methodName + " Admin Role [" + role.getName() + "] User [" + session.getUserId() + "], not previously activated";
            throw new SecurityException(9017, info);
        }
        roles.remove(role);
    }

    @Override
    @AdminPermissionOperation
    public List<UserAdminRole> sessionAdminRoles(Session session) throws SecurityException {
        String methodName = "sessionAdminRoles";
        VUtil.assertNotNull(session, 1030, this.CLS_NM + ".sessionAdminRoles");
        this.setEntitySession(this.CLS_NM, methodName, session);
        return session.getAdminRoles();
    }

    @Override
    @AdminPermissionOperation
    public Set<String> authorizedAdminRoles(Session session) throws SecurityException {
        String methodName = "authorizedAdminRoles";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        this.assertContext(this.CLS_NM, methodName, session.getUser(), 1008);
        this.setEntitySession(this.CLS_NM, methodName, session);
        return AdminRoleUtil.getInheritedRoles(session.getAdminRoles(), this.contextId);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> sessionPermissions(Session session) throws SecurityException {
        String methodName = "sessionPermissions";
        this.assertContext(this.CLS_NM, methodName, session, 1030);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, false);
        this.setEntitySession(this.CLS_NM, methodName, session);
        return this.permP.search(session, true);
    }

    private boolean checkUser(Session session, User user, boolean isAdd) throws SecurityException {
        boolean result = false;
        List<UserAdminRole> uaRoles = session.getAdminRoles();
        if (CollectionUtils.isNotEmpty(uaRoles)) {
            User ue = !isAdd ? this.userP.read(user, false) : user;
            for (UserAdminRole uaRole : uaRoles) {
                if (uaRole.getName().equalsIgnoreCase(this.SUPER_ADMIN)) {
                    result = true;
                    break;
                }
                Set<String> osUs = uaRole.getOsUSet();
                if (!CollectionUtils.isNotEmpty(osUs)) continue;
                TreeSet<String> osUsFinal = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String osU : osUs) {
                    osUsFinal.add(osU);
                    Set<String> children = UsoUtil.getInstance().getDescendants(osU, this.contextId);
                    osUsFinal.addAll(children);
                }
                if (!osUsFinal.contains(ue.getOu())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkUserRole(Session session, User user, Role role) throws SecurityException {
        boolean result = false;
        List<UserAdminRole> uaRoles = session.getAdminRoles();
        if (CollectionUtils.isNotEmpty(uaRoles)) {
            User ue = this.userP.read(user, false);
            for (UserAdminRole uaRole : uaRoles) {
                if (uaRole.getName().equalsIgnoreCase(this.SUPER_ADMIN)) {
                    result = true;
                    break;
                }
                Set<String> osUs = uaRole.getOsUSet();
                if (!CollectionUtils.isNotEmpty(osUs)) continue;
                TreeSet<String> osUsFinal = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String osU : osUs) {
                    osUsFinal.add(osU);
                    Set<String> children = UsoUtil.getInstance().getDescendants(osU, this.contextId);
                    osUsFinal.addAll(children);
                }
                if (!osUsFinal.contains(ue.getOu())) continue;
                if (uaRole.getName().equalsIgnoreCase(this.REST_ADMIN)) {
                    result = true;
                    break;
                }
                if (uaRole.getBeginRange() != null && uaRole.getEndRange() != null && !uaRole.getBeginRange().equalsIgnoreCase(uaRole.getEndRange())) {
                    Set<String> range = RoleUtil.getInstance().getAscendants(uaRole.getBeginRange(), uaRole.getEndRange(), uaRole.isEndInclusive(), this.contextId);
                    if (uaRole.isBeginInclusive()) {
                        range.add(uaRole.getBeginRange());
                    }
                    if (!CollectionUtils.isNotEmpty(range) || !range.contains(role.getName())) continue;
                    result = true;
                    break;
                }
                if (uaRole.getBeginRange() == null || !uaRole.getBeginRange().equalsIgnoreCase(role.getName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkRolePermission(Session session, Role role, Permission perm) throws SecurityException {
        boolean result = false;
        List<UserAdminRole> uaRoles = session.getAdminRoles();
        if (CollectionUtils.isNotEmpty(uaRoles)) {
            PermObj inObj = new PermObj(perm.getObjName());
            inObj.setContextId(this.contextId);
            PermObj pObj = this.permP.read(inObj);
            for (UserAdminRole uaRole : uaRoles) {
                if (uaRole.getName().equalsIgnoreCase(this.SUPER_ADMIN)) {
                    result = true;
                    break;
                }
                Set<String> osPs = uaRole.getOsPSet();
                if (!CollectionUtils.isNotEmpty(osPs)) continue;
                TreeSet<String> osPsFinal = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String osP : osPs) {
                    osPsFinal.add(osP);
                    Set<String> children = PsoUtil.getInstance().getDescendants(osP, this.contextId);
                    osPsFinal.addAll(children);
                }
                if (!osPsFinal.contains(pObj.getOu())) continue;
                if (uaRole.getName().equalsIgnoreCase(this.REST_ADMIN)) {
                    result = true;
                    break;
                }
                if (uaRole.getBeginRange() != null && uaRole.getEndRange() != null && !uaRole.getBeginRange().equalsIgnoreCase(uaRole.getEndRange())) {
                    Set<String> range = RoleUtil.getInstance().getAscendants(uaRole.getBeginRange(), uaRole.getEndRange(), uaRole.isEndInclusive(), this.contextId);
                    if (uaRole.isBeginInclusive()) {
                        range.add(uaRole.getBeginRange());
                    }
                    if (!CollectionUtils.isNotEmpty(range) || !range.contains(role.getName())) continue;
                    result = true;
                    break;
                }
                if (uaRole.getBeginRange() == null || !uaRole.getBeginRange().equalsIgnoreCase(role.getName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

