/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.PasswordException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.PolicyDAO;
import org.apache.directory.fortress.core.impl.RoleDAO;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.Address;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PwMessage;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.model.Warning;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUpdater;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UserDAO
extends LdapDataProvider
implements PropUpdater {
    private static final String CLS_NM = UserDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String USERS_AUX_OBJECT_CLASS_NAME = "ftUserAttrs";
    private static final String USER_OBJECT_CLASS = "user.objectclass";
    private static final String USERS_EXTENSIBLE_OBJECT = "extensibleObject";
    private static final String SYSTEM_USER = "ftSystem";
    private static final String DEPARTMENT_NUMBER = "departmentNumber";
    private static final String ROOM_NUMBER = "roomNumber";
    private static final String MOBILE = "mobile";
    private static final String JPEGPHOTO = "jpegPhoto";
    private static final String EMPLOYEE_TYPE = "employeeType";
    private static final String OPENLDAP_POLICY_SUBENTRY = "pwdPolicySubentry";
    private static final String OPENLDAP_PW_RESET = "pwdReset";
    private static final String OPENLDAP_PW_LOCKED_TIME = "pwdAccountLockedTime";
    private static final String LOCK_VALUE = "000001010000Z";
    private static final String POSIX_ACCOUNT = "posixAccount";
    private static final String HOME_DIRECTORY = "homeDirectory";
    private static final String USER_ROLE_ASSIGN = "ftRA";
    private static final String[] USERID = new String[]{"uid"};
    private static final String[] ROLES = new String[]{"ftRA"};
    private static final String[] USERID_ATRS = new String[]{"uid"};
    private static String[] authnAtrs = null;
    private static String[] defaultAtrs = null;
    private static final String[] ROLE_ATR = new String[]{"ftRC"};
    private static final String[] AROLE_ATR = new String[]{"ftARC"};
    private static final String[] USERID_ATR = new String[]{"uid"};

    UserDAO() {
        this.initAttrArrays();
    }

    @Override
    public String newValue(String value) {
        Integer id = new Integer(value);
        Integer newId = id + 1;
        return newId.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    User create(User entity) throws CreateException {
        LdapConnection ld = null;
        boolean setRelaxControl = false;
        try {
            entity.setInternalId();
            String dn = this.getDn(entity.getUserId(), entity.getContextId());
            DefaultEntry myEntry = new DefaultEntry(dn);
            myEntry.add("objectClass", this.getUserObjectClass());
            myEntry.add("ftId", new String[]{entity.getInternalId()});
            myEntry.add("uid", new String[]{entity.getUserId()});
            if (StringUtils.isEmpty((CharSequence)entity.getCn())) {
                entity.setCn(entity.getUserId());
            }
            myEntry.add("cn", new String[]{entity.getCn()});
            if (StringUtils.isEmpty((CharSequence)entity.getSn())) {
                entity.setSn(entity.getUserId());
            }
            myEntry.add("sn", new String[]{entity.getSn()});
            if (StringUtils.isNotEmpty((CharSequence)entity.getPassword())) {
                myEntry.add("userPassword", new String[]{entity.getPassword()});
            } else if (!Config.getInstance().getBoolean("user.creation.field.password.disable", false)) {
                myEntry.add("userPassword", new String[]{new String()});
            }
            myEntry.add("displayName", new String[]{StringUtils.isNotEmpty((CharSequence)entity.getDisplayName()) ? entity.getDisplayName() : entity.getCn()});
            if (StringUtils.isNotEmpty((CharSequence)entity.getTitle())) {
                myEntry.add("title", new String[]{entity.getTitle()});
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getEmployeeType())) {
                myEntry.add(EMPLOYEE_TYPE, new String[]{entity.getEmployeeType()});
            }
            this.loadAttrs(entity.getPhones(), (Entry)myEntry, "telephoneNumber");
            this.loadAttrs(entity.getMobiles(), (Entry)myEntry, MOBILE);
            this.loadAttrs(entity.getEmails(), (Entry)myEntry, "mail");
            if (entity.isSystem() != null) {
                myEntry.add(SYSTEM_USER, new String[]{entity.isSystem().toString().toUpperCase()});
            }
            if ((Config.getInstance().isOpenldap() || Config.getInstance().isApacheds()) && StringUtils.isNotEmpty((CharSequence)entity.getPwPolicy())) {
                myEntry.add(OPENLDAP_POLICY_SUBENTRY, new String[]{PolicyDAO.getPolicyDn(entity)});
                setRelaxControl = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getOu())) {
                myEntry.add("ou", new String[]{entity.getOu()});
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
                myEntry.add("description", new String[]{entity.getDescription()});
            }
            entity.addProperty("init", "");
            this.loadProperties(entity.getProperties(), (Entry)myEntry, "ftProps");
            entity.setName(entity.getUserId());
            myEntry.add("ftCstr", new String[]{ConstraintUtil.setConstraint(entity)});
            this.loadAddress(entity.getAddress(), (Entry)myEntry);
            if (ArrayUtils.isNotEmpty((byte[])entity.getJpegPhoto())) {
                myEntry.add(JPEGPHOTO, (byte[][])new byte[][]{entity.getJpegPhoto()});
            }
            if (RoleDAO.IS_RFC2307) {
                this.loadPosixIds(entity);
                myEntry.add("uidNumber", new String[]{entity.getUidNumber()});
                myEntry.add("gidNumber", new String[]{entity.getGidNumber()});
                if (StringUtils.isEmpty((CharSequence)entity.getHomeDirectory())) {
                    entity.setHomeDirectory("/home/" + entity.getUserId());
                }
                myEntry.add(HOME_DIRECTORY, new String[]{entity.getHomeDirectory()});
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)myEntry, entity, setRelaxControl);
            entity.setDn(dn);
        }
        catch (LdapEntryAlreadyExistsException e) {
            try {
                String error = "create userId [" + entity.getUserId() + "] failed, already exists in directory";
                throw new CreateException(1038, error, (Exception)((Object)e));
                catch (LdapException e2) {
                    error = "create userId [" + entity.getUserId() + "] caught LDAPException=" + e2;
                    throw new CreateException(1002, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    User update(User entity) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(entity.getUserId(), entity.getContextId());
        boolean setRelaxControl = false;
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((CharSequence)entity.getCn())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "cn", new String[]{entity.getCn()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getSn())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "sn", new String[]{entity.getSn()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getOu())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ou", new String[]{entity.getOu()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getPassword())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{entity.getPassword()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getEmployeeType())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, EMPLOYEE_TYPE, new String[]{entity.getEmployeeType()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getDisplayName())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "displayName", new String[]{entity.getDisplayName()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getTitle())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "title", new String[]{entity.getTitle()}));
            }
            if ((Config.getInstance().isOpenldap() || Config.getInstance().isApacheds()) && StringUtils.isNotEmpty((CharSequence)entity.getPwPolicy())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, OPENLDAP_POLICY_SUBENTRY, new String[]{PolicyDAO.getPolicyDn(entity)}));
                setRelaxControl = true;
            }
            if (entity.isSystem() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, SYSTEM_USER, new String[]{entity.isSystem().toString().toUpperCase()}));
            }
            if (entity.isTemporalSet()) {
                entity.setName(entity.getUserId());
                String szRawData = ConstraintUtil.setConstraint(entity);
                if (StringUtils.isNotEmpty((CharSequence)szRawData)) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftCstr", new String[]{szRawData}));
                }
            }
            if (PropUtil.isNotEmpty(entity.getProperties())) {
                this.loadProperties(entity.getProperties(), mods, "ftProps", true);
            }
            this.loadAddress(entity.getAddress(), mods);
            this.loadAttrs(entity.getPhones(), mods, "telephoneNumber");
            this.loadAttrs(entity.getMobiles(), mods, MOBILE);
            this.loadAttrs(entity.getEmails(), mods, "mail");
            if (ArrayUtils.isNotEmpty((byte[])entity.getJpegPhoto())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, JPEGPHOTO, (byte[][])new byte[][]{entity.getJpegPhoto()}));
            }
            if (RoleDAO.IS_RFC2307) {
                if (StringUtils.isNotEmpty((CharSequence)entity.getUidNumber())) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "uidNumber", new String[]{entity.getUidNumber()}));
                }
                if (StringUtils.isNotEmpty((CharSequence)entity.getGidNumber())) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "gidNumber", new String[]{entity.getGidNumber()}));
                }
                if (StringUtils.isNotEmpty((CharSequence)entity.getHomeDirectory())) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, HOME_DIRECTORY, new String[]{entity.getHomeDirectory()}));
                }
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, userDn, mods, (FortEntity)entity, setRelaxControl);
                entity.setDn(userDn);
            }
            entity.setDn(userDn);
        }
        catch (LdapException e) {
            try {
                String error = "update userId [" + entity.getUserId() + "] caught LDAPException=" + e;
                throw new UpdateException(1003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    User updateProps(User entity, boolean replace) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(entity.getUserId(), entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (PropUtil.isNotEmpty(entity.getProperties())) {
                this.loadProperties(entity.getProperties(), mods, "ftProps", replace);
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, userDn, mods, (FortEntity)entity);
                entity.setDn(userDn);
            }
            entity.setDn(userDn);
        }
        catch (LdapException e) {
            try {
                String error = "updateProps userId [" + entity.getUserId() + "] isReplace [" + replace + "] caught LDAPException=" + e;
                throw new UpdateException(1003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    String remove(User user) throws RemoveException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ld = this.getAdminConnection();
            this.delete(ld, userDn, (FortEntity)user);
        }
        catch (LdapException e) {
            String error = "remove userId [" + user.getUserId() + "] caught LDAPException=" + e;
            throw new RemoveException(1004, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return userDn;
    }

    void lock(User user) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, OPENLDAP_PW_LOCKED_TIME, new String[]{LOCK_VALUE}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)user, true);
        }
        catch (LdapException e) {
            try {
                String error = "lock user [" + user.getUserId() + "] caught LDAPException=" + e;
                throw new UpdateException(1025, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    /*
     * Loose catch block
     */
    void unlock(User user) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, OPENLDAP_PW_LOCKED_TIME));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)user, true);
            this.closeAdminConnection(ld);
        }
        catch (LdapNoSuchAttributeException e) {
            LOG.info("unlock user [" + user.getUserId() + "] no such attribute:pwdAccountLockedTime");
        }
        catch (LdapException e2) {
            String error = "unlock user [" + user.getUserId() + "] caught LDAPException= " + e2;
            throw new UpdateException(1024, error, (Exception)((Object)e2));
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    User getUser(User user, boolean isRoles) throws FinderException {
        User entity = null;
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        String[] uATTRS = isRoles ? defaultAtrs : authnAtrs;
        Entry findEntry = null;
        try {
            ld = this.getAdminConnection();
            findEntry = this.read(ld, userDn, uATTRS);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getUser COULD NOT FIND ENTRY for user [" + user.getUserId() + "]";
            throw new FinderException(1005, warning);
        }
        catch (LdapException e) {
            String error = "getUser [" + userDn + "]= caught LDAPException=" + e;
            throw new FinderException(1001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        try {
            if (findEntry != null) {
                entity = this.unloadLdapEntry(findEntry, 0L, user.getContextId());
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            entity = null;
        }
        if (entity == null) {
            String warning = "getUser userId [" + user.getUserId() + "] not found, Fortress rc=1005";
            throw new FinderException(1005, warning);
        }
        return entity;
    }

    List<UserAdminRole> getUserAdminRoles(User user) throws FinderException {
        List<UserAdminRole> roles = null;
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, userDn, AROLE_ATR);
            roles = this.unloadUserAdminRoles(findEntry, user.getUserId(), user.getContextId());
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getUserAdminRoles COULD NOT FIND ENTRY for user [" + user.getUserId() + "]";
            throw new FinderException(1005, warning);
        }
        catch (LdapException e) {
            String error = "getUserAdminRoles [" + userDn + "]= caught LDAPException=" + e;
            throw new FinderException(1001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return roles;
    }

    List<String> getRoles(User user) throws FinderException {
        List<String> roles = null;
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, userDn, ROLES);
            if (findEntry == null) {
                String warning = "getRoles userId [" + user.getUserId() + "] not found, Fortress rc=1005";
                throw new FinderException(1005, warning);
            }
            roles = this.getAttributes(findEntry, USER_ROLE_ASSIGN);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getRoles COULD NOT FIND ENTRY for user [" + user.getUserId() + "]";
            throw new FinderException(1005, warning);
        }
        catch (LdapException e) {
            String error = "getRoles [" + userDn + "]= caught LDAPException=" + e;
            throw new FinderException(2010, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return roles;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Session checkPassword(User user) throws FinderException, PasswordException {
        Session session = null;
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            session = new ObjectFactory().createSession();
            session.setAuthenticated(false);
            session.setUserId(user.getUserId());
            ld = this.getUserConnection();
            BindResponse bindResponse = this.bind(ld, userDn, user.getPassword());
            if (bindResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                String info = "PASSWORD INVALID for userId [" + user.getUserId() + "], resultCode [" + bindResponse.getLdapResult().getResultCode() + "]";
                session.setMsg(info);
                session.setErrorId(1013);
            }
            this.checkPwPolicies(session, bindResponse);
            if (session.getErrorId() != 0) throw new PasswordException(session.getErrorId(), session.getMsg());
            session.setAuthenticated(true);
        }
        catch (LdapAuthenticationException e) {
            try {
                String info = "checkPassword INVALID PASSWORD for userId [" + user.getUserId() + "] exception [" + e + "]";
                throw new PasswordException(1013, info);
                catch (LdapException e2) {
                    String error = "checkPassword userId [" + user.getUserId() + "] caught LDAPException=" + e2;
                    throw new FinderException(1001, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeUserConnection(ld);
                throw throwable;
            }
        }
        this.closeUserConnection(ld);
        return session;
    }

    private void checkPwPolicies(PwMessage pwMsg, BindResponse bindResponse) {
        int rc = 0;
        boolean result = false;
        String msgHdr = "checkPwPolicies for userId [" + pwMsg.getUserId() + "] ";
        PasswordPolicyResponse respCtrl = this.getPwdRespCtrl(bindResponse);
        if (respCtrl != null) {
            String errMsg = null;
            if (respCtrl.getTimeBeforeExpiration() > 0) {
                pwMsg.setExpirationSeconds(respCtrl.getTimeBeforeExpiration());
                pwMsg.setWarning(new ObjectFactory().createWarning(11, "PASSWORD WILL EXPIRE", Warning.Type.PASSWORD));
            }
            if (respCtrl.getGraceAuthNRemaining() > 0) {
                pwMsg.setGraceLogins(respCtrl.getGraceAuthNRemaining());
                pwMsg.setWarning(new ObjectFactory().createWarning(12, "PASSWORD IN GRACE", Warning.Type.PASSWORD));
            }
            if (respCtrl.getPasswordPolicyError() != null) {
                switch (respCtrl.getPasswordPolicyError()) {
                    case CHANGE_AFTER_RESET: {
                        if (!Config.getInstance().isRealm()) {
                            errMsg = msgHdr + "PASSWORD HAS BEEN RESET BY LDAP_ADMIN_POOL_UID";
                            rc = 1015;
                            break;
                        }
                        errMsg = msgHdr + "PASSWORD HAS BEEN RESET BY LDAP_ADMIN_POOL_UID BUT ALLOWING TO CONTINUE DUE TO REALM";
                        result = true;
                        pwMsg.setWarning(new ObjectFactory().createWarning(1015, errMsg, Warning.Type.PASSWORD));
                        break;
                    }
                    case ACCOUNT_LOCKED: {
                        errMsg = msgHdr + "ACCOUNT HAS BEEN LOCKED";
                        rc = 1016;
                        break;
                    }
                    case PASSWORD_EXPIRED: {
                        errMsg = msgHdr + "PASSWORD HAS EXPIRED";
                        rc = 1017;
                        break;
                    }
                    case PASSWORD_MOD_NOT_ALLOWED: {
                        errMsg = msgHdr + "PASSWORD MOD NOT ALLOWED";
                        rc = 1018;
                        break;
                    }
                    case MUST_SUPPLY_OLD_PASSWORD: {
                        errMsg = msgHdr + "MUST SUPPLY OLD PASSWORD";
                        rc = 1019;
                        break;
                    }
                    case INSUFFICIENT_PASSWORD_QUALITY: {
                        errMsg = msgHdr + "PASSWORD QUALITY VIOLATION";
                        rc = 1020;
                        break;
                    }
                    case PASSWORD_TOO_SHORT: {
                        errMsg = msgHdr + "PASSWORD TOO SHORT";
                        rc = 1021;
                        break;
                    }
                    case PASSWORD_TOO_YOUNG: {
                        errMsg = msgHdr + "PASSWORD TOO YOUNG";
                        rc = 1022;
                        break;
                    }
                    case PASSWORD_IN_HISTORY: {
                        errMsg = msgHdr + "PASSWORD IN HISTORY VIOLATION";
                        rc = 1023;
                        break;
                    }
                    default: {
                        errMsg = msgHdr + "PASSWORD CHECK FAILED";
                        rc = 1014;
                    }
                }
            }
            if (rc != 0) {
                pwMsg.setMsg(errMsg);
                pwMsg.setErrorId(rc);
                pwMsg.setAuthenticated(result);
                LOG.debug(errMsg);
            }
        }
    }

    List<User> findUsers(User user) throws FinderException {
        ArrayList<User> userList = new ArrayList<User>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(user.getContextId(), "user.root");
        try {
            String searchVal;
            StringBuilder filterbuf = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)user.getUserId())) {
                searchVal = this.encodeSafeText(user.getUserId(), 40);
                filterbuf.append("(&(objectClass=");
                filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
                filterbuf.append(")(");
                filterbuf.append("uid");
                filterbuf.append("=");
                filterbuf.append(searchVal);
                filterbuf.append("*))");
            } else if (StringUtils.isNotEmpty((CharSequence)user.getInternalId())) {
                searchVal = this.encodeSafeText(user.getInternalId(), 40);
                filterbuf.append("(&(objectClass=");
                filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
                filterbuf.append(")(");
                filterbuf.append("ftId");
                filterbuf.append("=");
                filterbuf.append(searchVal);
                filterbuf.append("))");
            } else {
                filterbuf.append("(objectclass=");
                filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
                filterbuf.append(")");
            }
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", Config.getInstance().getInt("ldap.search.max.batch.size", 1000)));){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, user.getContextId()));
                }
            }
            catch (IOException e) {
                String warning = "findUsers userRoot [" + userRoot + "] caught IOException=" + e.getMessage();
                throw new FinderException(1000, warning, e);
            }
            catch (CursorException e) {
                String warning = "findUsers userRoot [" + userRoot + "] caught CursorException=" + e.getMessage();
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "findUsers userRoot [" + userRoot + "] caught LDAPException=" + e;
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<String> findUsers(User user, int limit) throws FinderException {
        ArrayList<String> userList = new ArrayList<String>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(user.getContextId(), "user.root");
        try {
            String searchVal = this.encodeSafeText(user.getUserId(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
            filterbuf.append(")(");
            filterbuf.append("uid");
            filterbuf.append("=");
            filterbuf.append(searchVal);
            filterbuf.append("*))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), USERID, false, limit);){
                while (searchResults.next()) {
                    Entry entry = searchResults.getEntry();
                    userList.add(this.getAttribute(entry, "uid"));
                }
            }
            catch (IOException e) {
                String warning = "findUsers caught IOException=" + e.getMessage();
                throw new FinderException(1000, warning, e);
            }
            catch (CursorException e) {
                String warning = "findUsers caught CursorException=" + e.getMessage();
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "findUsers caught LdapException=" + e;
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<User> getAuthorizedUsers(Role role) throws FinderException {
        ArrayList<User> userList = new ArrayList<User>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String warning;
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            Set<String> roles = RoleUtil.getInstance().getDescendants(role.getName(), role.getContextId());
            if (CollectionUtils.isNotEmpty(roles)) {
                filterbuf.append("|(");
                filterbuf.append(USER_ROLE_ASSIGN);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
                for (String uRole : roles) {
                    filterbuf.append("(");
                    filterbuf.append(USER_ROLE_ASSIGN);
                    filterbuf.append("=");
                    filterbuf.append(uRole);
                    filterbuf.append(")");
                }
                filterbuf.append(")");
            } else {
                filterbuf.append(USER_ROLE_ASSIGN);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
            }
            filterbuf.append(")");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, role.getContextId()));
                }
            }
            catch (IOException e) {
                warning = "getAuthorizedUsers role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                warning = "getAuthorizedUsers role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAuthorizedUsers role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<User> getAssignedUsers(Role role, RoleConstraint roleConstraint) throws FinderException {
        ArrayList<User> userList = new ArrayList<User>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(USER_ROLE_ASSIGN);
            filterbuf.append("=");
            filterbuf.append(roleVal);
            filterbuf.append(")");
            if (roleConstraint != null) {
                filterbuf.append("(");
                filterbuf.append("ftRC");
                filterbuf.append("=");
                filterbuf.append(roleConstraint.getRawData(new UserRole(role.getName())));
                filterbuf.append(")");
            }
            filterbuf.append(")");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, role.getContextId()));
                }
            }
            catch (IOException e) {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught CursorException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<UserRole> getUserRoles(Role role, RoleConstraint.RCType rcType, String paSetName) throws FinderException {
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(USER_ROLE_ASSIGN);
            filterbuf.append("=");
            filterbuf.append(roleVal);
            filterbuf.append(")");
            filterbuf.append("(");
            filterbuf.append("ftRC");
            filterbuf.append("=");
            filterbuf.append(this.getFilterForRoleConstraint(role.getName(), rcType, paSetName));
            filterbuf.append(")");
            filterbuf.append(")");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    userRoleList.addAll(this.unloadUserRoles(searchResults.getEntry(), this.getAttribute(searchResults.getEntry(), "uid"), role.getContextId(), role.getName()));
                }
            }
            catch (IOException e) {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught CursorException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAssignedUsers role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userRoleList;
    }

    private String getFilterForRoleConstraint(String roleName, RoleConstraint.RCType rcType, String paSetName) {
        StringBuilder sb = new StringBuilder();
        String delimeter = Config.getInstance().getDelimiter();
        sb.append(roleName);
        sb.append(delimeter);
        sb.append("type");
        sb.append(delimeter);
        sb.append((Object)rcType);
        sb.append(delimeter);
        sb.append(paSetName);
        sb.append(delimeter);
        sb.append("*");
        return sb.toString();
    }

    List<String> getAssignedUserIds(Role role) throws FinderException {
        ArrayList<String> userList = new ArrayList<String>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(USER_ROLE_ASSIGN);
            filterbuf.append("=");
            filterbuf.append(roleVal);
            filterbuf.append("))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), USERID_ATR, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    userList.add(this.unloadUser(searchResults.getEntry()));
                }
            }
            catch (IOException e) {
                String warning = "getAssignedUserIds role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                String warning = "getAssignedUserIds role name [" + role.getName() + "] caught CursorException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAssignedUserIds role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    Set<String> getAssignedUsers(Set<String> roles, String contextId) throws FinderException {
        HashSet<String> userSet = new HashSet<String>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(contextId, "user.root");
        try {
            String warning;
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(|");
            if (CollectionUtils.isNotEmpty(roles)) {
                for (String roleVal : roles) {
                    String filteredVal = this.encodeSafeText(roleVal, 40);
                    filterbuf.append("(");
                    filterbuf.append(USER_ROLE_ASSIGN);
                    filterbuf.append("=");
                    filterbuf.append(filteredVal);
                    filterbuf.append(")");
                }
            } else {
                Set<String> set = null;
                return set;
            }
            filterbuf.append("))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), USERID_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    userSet.add(this.getAttribute(searchResults.getEntry(), "uid"));
                }
            }
            catch (IOException e) {
                warning = "getAssignedUsers caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                warning = "getAssignedUsers caught CursorException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            this.closeAdminConnection(ld);
        }
        catch (LdapException e) {
            String warning = "getAssignedUsers caught LDAPException=" + e;
            throw new FinderException(2010, warning, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return userSet;
    }

    List<User> getAssignedUsers(AdminRole role) throws FinderException {
        ArrayList<User> userList = new ArrayList<User>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append("ftARA");
            filterbuf.append("=");
            filterbuf.append(roleVal);
            filterbuf.append("))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, role.getContextId()));
                }
            }
            catch (IOException e) {
                String warning = "getAssignedUsers admin role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(9018, warning, e);
            }
            catch (CursorException e) {
                String warning = "getAssignedUsers admin role name [" + role.getName() + "] caught CursorException=" + e.getMessage();
                throw new FinderException(9018, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAssignedUsers admin role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(9018, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<String> getAuthorizedUsers(Role role, int limit) throws FinderException {
        ArrayList<String> userList = new ArrayList<String>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(role.getContextId(), "user.root");
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(USERS_AUX_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(USER_ROLE_ASSIGN);
            filterbuf.append("=");
            filterbuf.append(roleVal);
            filterbuf.append("))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), USERID, false, limit);){
                while (searchResults.next()) {
                    Entry entry = searchResults.getEntry();
                    userList.add(this.getAttribute(entry, "uid"));
                }
            }
            catch (IOException e) {
                String warning = "getAuthorizedUsers role name [" + role.getName() + "] caught IOException=" + e.getMessage();
                throw new FinderException(2010, warning, e);
            }
            catch (CursorException e) {
                String warning = "getAuthorizedUsers role name [" + role.getName() + "] caught CursorException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "getAuthorizedUsers role name [" + role.getName() + "] caught LDAPException=" + e.getMessage();
                throw new FinderException(2010, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<String> findUsersList(String searchVal, String contextId) throws FinderException {
        ArrayList<String> userList = new ArrayList<String>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(contextId, "user.root");
        try {
            searchVal = this.encodeSafeText(searchVal, 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
            filterbuf.append(")(");
            filterbuf.append("uid");
            filterbuf.append("=");
            filterbuf.append(searchVal);
            filterbuf.append("*))");
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, contextId).getUserId());
                }
            }
            catch (IOException e) {
                String warning = "findUsersList caught IOException=" + e.getMessage();
                throw new FinderException(1000, warning, e);
            }
            catch (CursorException e) {
                String warning = "findUsersList caught CursorException=" + e.getMessage();
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "findUsersList caught LDAPException=" + e;
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    List<User> findUsers(OrgUnit ou, boolean limitSize) throws FinderException {
        ArrayList<User> userList = new ArrayList<User>();
        LdapConnection ld = null;
        String userRoot = UserDAO.getRootDn(ou.getContextId(), "user.root");
        try {
            String szOu = this.encodeSafeText(ou.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(Config.getInstance().getProperty(USER_OBJECT_CLASS));
            filterbuf.append(")(");
            filterbuf.append("ou");
            filterbuf.append("=");
            filterbuf.append(szOu);
            filterbuf.append("))");
            int maxLimit = limitSize ? 10 : 0;
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, userRoot, SearchScope.ONELEVEL, filterbuf.toString(), defaultAtrs, false, maxLimit);){
                long sequence = 0L;
                while (searchResults.next()) {
                    userList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, ou.getContextId()));
                }
            }
            catch (IOException e) {
                String warning = "findUsers caught IOException=" + e.getMessage();
                throw new FinderException(1000, warning, e);
            }
            catch (CursorException e) {
                String warning = "findUsers caught CursorException=" + e.getMessage();
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String warning = "findUsers caught LDAPException=" + e;
                throw new FinderException(1000, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userList;
    }

    boolean changePassword(User entity, String newPassword) throws SecurityException {
        boolean rc = true;
        LdapConnection ld = null;
        String userDn = this.getDn(entity.getUserId(), entity.getContextId());
        try {
            ld = this.getUserConnection();
            this.bind(ld, userDn, entity.getPassword());
            ArrayList<Object> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{newPassword}));
            this.modify(ld, userDn, mods);
            if (entity.getAdminSession() != null && Config.getInstance().isOpenldap() && Config.getInstance().isAuditEnabled()) {
                mods = new ArrayList();
                this.modify(ld, userDn, mods, (FortEntity)entity);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            String warning = User.class.getName() + ".changePassword user [" + entity.getUserId() + "] ";
            warning = warning + " constraint violation, ldap rc=" + e + " Fortress rc=4024";
            throw new PasswordException(4024, warning);
        }
        catch (LdapNoPermissionException e) {
            String warning = User.class.getName() + ".changePassword user [" + entity.getUserId() + "] ";
            warning = warning + " user not authorized to change password, ldap rc=" + e + " Fortress rc=1018";
            throw new UpdateException(1018, warning);
        }
        catch (LdapException e) {
            String warning = User.class.getName() + ".changePassword user [" + entity.getUserId() + "] ";
            warning = warning + " caught LDAPException rc=" + e;
            throw new UpdateException(1026, warning, (Exception)((Object)e));
        }
        finally {
            this.closeUserConnection(ld);
        }
        if (Config.getInstance().isApacheds()) {
            this.deleteResetFlag(entity);
        }
        return rc;
    }

    void resetUserPassword(User user) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{user.getPassword()}));
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, OPENLDAP_PW_RESET, new String[]{"TRUE"}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)user);
        }
        catch (LdapException e) {
            try {
                String warning = "resetUserPassword userId [" + user.getUserId() + "] caught LDAPException=" + e.getMessage();
                throw new UpdateException(1027, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    /*
     * Loose catch block
     */
    private void deleteResetFlag(User user) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, OPENLDAP_PW_RESET));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)user);
            this.closeAdminConnection(ld);
        }
        catch (LdapNoSuchAttributeException e) {
            LOG.info("deleteResetFlag user [" + user.getUserId() + "] no such attribute:pwdReset");
        }
        catch (LdapException e2) {
            String warning = "deleteResetFlag userId [" + user.getUserId() + "] caught LDAPException=" + e2.getMessage();
            throw new UpdateException(1027, warning, (Exception)((Object)e2));
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String assign(UserRole uRole) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            String szUserRole = uRole.getRawData();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftRC", new String[]{szUserRole}));
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, USER_ROLE_ASSIGN, new String[]{uRole.getName()}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)uRole);
        }
        catch (LdapAttributeInUseException e) {
            try {
                String warning = "assign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] ";
                warning = warning + "assignment already exists.";
                throw new FinderException(2008, warning);
                catch (LdapException e2) {
                    warning = "assign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] ";
                    warning = warning + "caught LDAPException=" + e2;
                    throw new UpdateException(2004, warning, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userDn;
    }

    void assign(UserRole uRole, RoleConstraint roleConstraint) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String szRoleConstraint = "";
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            roleConstraint.genId();
            ArrayList<Modification> mods = new ArrayList<Modification>();
            szRoleConstraint = roleConstraint.getRawData(uRole);
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftRC", new String[]{szRoleConstraint}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)uRole);
        }
        catch (LdapException e) {
            try {
                String warning = "assign userId [" + uRole.getUserId() + "] role constraint [" + szRoleConstraint + "] ";
                warning = warning + "caught LDAPException=" + e;
                throw new UpdateException(2004, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    void deassign(UserRole uRole, RoleConstraint roleConstraint) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String szRoleConstraint = "";
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            szRoleConstraint = roleConstraint.getRawData(uRole);
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftRC", new String[]{szRoleConstraint}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)uRole);
        }
        catch (LdapException e) {
            try {
                String warning = "deassign userId [" + uRole.getUserId() + "] role constraint [" + szRoleConstraint + "] dn [" + userDn + "] ";
                warning = warning + "caught LDAPException=" + e;
                throw new UpdateException(2004, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    String deassign(UserRole uRole) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            List<UserRole> roles = this.getUserRoles(uRole.getUserId(), uRole.getContextId());
            int indx = -1;
            if (roles != null && (indx = roles.indexOf(uRole)) > -1) {
                UserRole fRole = roles.get(indx);
                fRole.setContextId(uRole.getContextId());
                ArrayList<Modification> mods = new ArrayList<Modification>();
                for (RoleConstraint rc : fRole.getRoleConstraints()) {
                    this.deassign(fRole, rc);
                }
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftRC", new String[]{fRole.getRawData()}));
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, USER_ROLE_ASSIGN, new String[]{fRole.getName()}));
                ld = this.getAdminConnection();
                this.modify(ld, userDn, mods, (FortEntity)uRole);
            }
            if (indx == -1) {
                String warning = "deassign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] assignment does not exist.";
                throw new FinderException(2009, warning);
            }
        }
        catch (LdapException e) {
            String warning = "deassign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] caught LDAPException=" + e;
            throw new UpdateException(2005, warning, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return userDn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String assign(UserAdminRole uRole) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            String szUserRole = uRole.getRawData();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftARC", new String[]{szUserRole}));
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftARA", new String[]{uRole.getName()}));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)uRole);
        }
        catch (LdapAttributeInUseException e) {
            try {
                String warning = "assign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] assignment already exists.";
                throw new FinderException(9021, warning);
                catch (LdapException e2) {
                    warning = "assign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] caught LDAPException=" + e2;
                    throw new UpdateException(9024, warning, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userDn;
    }

    String deassign(UserAdminRole uRole) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String userDn = this.getDn(uRole.getUserId(), uRole.getContextId());
        try {
            User user = new User(uRole.getUserId());
            user.setContextId(uRole.getContextId());
            List<UserAdminRole> roles = this.getUserAdminRoles(user);
            int indx = -1;
            if (roles != null && (indx = roles.indexOf(uRole)) > -1) {
                UserRole fRole = roles.get(indx);
                ArrayList<Modification> mods = new ArrayList<Modification>();
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftARC", new String[]{fRole.getRawData()}));
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftARA", new String[]{fRole.getName()}));
                ld = this.getAdminConnection();
                this.modify(ld, userDn, mods, (FortEntity)uRole);
            }
            if (indx == -1) {
                String warning = "deassign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] assignment does not exist.";
                throw new FinderException(9023, warning);
            }
        }
        catch (LdapException e) {
            String warning = "deassign userId [" + uRole.getUserId() + "] name [" + uRole.getName() + "] caught LDAPException=" + e;
            throw new UpdateException(9025, warning, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return userDn;
    }

    String deletePwPolicy(User user) throws UpdateException {
        LdapConnection ld = null;
        String userDn = this.getDn(user.getUserId(), user.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, OPENLDAP_POLICY_SUBENTRY));
            ld = this.getAdminConnection();
            this.modify(ld, userDn, mods, (FortEntity)user, true);
        }
        catch (LdapException e) {
            try {
                String warning = "deletePwPolicy userId [" + user.getUserId() + "] caught LDAPException=" + e + " msg=" + e;
                throw new UpdateException(1012, warning, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return userDn;
    }

    private String unloadUser(Entry entry) throws LdapInvalidAttributeValueException {
        String userId = this.getAttribute(entry, "uid");
        return userId;
    }

    private User unloadLdapEntry(Entry entry, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        User entity = new ObjectFactory().createUser();
        entity.setSequenceId(sequence);
        entity.setInternalId(this.getAttribute(entry, "ftId"));
        entity.setDescription(this.getAttribute(entry, "description"));
        entity.setUserId(this.getAttribute(entry, "uid"));
        entity.setCn(this.getAttribute(entry, "cn"));
        entity.setName(entity.getCn());
        entity.setSn(this.getAttribute(entry, "sn"));
        entity.setOu(this.getAttribute(entry, "ou"));
        entity.setDn(entry.getDn().getName());
        entity.setDisplayName(this.getAttribute(entry, "displayName"));
        entity.setTitle(this.getAttribute(entry, "title"));
        entity.setEmployeeType(this.getAttribute(entry, EMPLOYEE_TYPE));
        this.unloadTemporal(entry, entity);
        entity.setRoles(this.unloadUserRoles(entry, entity.getUserId(), contextId, null));
        entity.setAdminRoles(this.unloadUserAdminRoles(entry, entity.getUserId(), contextId));
        entity.setAddress(this.unloadAddress(entry));
        entity.setPhones(this.getAttributes(entry, "telephoneNumber"));
        entity.setMobiles(this.getAttributes(entry, MOBILE));
        entity.setEmails(this.getAttributes(entry, "mail"));
        String szBoolean = this.getAttribute(entry, SYSTEM_USER);
        if (szBoolean != null) {
            entity.setSystem(Boolean.valueOf(szBoolean));
        }
        entity.addProperties(PropUtil.getProperties(this.getAttributes(entry, "ftProps")));
        if (Config.getInstance().isOpenldap() || Config.getInstance().isApacheds()) {
            String szPolicy;
            szBoolean = this.getAttribute(entry, OPENLDAP_PW_RESET);
            if (szBoolean != null && szBoolean.equalsIgnoreCase("true")) {
                entity.setReset(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)(szPolicy = this.getAttribute(entry, OPENLDAP_POLICY_SUBENTRY)))) {
                entity.setPwPolicy(this.getRdn(szPolicy));
            }
            if ((szBoolean = this.getAttribute(entry, OPENLDAP_PW_LOCKED_TIME)) != null && szBoolean.equals(LOCK_VALUE)) {
                entity.setLocked(true);
            }
        }
        entity.setJpegPhoto(this.getPhoto(entry, JPEGPHOTO));
        if (RoleDAO.IS_RFC2307) {
            entity.setUidNumber(this.getAttribute(entry, "uidNumber"));
            entity.setGidNumber(this.getAttribute(entry, "gidNumber"));
            entity.setHomeDirectory(this.getAttribute(entry, HOME_DIRECTORY));
        }
        return entity;
    }

    private List<UserRole> getUserRoles(String userId, String contextId) throws FinderException {
        List<UserRole> roles = null;
        LdapConnection ld = null;
        String userDn = this.getDn(userId, contextId);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, userDn, ROLE_ATR);
            roles = this.unloadUserRoles(findEntry, userId, contextId, null);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getUserRoles COULD NOT FIND ENTRY for user [" + userId + "]";
            throw new FinderException(1005, warning);
        }
        catch (LdapException e) {
            String error = "getUserRoles [" + userDn + "]= caught LDAPException=" + e;
            throw new FinderException(1001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return roles;
    }

    private void loadUserAdminRoles(List<UserAdminRole> list, Entry entry) throws LdapException {
        if (list != null) {
            DefaultAttribute userAdminRoleData = new DefaultAttribute("ftARC");
            DefaultAttribute userAdminRoleAssign = new DefaultAttribute("ftARA");
            for (UserAdminRole userRole : list) {
                userAdminRoleData.add(new String[]{userRole.getRawData()});
                userAdminRoleAssign.add(new String[]{userRole.getName()});
            }
            if (userAdminRoleData.size() != 0) {
                entry.add(new Attribute[]{userAdminRoleData});
                entry.add(new Attribute[]{userAdminRoleAssign});
            }
        }
    }

    private void loadUserRoles(List<UserRole> list, List<Modification> mods) throws LdapInvalidAttributeValueException {
        DefaultAttribute userRoleData = new DefaultAttribute("ftRC");
        DefaultAttribute userRoleAssign = new DefaultAttribute(USER_ROLE_ASSIGN);
        if (list != null) {
            for (UserRole userRole : list) {
                userRoleData.add(new String[]{userRole.getRawData()});
                userRoleAssign.add(new String[]{userRole.getName()});
            }
            if (userRoleData.size() != 0) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)userRoleData));
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)userRoleAssign));
            }
        }
    }

    private void loadUserAdminRoles(List<UserAdminRole> list, List<Modification> mods) throws LdapInvalidAttributeValueException {
        DefaultAttribute userAdminRoleData = new DefaultAttribute("ftARC");
        DefaultAttribute userAdminRoleAssign = new DefaultAttribute("ftARA");
        if (list != null) {
            boolean nameSeen = false;
            for (UserAdminRole userRole : list) {
                userAdminRoleData.add(new String[]{userRole.getRawData()});
                if (nameSeen) continue;
                userAdminRoleAssign.add(new String[]{userRole.getName()});
                nameSeen = true;
            }
            if (userAdminRoleData.size() != 0) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)userAdminRoleData));
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)userAdminRoleAssign));
            }
        }
    }

    private void loadUserRoles(List<UserRole> list, Entry entry) throws LdapException {
        if (list != null) {
            DefaultAttribute userRoleData = new DefaultAttribute("ftRC");
            DefaultAttribute userRoleAssign = new DefaultAttribute(USER_ROLE_ASSIGN);
            for (UserRole userRole : list) {
                userRoleData.add(new String[]{userRole.getRawData()});
                userRoleAssign.add(new String[]{userRole.getName()});
            }
            if (userRoleData.size() != 0) {
                entry.add(new Attribute[]{userRoleData, userRoleAssign});
            }
        }
    }

    private void loadAddress(Address address, Entry entry) throws LdapException {
        if (address != null) {
            if (CollectionUtils.isNotEmpty(address.getAddresses())) {
                for (String val : address.getAddresses()) {
                    entry.add("postalAddress", new String[]{val});
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getCity())) {
                entry.add("l", new String[]{address.getCity()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getPostalCode())) {
                entry.add("postalCode", new String[]{address.getPostalCode()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getPostOfficeBox())) {
                entry.add("postOfficeBox", new String[]{address.getPostOfficeBox()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getState())) {
                entry.add("st", new String[]{address.getState()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getBuilding())) {
                entry.add("physicalDeliveryOfficeName", new String[]{address.getBuilding()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getDepartmentNumber())) {
                entry.add(DEPARTMENT_NUMBER, new String[]{address.getDepartmentNumber()});
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getRoomNumber())) {
                entry.add(ROOM_NUMBER, new String[]{address.getRoomNumber()});
            }
        }
    }

    private void loadAddress(Address address, List<Modification> mods) {
        if (address != null) {
            if (CollectionUtils.isNotEmpty(address.getAddresses())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "postalAddress"));
                for (String val : address.getAddresses()) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "postalAddress", new String[]{val}));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getCity())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "l", new String[]{address.getCity()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getPostalCode())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "postalCode", new String[]{address.getPostalCode()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getPostOfficeBox())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "postOfficeBox", new String[]{address.getPostOfficeBox()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getState())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "st", new String[]{address.getState()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getBuilding())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "physicalDeliveryOfficeName", new String[]{address.getBuilding()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getDepartmentNumber())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, DEPARTMENT_NUMBER, new String[]{address.getDepartmentNumber()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getRoomNumber())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ROOM_NUMBER, new String[]{address.getRoomNumber()}));
            }
        }
    }

    private Address unloadAddress(Entry entry) throws LdapInvalidAttributeValueException {
        Address addr = new ObjectFactory().createAddress();
        List<String> pAddrs = this.getAttributes(entry, "postalAddress");
        if (pAddrs != null) {
            for (String pAddr : pAddrs) {
                addr.setAddress(pAddr);
            }
        }
        addr.setCity(this.getAttribute(entry, "l"));
        addr.setState(this.getAttribute(entry, "st"));
        addr.setPostalCode(this.getAttribute(entry, "postalCode"));
        addr.setPostOfficeBox(this.getAttribute(entry, "postOfficeBox"));
        addr.setBuilding(this.getAttribute(entry, "physicalDeliveryOfficeName"));
        addr.setDepartmentNumber(this.getAttribute(entry, DEPARTMENT_NUMBER));
        addr.setRoomNumber(this.getAttribute(entry, ROOM_NUMBER));
        return addr;
    }

    private List<UserAdminRole> unloadUserAdminRoles(Entry entry, String userId, String contextId) {
        ArrayList<UserAdminRole> uRoles = null;
        List<String> roles = this.getAttributes(entry, "ftARC");
        if (roles != null) {
            long sequence = 0L;
            uRoles = new ArrayList<UserAdminRole>();
            for (String raw : roles) {
                UserAdminRole ure = new ObjectFactory().createUserAdminRole();
                ure.load(raw, contextId, RoleUtil.getInstance());
                ure.setSequenceId(sequence++);
                ure.setUserId(userId);
                uRoles.add(ure);
            }
        }
        return uRoles;
    }

    private void loadPosixIds(User entity) throws CreateException {
        if (StringUtils.isEmpty((CharSequence)entity.getUidNumber()) || StringUtils.isEmpty((CharSequence)entity.getGidNumber())) {
            Configuration configuration;
            ArrayList<String> idNumbers = new ArrayList<String>();
            if (StringUtils.isEmpty((CharSequence)entity.getUidNumber())) {
                idNumbers.add("uidNumber");
            }
            if (StringUtils.isEmpty((CharSequence)entity.getGidNumber())) {
                idNumbers.add("gidNumber");
            }
            try {
                configuration = Config.getInstance().getIncrementReplacePosixIds(idNumbers, this);
            }
            catch (CfgException ce) {
                String error = "create user caught CfgException replacing an ID prop:" + ce.getMessage();
                throw new CreateException(1002, error, ce);
            }
            if (StringUtils.isEmpty((CharSequence)entity.getUidNumber())) {
                entity.setUidNumber(configuration.getUidNumber());
            }
            if (StringUtils.isEmpty((CharSequence)entity.getGidNumber())) {
                entity.setGidNumber(configuration.getGidNumber());
            }
        }
    }

    private String getDn(String userId, String contextId) {
        return "uid=" + userId + "," + UserDAO.getRootDn(contextId, "user.root");
    }

    private List<UserRole> unloadUserRoles(Entry entry, String userId, String contextId, String roleNameFilter) {
        TreeMap<String, UserRole> uRoles = new TreeMap<String, UserRole>(String.CASE_INSENSITIVE_ORDER);
        List<String> roles = this.getAttributes(entry, "ftRC");
        if (roles != null) {
            long sequence = 0L;
            for (String raw : roles) {
                UserRole userRole;
                String roleName = raw.substring(0, raw.indexOf(Config.getInstance().getDelimiter())).toUpperCase();
                if (roleNameFilter != null && !roleNameFilter.toUpperCase().equals(roleName)) continue;
                if (uRoles.containsKey(roleName)) {
                    userRole = (UserRole)uRoles.get(roleName);
                    userRole.load(raw, contextId, RoleUtil.getInstance());
                    continue;
                }
                userRole = new ObjectFactory().createUserRole();
                userRole.load(raw, contextId, RoleUtil.getInstance());
                userRole.setUserId(userId);
                userRole.setSequenceId(sequence++);
                uRoles.put(roleName, userRole);
            }
        }
        return new ArrayList<UserRole>(uRoles.values());
    }

    private String[] getUserObjectClass() {
        String[] stringArray;
        if (RoleDAO.IS_RFC2307) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "top";
            stringArray2[1] = Config.getInstance().getProperty(USER_OBJECT_CLASS);
            stringArray2[2] = USERS_AUX_OBJECT_CLASS_NAME;
            stringArray2[3] = "ftProperties";
            stringArray2[4] = "ftMods";
            stringArray2[5] = USERS_EXTENSIBLE_OBJECT;
            stringArray = stringArray2;
            stringArray2[6] = POSIX_ACCOUNT;
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "top";
            stringArray3[1] = Config.getInstance().getProperty(USER_OBJECT_CLASS);
            stringArray3[2] = USERS_AUX_OBJECT_CLASS_NAME;
            stringArray3[3] = "ftProperties";
            stringArray3[4] = "ftMods";
            stringArray = stringArray3;
            stringArray3[5] = USERS_EXTENSIBLE_OBJECT;
        }
        String[] userObjectClass = stringArray;
        return userObjectClass;
    }

    private void initAttrArrays() {
        if (Config.getInstance().isOpenldap() || Config.getInstance().isApacheds()) {
            defaultAtrs = new String[]{"ftId", "uid", "userPassword", "description", "ou", "cn", "sn", "ftRC", "ftCstr", USER_ROLE_ASSIGN, OPENLDAP_PW_RESET, OPENLDAP_PW_LOCKED_TIME, OPENLDAP_POLICY_SUBENTRY, "ftProps", "ftARA", "ftARC", "postalAddress", "l", "postalCode", "postOfficeBox", "st", "physicalDeliveryOfficeName", DEPARTMENT_NUMBER, ROOM_NUMBER, "telephoneNumber", MOBILE, "mail", EMPLOYEE_TYPE, "title", SYSTEM_USER, JPEGPHOTO, RoleDAO.IS_RFC2307 ? HOME_DIRECTORY : null, RoleDAO.IS_RFC2307 ? "gidNumber" : null, RoleDAO.IS_RFC2307 ? "uidNumber" : null};
            authnAtrs = new String[]{"ftId", "uid", "userPassword", "description", "ou", "cn", "sn", "ftCstr", OPENLDAP_PW_RESET, OPENLDAP_PW_LOCKED_TIME, "ftProps"};
        } else {
            defaultAtrs = new String[]{"ftId", "uid", "userPassword", "description", "ou", "cn", "sn", "ftRC", "ftCstr", USER_ROLE_ASSIGN, "ftProps", "ftARA", "ftARC", "postalAddress", "l", "postalCode", "postOfficeBox", "st", "physicalDeliveryOfficeName", DEPARTMENT_NUMBER, ROOM_NUMBER, "telephoneNumber", MOBILE, "mail", EMPLOYEE_TYPE, "title", SYSTEM_USER, JPEGPHOTO, RoleDAO.IS_RFC2307 ? HOME_DIRECTORY : null, RoleDAO.IS_RFC2307 ? "gidNumber" : null, RoleDAO.IS_RFC2307 ? "uidNumber" : null};
            authnAtrs = new String[]{"ftId", "uid", "userPassword", "description", "ou", "cn", "sn", "ftCstr", "ftProps"};
        }
    }
}

