/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.io.ConnectionIO;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConnectionFolderManager
implements ConnectionUpdateListener {
    private static final String CONNECTION_FOLDERS_FILENAME = "connectionFolders.xml";
    private static final String ROOT_ID = "0";
    private ConnectionFolder root = new ConnectionFolder("");
    private Set<ConnectionFolder> folderList;

    public ConnectionFolderManager() {
        this.root.setId(ROOT_ID);
        this.folderList = new HashSet<ConnectionFolder>();
        this.loadConnectionFolders();
        ConnectionEventRegistry.addConnectionUpdateListener(this, ConnectionCorePlugin.getDefault().getEventRunner());
        this.folderList.add(this.root);
    }

    public static final String getConnectionFolderStoreFileName() {
        String filename = ConnectionCorePlugin.getDefault().getStateLocation().append(CONNECTION_FOLDERS_FILENAME).toOSString();
        return filename;
    }

    public void addConnectionFolder(ConnectionFolder connectionFolder) {
        if (this.getConnectionFolderByName(connectionFolder.getName()) != null) {
            String newConnectionFolderName = Messages.bind((String)Messages.copy_n_of_s, (Object)"", (Object)connectionFolder.getName());
            int i = 2;
            while (this.getConnectionFolderByName(newConnectionFolderName) != null) {
                newConnectionFolderName = Messages.bind((String)Messages.copy_n_of_s, (Object)(String.valueOf(i) + " "), (Object)connectionFolder.getName());
                ++i;
            }
            connectionFolder.setName(newConnectionFolderName);
        }
        this.folderList.add(connectionFolder);
        ConnectionEventRegistry.fireConnectonFolderAdded(connectionFolder, this);
    }

    public void removeConnectionFolder(ConnectionFolder connectionFolder) {
        this.folderList.remove(connectionFolder);
        ConnectionEventRegistry.fireConnectonFolderRemoved(connectionFolder, this);
    }

    public ConnectionFolder[] getConnectionFolders() {
        return this.folderList.toArray(new ConnectionFolder[0]);
    }

    public ConnectionFolder getConnectionFolderById(String id) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getId().equals(id)) continue;
            return folder;
        }
        return null;
    }

    public ConnectionFolder getConnectionFolderByName(String name) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public ConnectionFolder getParentConnectionFolder(Connection connection) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getConnectionIds().contains(connection.getId())) continue;
            return folder;
        }
        return this.getRootConnectionFolder();
    }

    public ConnectionFolder getParentConnectionFolder(ConnectionFolder connectionFolder) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getSubFolderIds().contains(connectionFolder.getId())) continue;
            return folder;
        }
        return null;
    }

    public Set<ConnectionFolder> getAllSubFolders(ConnectionFolder folder) {
        HashSet<ConnectionFolder> allSubFolders = new HashSet<ConnectionFolder>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(folder.getId());
        while (!ids.isEmpty()) {
            String id = (String)ids.remove(0);
            ConnectionFolder subFolder = this.getConnectionFolderById(id);
            allSubFolders.add(subFolder);
            ids.addAll(subFolder.getSubFolderIds());
        }
        return allSubFolders;
    }

    public Set<ConnectionFolder> getAllParentFolders(ConnectionFolder folder) {
        HashSet<ConnectionFolder> allParentFolders = new HashSet<ConnectionFolder>();
        do {
            allParentFolders.add(folder);
        } while ((folder = this.getParentConnectionFolder(folder)) != null);
        return allParentFolders;
    }

    public ConnectionFolder getRootConnectionFolder() {
        return this.root;
    }

    public void setRootConnectionFolder(ConnectionFolder root) {
        this.root = root;
    }

    @Override
    public void connectionAdded(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionUpdated(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionOpened(Connection connection) {
    }

    @Override
    public void connectionClosed(Connection connection) {
    }

    @Override
    public void connectionFolderModified(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    private synchronized void saveConnectionFolders() {
        File file = new File(ConnectionFolderManager.getConnectionFolderStoreFileName());
        File tempFile = new File(String.valueOf(ConnectionFolderManager.getConnectionFolderStoreFileName()) + "-temp");
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                ConnectionIO.saveConnectionFolders(this.folderList, fileOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, String.valueOf(Messages.error__saving_connections) + e.getMessage(), (Throwable)e);
            ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            String content = FileUtils.readFileToString((File)tempFile, (String)"UTF-8");
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, String.valueOf(Messages.error__saving_connections) + e.getMessage(), (Throwable)e);
            ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
    }

    private synchronized void loadConnectionFolders() {
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
        File file = new File(ConnectionFolderManager.getConnectionFolderStoreFileName());
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    this.folderList = ConnectionIO.loadConnectionFolders(fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, String.valueOf(Messages.error__loading_connections) + e.getMessage(), (Throwable)e);
                ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        if (!this.folderList.isEmpty()) {
            for (ConnectionFolder folder : this.folderList) {
                if (!ROOT_ID.equals(folder.getId())) continue;
                this.root = folder;
            }
        } else {
            Connection[] connections;
            Connection[] connectionArray = connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                Connection connection = connectionArray[n2];
                this.root.addConnectionId(connection.getId());
                ++n2;
            }
        }
        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
    }
}

