/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeTypeDialog
extends Dialog {
    private Schema schema;
    private String initialValue;
    private Combo attributeTypeCombo;
    private String returnValue;

    public AttributeTypeDialog(Shell parentShell, Schema schema, String initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialValue = initialValue;
        this.schema = schema;
        this.returnValue = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("AttributeTypeDialog.title"));
        shell.setImage(Activator.getDefault().getImage(Messages.getString("AttributeTypeDialog.icon")));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        this.returnValue = this.attributeTypeCombo.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        Collection names = SchemaUtils.getNames((Collection)this.schema.getAttributeTypeDescriptions());
        Object[] allAtNames = names.toArray(new String[names.size()]);
        Arrays.sort(allAtNames);
        this.attributeTypeCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])allAtNames, (int)-1, (int)1);
        this.attributeTypeCombo.setText(this.initialValue);
        new ExtendedContentAssistCommandAdapter((Control)this.attributeTypeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.attributeTypeCombo.getItems()), null, null, true);
        AttributeTypeDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getAttributeType() {
        return this.returnValue;
    }
}

