/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.password.PasswordDetails;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldifparser.LdifUtils;

public class Password {
    private final byte[] password;
    private final PasswordDetails passwordDetails;

    public Password(byte[] password) {
        if (password == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
        }
        this.password = password;
        this.passwordDetails = PasswordUtil.splitCredentials((byte[])password);
    }

    public Password(String password) {
        if (password == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
        }
        this.password = Strings.getBytesUtf8((String)password);
        this.passwordDetails = PasswordUtil.splitCredentials((byte[])this.password);
    }

    public Password(LdapSecurityConstants hashMethod, String passwordAsPlaintext) {
        if (passwordAsPlaintext == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
        }
        this.password = PasswordUtil.createStoragePassword((String)passwordAsPlaintext, (LdapSecurityConstants)hashMethod);
        this.passwordDetails = PasswordUtil.splitCredentials((byte[])this.password);
    }

    public boolean verify(String testPasswordAsPlaintext) {
        if (testPasswordAsPlaintext == null) {
            return false;
        }
        return PasswordUtil.compareCredentials((byte[])Strings.getBytesUtf8((String)testPasswordAsPlaintext), (byte[])this.password);
    }

    public LdapSecurityConstants getHashMethod() {
        return this.passwordDetails.getAlgorithm();
    }

    public byte[] getHashedPassword() {
        return this.passwordDetails.getPassword();
    }

    public String getHashedPasswordAsHexString() {
        return LdifUtils.hexEncode((byte[])this.passwordDetails.getPassword());
    }

    public byte[] getSalt() {
        return this.passwordDetails.getSalt();
    }

    public String getSaltAsHexString() {
        return LdifUtils.hexEncode((byte[])this.passwordDetails.getSalt());
    }

    public byte[] toBytes() {
        return LdifUtils.utf8encode((String)this.toString());
    }

    public String toString() {
        return Strings.utf8ToString((byte[])this.password);
    }
}

