/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;

public class SchemaObjectLoader {
    private IBrowserConnection browserConnection;
    private String[] attributeNamesAndOids;
    private String[] objectClassesAndOids;

    public String[] getObjectClassNamesAndOids() {
        this.objectClassesAndOids = this.getSchemaObjectsAnddOids(this.objectClassesAndOids, new SchemaAdder(){

            @Override
            public void add(Schema schema, List<String> objectClassNamesList, List<String> oidsList) {
                if (schema != null) {
                    for (ObjectClass ocd : schema.getObjectClassDescriptions()) {
                        if (!oidsList.contains(ocd.getOid())) {
                            oidsList.add(ocd.getOid());
                        }
                        for (String name : ocd.getNames()) {
                            if (objectClassNamesList.contains(name)) continue;
                            objectClassNamesList.add(name);
                        }
                    }
                }
            }
        });
        return this.objectClassesAndOids;
    }

    public String[] getAttributeNamesAndOids() {
        this.attributeNamesAndOids = this.getSchemaObjectsAnddOids(this.attributeNamesAndOids, new SchemaAdder(){

            @Override
            public void add(Schema schema, List<String> attributeNamesList, List<String> oidsList) {
                if (schema != null) {
                    for (AttributeType atd : schema.getAttributeTypeDescriptions()) {
                        if (!oidsList.contains(atd.getOid())) {
                            oidsList.add(atd.getOid());
                        }
                        for (String name : atd.getNames()) {
                            if (attributeNamesList.contains(name)) continue;
                            attributeNamesList.add(name);
                        }
                    }
                }
            }
        });
        return this.attributeNamesAndOids;
    }

    private String[] getSchemaObjectsAnddOids(String[] schemaObjects, SchemaAdder schemaAdder) {
        if (schemaObjects == null || schemaObjects.length == 0) {
            ArrayList<String> schemaObjectNamesList = new ArrayList<String>();
            ArrayList<String> oidsList = new ArrayList<String>();
            if (this.browserConnection == null) {
                IBrowserConnection[] connections;
                IBrowserConnection[] iBrowserConnectionArray = connections = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnections();
                int n = connections.length;
                int n2 = 0;
                while (n2 < n) {
                    IBrowserConnection connection = iBrowserConnectionArray[n2];
                    schemaAdder.add(connection.getSchema(), schemaObjectNamesList, oidsList);
                    ++n2;
                }
            } else {
                schemaAdder.add(this.browserConnection.getSchema(), schemaObjectNamesList, oidsList);
            }
            schemaAdder.add(Schema.DEFAULT_SCHEMA, schemaObjectNamesList, oidsList);
            Collections.sort(schemaObjectNamesList);
            Collections.sort(oidsList);
            schemaObjects = new String[schemaObjectNamesList.size() + oidsList.size()];
            System.arraycopy(schemaObjectNamesList.toArray(), 0, schemaObjects, 0, schemaObjectNamesList.size());
            System.arraycopy(oidsList.toArray(), 0, schemaObjects, schemaObjectNamesList.size(), oidsList.size());
        }
        return schemaObjects;
    }

    private static interface SchemaAdder {
        public void add(Schema var1, List<String> var2, List<String> var3);
    }
}

