/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.preferences;

import org.apache.directory.studio.Activator;
import org.apache.directory.studio.Messages;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ShutdownPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button confirmExitClosingLastWindowCheckbox;

    public ShutdownPreferencesPage() {
        super(Messages.getString("ShutdownPreferencesPage.PageTitle"));
        super.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.confirmExitClosingLastWindowCheckbox = new Button(composite, 32);
        this.confirmExitClosingLastWindowCheckbox.setText(Messages.getString("ShutdownPreferencesPage.ConfirmExitClosingLastWindow"));
        this.refreshUI();
        return composite;
    }

    private void refreshUI() {
        this.confirmExitClosingLastWindowCheckbox.setSelection(this.getPreferenceStore().getBoolean("exitPromptOnCloseLastWindow"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("exitPromptOnCloseLastWindow", this.confirmExitClosingLastWindowCheckbox.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.getPreferenceStore().setValue("exitPromptOnCloseLastWindow", this.getPreferenceStore().getDefaultBoolean("exitPromptOnCloseLastWindow"));
        super.performDefaults();
    }

    public static boolean promptOnExit() {
        if (PlatformUI.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("exitPromptOnCloseLastWindow");
        if (promptOnExit) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ShutdownPreferencesPage.PromptOnExitTitle"), (String)Messages.getString("ShutdownPreferencesPage.PromptOnExitMessage"), (String)Messages.getString("ShutdownPreferencesPage.PromptOnExitToggleMessage"), (boolean)false, null, null);
            if (dialog.getReturnCode() != 0) {
                return false;
            }
            if (dialog.getToggleState()) {
                store.setValue("exitPromptOnCloseLastWindow", false);
                Activator.getDefault().savePluginPreferences();
            }
        }
        return true;
    }
}

