/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.osgi.framework.Bundle;

final class ServletRequestMultipartWrapper
extends ServletRequestWrapper {
    private static final String POST_METHOD = "POST";
    private final MultipartConfig multipartConfig;
    private Collection<PartImpl> parts;
    private Map<String, String[]> partsParameterMap;
    private Bundle bundleForSecurityCheck;

    public ServletRequestMultipartWrapper(HttpServletRequest req, ExtServletContext servletContext, RequestInfo requestInfo, DispatcherType type, boolean asyncSupported, MultipartConfig multipartConfig, Bundle bundleForSecurityCheck) {
        super(req, servletContext, requestInfo, type, asyncSupported);
        this.multipartConfig = multipartConfig;
        this.bundleForSecurityCheck = bundleForSecurityCheck;
    }

    private RequestContext getMultipartContext() {
        RequestContext multipartContext = !POST_METHOD.equalsIgnoreCase(this.getMethod()) ? null : new RequestContext(){

            @Override
            public InputStream getInputStream() throws IOException {
                return ServletRequestMultipartWrapper.this.getInputStream();
            }

            @Override
            public String getContentType() {
                return ServletRequestMultipartWrapper.this.getContentType();
            }

            @Override
            public int getContentLength() {
                return ServletRequestMultipartWrapper.this.getContentLength();
            }

            @Override
            public String getCharacterEncoding() {
                return ServletRequestMultipartWrapper.this.getCharacterEncoding();
            }
        };
        return multipartContext;
    }

    private Collection<PartImpl> checkMultipart() throws IOException, ServletException {
        if (this.parts == null) {
            final RequestContext multipartContext = this.getMultipartContext();
            if (multipartContext != null && FileUploadBase.isMultipartContent(multipartContext)) {
                if (this.multipartConfig == null) {
                    throw new IllegalStateException("Multipart not enabled for servlet.");
                }
                if (System.getSecurityManager() == null) {
                    this.handleMultipart(multipartContext);
                } else {
                    AccessControlContext ctx = (AccessControlContext)this.bundleForSecurityCheck.adapt(AccessControlContext.class);
                    IOException ioe = AccessController.doPrivileged(new PrivilegedAction<IOException>(){

                        @Override
                        public IOException run() {
                            try {
                                ServletRequestMultipartWrapper.this.handleMultipart(multipartContext);
                            }
                            catch (IOException ioe) {
                                return ioe;
                            }
                            return null;
                        }
                    }, ctx);
                    if (ioe != null) {
                        throw ioe;
                    }
                }
            } else {
                throw new ServletException("Not a multipart request");
            }
        }
        return this.parts;
    }

    private void handleMultipart(RequestContext multipartContext) throws IOException {
        FileUpload upload = new FileUpload();
        upload.setSizeMax(this.multipartConfig.multipartMaxRequestSize);
        upload.setFileSizeMax(this.multipartConfig.multipartMaxFileSize);
        upload.setFileItemFactory(new DiskFileItemFactory(this.multipartConfig.multipartThreshold, new File(this.multipartConfig.multipartLocation)));
        upload.setFileCountMax(this.multipartConfig.multipartMaxFileCount);
        List<FileItem> items = null;
        try {
            items = upload.parseRequest(multipartContext);
        }
        catch (FileUploadException fue) {
            throw new IOException("Error parsing multipart request", fue);
        }
        this.parts = new ArrayList<PartImpl>();
        for (FileItem item : items) {
            this.parts.add(new PartImpl(item));
        }
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return this.checkMultipart();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        Collection<PartImpl> parts = this.checkMultipart();
        for (Part part : parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    private Map<String, String[]> getPartsParameterMap() {
        if (this.partsParameterMap == null) {
            try {
                Collection<PartImpl> parts = this.checkMultipart();
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                for (PartImpl p : parts) {
                    if (!p.getFileItem().isFormField()) continue;
                    String[] current = (String[])params.get(p.getName());
                    if (current == null) {
                        current = new String[]{p.getFileItem().getString()};
                    } else {
                        String[] newCurrent = new String[current.length + 1];
                        System.arraycopy(current, 0, newCurrent, 0, current.length);
                        newCurrent[current.length] = p.getFileItem().getString();
                        current = newCurrent;
                    }
                    params.put(p.getName(), current);
                }
                this.partsParameterMap = params;
            }
            catch (ServletException | IOException throwable) {
                // empty catch block
            }
            if (this.partsParameterMap == null) {
                this.partsParameterMap = super.getParameterMap();
            }
        }
        return this.partsParameterMap;
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        RequestContext multipartContext = this.getMultipartContext();
        if (multipartContext != null && FileUploadBase.isMultipartContent(multipartContext) && this.multipartConfig != null) {
            return this.getPartsParameterMap();
        }
        return super.getParameterMap();
    }

    @Override
    public Enumeration<String> getParameterNames() {
        Map<String, String[]> params = this.getParameterMap();
        return Collections.enumeration(params.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        Map<String, String[]> params = this.getParameterMap();
        return params.get(name);
    }

    private static final class PartImpl
    implements Part {
        private final FileItem item;

        public PartImpl(FileItem item) {
            this.item = item;
        }

        public InputStream getInputStream() throws IOException {
            return this.item.getInputStream();
        }

        public String getContentType() {
            return this.item.getContentType();
        }

        public String getName() {
            return this.item.getFieldName();
        }

        public String getSubmittedFileName() {
            return this.item.getName();
        }

        public long getSize() {
            return this.item.getSize();
        }

        public void write(String fileName) throws IOException {
            try {
                this.item.write(new File(fileName));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void delete() throws IOException {
            this.item.delete();
        }

        public String getHeader(String name) {
            return this.item.getHeaders().getHeader(name);
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator<String> iter = this.item.getHeaders().getHeaders(name);
            while (iter.hasNext()) {
                values.add(iter.next());
            }
            return values;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> names = new ArrayList<String>();
            Iterator<String> iter = this.item.getHeaders().getHeaderNames();
            while (iter.hasNext()) {
                names.add(iter.next());
            }
            return names;
        }

        public FileItem getFileItem() {
            return this.item;
        }
    }
}

