/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.tracker;

import javax.servlet.Servlet;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.tracker.AbstractTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ServletTracker
extends AbstractTracker<Servlet> {
    private final ExtenderManager manager;

    private static Filter createFilter(BundleContext btx) {
        try {
            return btx.createFilter(String.format("(&(objectClass=%s)(%s=*))", Servlet.class.getName(), "alias"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public ServletTracker(BundleContext context, ExtenderManager manager) {
        super(context, ServletTracker.createFilter(context));
        this.manager = manager;
    }

    @Override
    protected void added(Servlet service, ServiceReference<Servlet> ref) {
        this.logDeprecationWarning("Servlet", service, ref);
        this.manager.addServlet(service, ref);
    }

    @Override
    protected void removed(Servlet service, ServiceReference<Servlet> ref) {
        this.manager.removeServlet(ref);
    }
}

