/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.manipulator.store.ManifestBuilder;
import org.apache.felix.ipojo.manipulator.store.ResourceMapper;
import org.apache.felix.ipojo.manipulator.store.mapper.IdentityResourceMapper;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.util.Streams;
import org.apache.felix.ipojo.metadata.Element;

public class JarFileResourceStore
implements ResourceStore {
    private JarFile m_source;
    private File m_target;
    private Map<String, byte[]> m_content;
    private ResourceMapper m_mapper = new IdentityResourceMapper();
    private ManifestBuilder m_manifestBuilder;
    private Manifest m_manifest;
    private ClassLoader classLoader;

    public JarFileResourceStore(JarFile source, File target) throws IOException {
        this.m_source = source;
        this.m_target = target;
        this.m_target = target;
        this.m_manifest = source != null ? source.getManifest() : new Manifest();
        this.m_content = new TreeMap<String, byte[]>();
    }

    public void setResourceMapper(ResourceMapper mapper) {
        this.m_mapper = mapper;
    }

    public void setManifestBuilder(ManifestBuilder manifestBuilder) {
        this.m_manifestBuilder = manifestBuilder;
    }

    public void setManifest(Manifest manifest) {
        this.m_manifest = manifest;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public byte[] read(String path) throws IOException {
        ZipEntry entry = this.m_source.getEntry(this.getInternalPath(path));
        if (entry == null) {
            return this.tryToLoadFromClassloader(path);
        }
        return Streams.readBytes(this.m_source.getInputStream(entry));
    }

    private byte[] tryToLoadFromClassloader(String path) throws IOException {
        byte[] bytes;
        if (this.classLoader != null && (bytes = JarFileResourceStore.toByteArray(this.classLoader.getResource(path))) != null) {
            return bytes;
        }
        throw new IOException("Class not found " + path + ".");
    }

    public static byte[] toByteArray(URL url) throws IOException {
        byte[] byArray;
        if (url == null) {
            return null;
        }
        InputStream input = url.openStream();
        try {
            byArray = Streams.readBytes(input);
        }
        catch (Throwable throwable) {
            Streams.close(input);
            throw throwable;
        }
        Streams.close(input);
        return byArray;
    }

    private String getInternalPath(String path) {
        return this.m_mapper.internalize(path);
    }

    @Override
    public void accept(ResourceVisitor visitor) {
        ArrayList<JarEntry> entries = Collections.list(this.m_source.entries());
        for (JarEntry entry : entries) {
            String name = entry.getName();
            if (name.endsWith("/")) continue;
            visitor.visit(this.getExternalName(entry.getName()));
        }
    }

    private String getExternalName(String path) {
        return this.m_mapper.externalize(path);
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void writeMetadata(Element metadata) {
        this.m_manifestBuilder.addMetada(Collections.singletonList(metadata));
        this.m_manifestBuilder.addReferredPackage(Metadatas.findReferredPackages(metadata));
    }

    @Override
    public void write(String resourcePath, byte[] resource) throws IOException {
        this.m_content.put(this.getInternalPath(resourcePath), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Manifest updated = this.m_manifestBuilder.build(this.m_manifest);
        FileOutputStream fos = new FileOutputStream(this.m_target);
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, updated);
        try {
            ArrayList<JarEntry> entries = Collections.list(this.m_source.entries());
            for (JarEntry entry : entries) {
                if (this.isIgnored(entry)) continue;
                if (this.isUpdated(entry)) {
                    JarEntry je = new JarEntry(entry.getName());
                    byte[] data = this.m_content.get(this.getInternalPath(entry.getName()));
                    jos.putNextEntry(je);
                    jos.write(data);
                    jos.closeEntry();
                    continue;
                }
                jos.putNextEntry(entry);
                InputStream is = this.m_source.getInputStream(entry);
                try {
                    Streams.transfer(is, jos);
                }
                catch (Throwable throwable) {
                    Streams.close(is);
                    throw throwable;
                }
                Streams.close(is);
                jos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            try {
                this.m_source.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Streams.close(jos, fos);
            throw throwable;
        }
        try {
            this.m_source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Streams.close(jos, fos);
    }

    private boolean isUpdated(JarEntry entry) {
        if (entry.getName().endsWith(".class")) {
            String cleaned = this.getExternalName(entry.getName());
            return this.m_content.containsKey(cleaned);
        }
        return false;
    }

    private boolean isIgnored(JarEntry entry) {
        return "META-INF/MANIFEST.MF".equals(entry.getName());
    }
}

