/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class Properties
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testProperties() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Properties");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        Element[] props = prov.getElements("property");
        Properties.assertEquals((String)"Number of properties", (int)props.length, (int)5);
        Element foo = this.getPropertyByName(props, "foo");
        Properties.assertEquals((String)"Check foo field", (String)"m_foo", (String)foo.getAttribute("field"));
        Properties.assertEquals((String)"Check foo name", (String)"foo", (String)foo.getAttribute("name"));
        Element bar = this.getPropertyByName(props, "bar");
        Properties.assertEquals((String)"Check bar field", (String)"bar", (String)bar.getAttribute("field"));
        Properties.assertEquals((String)"Check bar value", (String)"4", (String)bar.getAttribute("value"));
        Element boo = this.getPropertyByName(props, "boo");
        Properties.assertEquals((String)"Check boo field", (String)"boo", (String)boo.getAttribute("field"));
        Properties.assertEquals((String)"Check boo method", (String)"setboo", (String)boo.getAttribute("method"));
        Element baa = this.getPropertyByName(props, "baa");
        Properties.assertEquals((String)"Check baa field", (String)"m_baa", (String)baa.getAttribute("field"));
        Properties.assertEquals((String)"Check baa name", (String)"baa", (String)baa.getAttribute("name"));
        Properties.assertEquals((String)"Check baa method", (String)"setbaa", (String)baa.getAttribute("method"));
        Properties.assertEquals((String)"Check mandatory", (String)"true", (String)baa.getAttribute("mandatory"));
        Element baz = this.getPropertyByName(props, "baz");
        Properties.assertEquals((String)"Check baz method", (String)"setbaz", (String)baz.getAttribute("method"));
        Properties.assertEquals((String)"Check baz name", (String)"baz", (String)baz.getAttribute("name"));
    }

    public void testAbsentPropagation() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Properties");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("propagation");
        Properties.assertNull((String)"Propagation", (Object)att);
    }

    public void testPropagation() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Propagation");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("propagation");
        Properties.assertNotNull((String)"Propagation", (Object)att);
        Properties.assertEquals((String)"Propagation value", (String)"true", (String)att);
    }

    public void testNoPropagation() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.NoPropagation");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("propagation");
        Properties.assertNotNull((String)"Propagation", (Object)att);
        Properties.assertEquals((String)"Propagation value", (String)"false", (String)att);
    }

    public void testPID() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ManagedServicePID");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNotNull((String)"PID", (Object)att);
        Properties.assertEquals((String)"PID Value", (String)"MyPID", (String)att);
    }

    public void testAbsentPID() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Properties");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNull((String)"PID", (Object)att);
    }

    public void testPropagationAndPID() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.PropagationandPID");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNotNull((String)"PID", (Object)att);
        Properties.assertEquals((String)"PID Value", (String)"MyPID", (String)att);
        att = prov.getAttribute("propagation");
        Properties.assertNotNull((String)"Propagation", (Object)att);
        Properties.assertEquals((String)"Propagation value", (String)"true", (String)att);
    }

    public void testPIDAndPropagation() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.PIDandPropagation");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNotNull((String)"PID", (Object)att);
        Properties.assertEquals((String)"PID Value", (String)"MyPID", (String)att);
        att = prov.getAttribute("propagation");
        Properties.assertNotNull((String)"Propagation", (Object)att);
        Properties.assertEquals((String)"Propagation value", (String)"true", (String)att);
    }

    public void testUpdatedAndPID() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.UpdatedWithManagedService");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNotNull((String)"PID", (Object)att);
        Properties.assertEquals((String)"PID Value", (String)"MyPID", (String)att);
        att = prov.getAttribute("updated");
        Properties.assertNotNull((String)"att", (Object)att);
        Properties.assertEquals((String)"Updated Value", (String)"after", (String)att);
    }

    public void testUpdatedAndProperties() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.UpdatedWithProperties");
        Element[] provs = meta.getElements("properties");
        Properties.assertNotNull((String)"Properties exists ", (Object)provs);
        Element prov = provs[0];
        String att = prov.getAttribute("pid");
        Properties.assertNull((String)"PID", (Object)att);
        att = prov.getAttribute("updated");
        Properties.assertNotNull((String)"att", (Object)att);
        Properties.assertEquals((String)"Updated Value", (String)"after", (String)att);
    }

    private Element getPropertyByName(Element[] props, String name) {
        int i = 0;
        while (i < props.length) {
            String na = props[i].getAttribute("name");
            String field = props[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return props[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return props[i];
            }
            ++i;
        }
        Properties.fail((String)("Property  " + name + " not found"));
        return null;
    }
}

