/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class HTTPUSocket {
    private DatagramSocket ssdpUniSock = null;
    private String localAddr = "";

    public DatagramSocket getDatagramSocket() {
        return this.ssdpUniSock;
    }

    public HTTPUSocket() {
        this.open();
    }

    public HTTPUSocket(String bindAddr, int bindPort) {
        this.open(bindAddr, bindPort);
    }

    public HTTPUSocket(int bindPort) {
        this.open(bindPort);
    }

    protected void finalize() {
        this.close();
    }

    public void setLocalAddress(String addr) {
        this.localAddr = addr;
    }

    public DatagramSocket getUDPSocket() {
        return this.ssdpUniSock;
    }

    public String getLocalAddress() {
        if (0 < this.localAddr.length()) {
            return this.localAddr;
        }
        return this.ssdpUniSock.getLocalAddress().getHostAddress();
    }

    public boolean open() {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket();
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean open(String bindAddr, int bindPort) {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket(bindPort);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        this.setLocalAddress(bindAddr);
        return true;
    }

    public boolean open(int bindPort) {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket(bindPort);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.ssdpUniSock == null) {
            return true;
        }
        try {
            this.ssdpUniSock.close();
            this.ssdpUniSock = null;
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean post(String addr, int port, String msg) {
        try {
            InetAddress inetAddr = InetAddress.getByName(addr);
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), inetAddr, port);
            this.ssdpUniSock.send(dgmPacket);
        }
        catch (Exception e) {
            Debug.warning("addr = " + this.ssdpUniSock.getLocalAddress().getHostName());
            Debug.warning("port = " + this.ssdpUniSock.getLocalPort());
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public SSDPPacket receive() {
        byte[] ssdvRecvBuf = new byte[SSDP.RECV_MESSAGE_BUFSIZE];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        try {
            this.ssdpUniSock.receive(recvPacket.getDatagramPacket());
            recvPacket.setTimeStamp(System.currentTimeMillis());
        }
        catch (Exception e) {
            Debug.warning(e);
            return null;
        }
        return recvPacket;
    }
}

