/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.endpoints;

import flex.management.BaseControl;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.management.runtime.messaging.endpoints.StreamingEndpointControlMBean;
import flex.messaging.endpoints.BaseStreamingHTTPEndpoint;
import java.util.Date;

public abstract class StreamingEndpointControl
extends EndpointControl
implements StreamingEndpointControlMBean {
    private int pushCount;
    private Date lastPushTimeStamp;
    private long pushStart;

    public StreamingEndpointControl(BaseStreamingHTTPEndpoint endpoint, BaseControl parent) {
        super(endpoint, parent);
    }

    @Override
    protected void onRegistrationComplete() {
        super.onRegistrationComplete();
        String name = this.getObjectName().getCanonicalName();
        String[] generalPollables = new String[]{"LastPushTimestamp", "PushCount", "PushFrequency", "StreamingClientsCount"};
        this.getRegistrar().registerObjects(101, name, generalPollables);
        this.getRegistrar().registerObject(100, name, "MaxStreamingClients");
    }

    @Override
    public Integer getMaxStreamingClients() {
        int maxStreamingClientsCount = ((BaseStreamingHTTPEndpoint)this.endpoint).getMaxStreamingClients();
        return new Integer(maxStreamingClientsCount);
    }

    @Override
    public Integer getPushCount() {
        return new Integer(this.pushCount);
    }

    @Override
    public void resetPushCount() {
        this.pushStart = System.currentTimeMillis();
        this.pushCount = 0;
        this.lastPushTimeStamp = null;
    }

    public void incrementPushCount() {
        ++this.pushCount;
        this.lastPushTimeStamp = new Date();
    }

    @Override
    public Date getLastPushTimestamp() {
        return this.lastPushTimeStamp;
    }

    @Override
    public Double getPushFrequency() {
        if (this.pushCount > 0) {
            double runtime = this.differenceInMinutes(this.pushStart, System.currentTimeMillis());
            return new Double((double)this.pushCount / runtime);
        }
        return new Double(0.0);
    }

    @Override
    public Integer getStreamingClientsCount() {
        int streamingClientsCount = ((BaseStreamingHTTPEndpoint)this.endpoint).getStreamingClientsCount();
        return new Integer(streamingClientsCount);
    }
}

