/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.sink;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.Configurable;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.serialization.Serializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TemporaryClassLoaderContext;

class KafkaSerializerWrapper<IN>
implements SerializationSchema<IN> {
    private final Class<? extends Serializer<? super IN>> serializerClass;
    private final boolean isKey;
    private final Map<String, String> config;
    private final Function<? super IN, String> topicSelector;
    private transient Serializer<? super IN> serializer;

    KafkaSerializerWrapper(Class<? extends Serializer<? super IN>> serializerClass, boolean isKey, Map<String, String> config, Function<? super IN, String> topicSelector) {
        this.serializerClass = (Class)Preconditions.checkNotNull(serializerClass);
        this.isKey = isKey;
        this.config = (Map)Preconditions.checkNotNull(config);
        this.topicSelector = (Function)Preconditions.checkNotNull(topicSelector);
    }

    KafkaSerializerWrapper(Class<? extends Serializer<? super IN>> serializerClass, boolean isKey, Function<? super IN, String> topicSelector) {
        this(serializerClass, isKey, Collections.emptyMap(), topicSelector);
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        ClassLoader userCodeClassLoader = context.getUserCodeClassLoader().asClassLoader();
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)userCodeClassLoader);){
            this.serializer = (Serializer)InstantiationUtil.instantiate((String)this.serializerClass.getName(), Serializer.class, (ClassLoader)this.getClass().getClassLoader());
            if (this.serializer instanceof Configurable) {
                ((Configurable)((Object)this.serializer)).configure(this.config);
            } else {
                this.serializer.configure(this.config, this.isKey);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to instantiate the serializer of class " + this.serializer, e);
        }
    }

    public byte[] serialize(IN element) {
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"Call open() once before trying to serialize elements.");
        return this.serializer.serialize(this.topicSelector.apply(element), element);
    }
}

