/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateListView;
import org.apache.flink.table.runtime.dataview.StateMapView;

@Internal
public final class PerKeyStateDataViewStore
implements StateDataViewStore {
    private static final String NULL_STATE_POSTFIX = "_null_state";
    private final RuntimeContext ctx;
    private final StateTtlConfig stateTtlConfig;

    public PerKeyStateDataViewStore(RuntimeContext ctx) {
        this(ctx, StateTtlConfig.DISABLED);
    }

    public PerKeyStateDataViewStore(RuntimeContext ctx, StateTtlConfig stateTtlConfig) {
        this.ctx = ctx;
        this.stateTtlConfig = stateTtlConfig;
    }

    @Override
    public <N, EK, EV> StateMapView<N, EK, EV> getStateMapView(String stateName, boolean supportNullKey, TypeSerializer<EK> keySerializer, TypeSerializer<EV> valueSerializer) {
        MapStateDescriptor<EK, EV> mapStateDescriptor = new MapStateDescriptor<EK, EV>(stateName, keySerializer, valueSerializer);
        if (this.stateTtlConfig.isEnabled()) {
            mapStateDescriptor.enableTimeToLive(this.stateTtlConfig);
        }
        MapState<EK, EV> mapState = this.ctx.getMapState(mapStateDescriptor);
        if (supportNullKey) {
            ValueStateDescriptor<EV> nullStateDescriptor = new ValueStateDescriptor<EV>(stateName + NULL_STATE_POSTFIX, valueSerializer);
            if (this.stateTtlConfig.isEnabled()) {
                nullStateDescriptor.enableTimeToLive(this.stateTtlConfig);
            }
            ValueState<EV> nullState = this.ctx.getState(nullStateDescriptor);
            return new StateMapView.KeyedStateMapViewWithKeysNullable(mapState, nullState);
        }
        return new StateMapView.KeyedStateMapViewWithKeysNotNull(mapState);
    }

    @Override
    public <N, EE> StateListView<N, EE> getStateListView(String stateName, TypeSerializer<EE> elementSerializer) {
        ListStateDescriptor<EE> listStateDescriptor = new ListStateDescriptor<EE>(stateName, elementSerializer);
        if (this.stateTtlConfig.isEnabled()) {
            listStateDescriptor.enableTimeToLive(this.stateTtlConfig);
        }
        ListState<EE> listState = this.ctx.getListState(listStateDescriptor);
        return new StateListView.KeyedStateListView(listState);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ctx;
    }
}

