/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.shaded.guava30.com.google.common.escape.Escaper;
import org.apache.flink.shaded.guava30.com.google.common.escape.Escapers;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapTools {
    private static final ConfigOption<Boolean> USE_LOCAL_DEFAULT_TMP_DIRS = ConfigOptions.key("internal.io.tmpdirs.use-local-default").booleanType().defaultValue(false);
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTools.class);
    private static final Escaper UNIX_SINGLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\'', "'\\''").build();
    private static final Escaper WINDOWS_DOUBLE_QUOTE_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('^', "\"^^\"").build();
    private static final String DYNAMIC_PROPERTIES_OPT = "D";

    public static void writeConfiguration(Configuration cfg, File file) throws IOException {
        try (FileWriter fwrt = new FileWriter(file);
             PrintWriter out = new PrintWriter(fwrt);){
            for (Map.Entry<String, String> entry : cfg.toMap().entrySet()) {
                out.print(entry.getKey());
                out.print(": ");
                out.println(entry.getValue());
            }
        }
    }

    public static void substituteDeprecatedConfigKey(Configuration config, String deprecated, String designated) {
        String valueForDeprecated;
        if (!config.containsKey(designated) && (valueForDeprecated = config.getString(deprecated, null)) != null) {
            config.setString(designated, valueForDeprecated);
        }
    }

    public static void substituteDeprecatedConfigPrefix(Configuration config, String deprecatedPrefix, String designatedPrefix) {
        int prefixLen = deprecatedPrefix.length();
        Configuration replacement = new Configuration();
        for (String key : config.keySet()) {
            String newKey;
            if (!key.startsWith(deprecatedPrefix) || config.containsKey(newKey = designatedPrefix + key.substring(prefixLen))) continue;
            replacement.setString(newKey, config.getString(key, null));
        }
        config.addAll(replacement);
    }

    public static Option newDynamicPropertiesOption() {
        return new Option(DYNAMIC_PROPERTIES_OPT, true, "Dynamic properties");
    }

    public static Configuration parseDynamicProperties(CommandLine cmd) {
        Configuration config = new Configuration();
        String[] values = cmd.getOptionValues(DYNAMIC_PROPERTIES_OPT);
        if (values != null) {
            for (String value : values) {
                String[] pair = value.split("=", 2);
                if (pair.length == 1) {
                    config.setString(pair[0], Boolean.TRUE.toString());
                    continue;
                }
                if (pair.length != 2) continue;
                config.setString(pair[0], pair[1]);
            }
        }
        return config;
    }

    public static String getTaskManagerShellCommand(Configuration flinkConfig, ContaineredTaskManagerParameters tmParams, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, boolean hasKrb5, Class<?> mainClass, String mainArgs) {
        HashMap<String, String> startCommandValues = new HashMap<String, String>();
        startCommandValues.put("java", "$JAVA_HOME/bin/java");
        TaskExecutorProcessSpec taskExecutorProcessSpec = tmParams.getTaskExecutorProcessSpec();
        startCommandValues.put("jvmmem", ProcessMemoryUtils.generateJvmParametersStr(taskExecutorProcessSpec));
        String javaOpts = flinkConfig.getString(CoreOptions.FLINK_JVM_OPTIONS);
        if (flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS).length() > 0) {
            javaOpts = javaOpts + " " + flinkConfig.getString(CoreOptions.FLINK_TM_JVM_OPTIONS);
        }
        if (hasKrb5) {
            javaOpts = javaOpts + " -Djava.security.krb5.conf=krb5.conf";
        }
        startCommandValues.put("jvmopts", javaOpts);
        String logging = "";
        if (hasLogback || hasLog4j) {
            logging = "-Dlog.file=" + logDirectory + "/taskmanager.log";
            if (hasLogback) {
                logging = logging + " -Dlogback.configurationFile=file:" + configDirectory + "/logback.xml";
            }
            if (hasLog4j) {
                logging = logging + " -Dlog4j.configuration=file:" + configDirectory + "/log4j.properties";
                logging = logging + " -Dlog4j.configurationFile=file:" + configDirectory + "/log4j.properties";
            }
        }
        startCommandValues.put("logging", logging);
        startCommandValues.put("class", mainClass.getName());
        startCommandValues.put("redirects", "1> " + logDirectory + "/taskmanager.out 2> " + logDirectory + "/taskmanager.err");
        String argsStr = TaskExecutorProcessUtils.generateDynamicConfigsStr(taskExecutorProcessSpec) + " --configDir " + configDirectory;
        if (!mainArgs.isEmpty()) {
            argsStr = argsStr + " " + mainArgs;
        }
        startCommandValues.put("args", argsStr);
        String commandTemplate = flinkConfig.getString("yarn.container-start-command-template", "%java% %jvmmem% %jvmopts% %logging% %class% %args% %redirects%");
        String startCommand = BootstrapTools.getStartCommand(commandTemplate, startCommandValues);
        LOG.debug("TaskManager start command: " + startCommand);
        return startCommand;
    }

    private BootstrapTools() {
    }

    public static String getStartCommand(String template, Map<String, String> startCommandValues) {
        for (Map.Entry<String, String> variable : startCommandValues.entrySet()) {
            template = template.replace("%" + variable.getKey() + "%", variable.getValue()).replace("  ", " ").trim();
        }
        return template;
    }

    public static void updateTmpDirectoriesInConfiguration(Configuration configuration, @Nullable String defaultDirs) {
        if (configuration.contains(CoreOptions.TMP_DIRS)) {
            LOG.info("Overriding Flink's temporary file directories with those specified in the Flink config: {}", (Object)configuration.getValue(CoreOptions.TMP_DIRS));
        } else if (defaultDirs != null) {
            LOG.info("Setting directories for temporary files to: {}", (Object)defaultDirs);
            configuration.setString(CoreOptions.TMP_DIRS, defaultDirs);
            configuration.setBoolean(USE_LOCAL_DEFAULT_TMP_DIRS, true);
        }
    }

    public static Configuration cloneConfiguration(Configuration configuration) {
        Configuration clonedConfiguration = new Configuration(configuration);
        if (clonedConfiguration.getBoolean(USE_LOCAL_DEFAULT_TMP_DIRS)) {
            clonedConfiguration.removeConfig(CoreOptions.TMP_DIRS);
            clonedConfiguration.removeConfig(USE_LOCAL_DEFAULT_TMP_DIRS);
        }
        return clonedConfiguration;
    }

    public static String getDynamicPropertiesAsString(Configuration baseConfig, Configuration targetConfig) {
        CharSequence[] newAddedConfigs = (String[])targetConfig.keySet().stream().flatMap(key -> {
            String baseValue = baseConfig.getString(ConfigOptions.key(key).stringType().noDefaultValue());
            String targetValue = targetConfig.getString(ConfigOptions.key(key).stringType().noDefaultValue());
            if (!baseConfig.keySet().contains(key) || !baseValue.equals(targetValue)) {
                return Stream.of("-" + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt() + key + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getValueSeparator() + BootstrapTools.escapeForDifferentOS(targetValue));
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return String.join((CharSequence)" ", newAddedConfigs);
    }

    public static String escapeForDifferentOS(String value) {
        if (OperatingSystem.isWindows()) {
            return BootstrapTools.escapeWithDoubleQuote(value);
        }
        return BootstrapTools.escapeWithSingleQuote(value);
    }

    public static String escapeWithSingleQuote(String value) {
        return "'" + UNIX_SINGLE_QUOTE_ESCAPER.escape(value) + "'";
    }

    public static String escapeWithDoubleQuote(String value) {
        return "\"" + WINDOWS_DOUBLE_QUOTE_ESCAPER.escape(value) + "\"";
    }
}

