/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.util.List;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;

public class HandlerRequestUtils {
    public static <X, P extends MessageQueryParameter<X>, R extends RequestBody, M extends MessageParameters> X getQueryParameter(HandlerRequest<R> request, Class<P> queryParameterClass) throws RestHandlerException {
        return HandlerRequestUtils.getQueryParameter(request, queryParameterClass, null);
    }

    public static <X, P extends MessageQueryParameter<X>, R extends RequestBody, M extends MessageParameters> X getQueryParameter(HandlerRequest<R> request, Class<P> queryParameterClass, X defaultValue) throws RestHandlerException {
        List values = request.getQueryParameter(queryParameterClass);
        if (values.size() > 1) {
            throw new RestHandlerException(String.format("Expected only one value %s.", values), HttpResponseStatus.BAD_REQUEST);
        }
        X value = values.size() == 1 ? values.get(0) : defaultValue;
        return value;
    }

    public static <T> T fromRequestBodyOrQueryParameter(T requestValue, SupplierWithException<T, RestHandlerException> queryParameterExtractor, T defaultValue, Logger log) throws RestHandlerException {
        if (requestValue != null) {
            return requestValue;
        }
        T queryParameterValue = queryParameterExtractor.get();
        if (queryParameterValue != null) {
            log.warn("Configuring the job submission via query parameters is deprecated. Please migrate to submitting a JSON request instead.");
            return queryParameterValue;
        }
        return defaultValue;
    }
}

