/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.AbstractMapIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.index.RangeIndex;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionEntry;

public class MapRangeIndex
extends AbstractMapIndex {
    protected final AbstractIndex.RegionEntryToValuesMap entryToMapKeysMap;

    MapRangeIndex(InternalCache cache, String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, boolean isAllKeys, String[] multiIndexingKeysPattern, Object[] mapKeys, IndexStatistics stats) {
        super(cache, indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndxExpr, defintions, isAllKeys, multiIndexingKeysPattern, mapKeys, stats);
        RegionAttributes ra = region.getAttributes();
        this.entryToMapKeysMap = new AbstractIndex.RegionEntryToValuesMap(new ConcurrentHashMap(ra.getInitialCapacity(), ra.getLoadFactor(), ra.getConcurrencyLevel()), true);
    }

    @Override
    void recreateIndexData() throws IMQException {
        this.mapKeyToValueIndex.clear();
        this.entryToMapKeysMap.clear();
        this.initializeIndex(true);
    }

    @Override
    public boolean containsEntry(RegionEntry entry) {
        return this.entryToMapKeysMap.containsEntry(entry);
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        this.evaluator.evaluate(entry, true);
        this.addSavedMappings(entry);
        this.clearCurrState();
    }

    public void clearCurrState() {
        for (Object rangeInd : this.mapKeyToValueIndex.values()) {
            ((RangeIndex)rangeInd).clearCurrState();
        }
    }

    private void addSavedMappings(RegionEntry entry) throws IMQException {
        for (Object rangeInd : this.mapKeyToValueIndex.values()) {
            ((RangeIndex)rangeInd).addSavedMappings(entry);
        }
    }

    @Override
    protected void removeMapping(RegionEntry entry, int opCode) throws IMQException {
        if (opCode == 1 || opCode == 4) {
            return;
        }
        Object values = this.entryToMapKeysMap.remove(entry);
        if (values == null) {
            return;
        }
        if (values instanceof Collection) {
            for (Object key : (Collection)values) {
                RangeIndex ri = (RangeIndex)this.mapKeyToValueIndex.get(key);
                long start = System.nanoTime();
                this.internalIndexStats.incUpdatesInProgress(1);
                ri.removeMapping(entry, opCode);
                this.internalIndexStats.incUpdatesInProgress(-1);
                long end = -start;
                this.internalIndexStats.incUpdateTime(end);
            }
        } else {
            RangeIndex ri = (RangeIndex)this.mapKeyToValueIndex.get(values);
            long start = System.nanoTime();
            this.internalIndexStats.incUpdatesInProgress(1);
            ri.removeMapping(entry, opCode);
            this.internalIndexStats.incUpdatesInProgress(-1);
            long end = System.nanoTime() - start;
            this.internalIndexStats.incUpdateTime(end);
        }
    }

    @Override
    protected void doIndexAddition(Object mapKey, Object indexKey, Object value, RegionEntry entry) throws IMQException {
        boolean isPr = this.region instanceof BucketRegion;
        RangeIndex rg = (RangeIndex)this.mapKeyToValueIndex.get(mapKey);
        if (rg == null) {
            AbstractIndex.InternalIndexStatistics stats = this.internalIndexStats;
            PartitionedIndex prIndex = null;
            if (isPr) {
                prIndex = (PartitionedIndex)this.getPRIndex();
                prIndex.incNumMapKeysStats(mapKey);
            }
            rg = new RangeIndex(this.cache, this.indexName + "-" + mapKey, this.region, this.fromClause, this.indexedExpression, this.projectionAttributes, this.originalFromClause, this.originalIndexedExpression, this.canonicalizedDefinitions, stats);
            rg.evaluator = this.evaluator;
            this.mapKeyToValueIndex.put(mapKey, rg);
            if (!isPr) {
                this.internalIndexStats.incNumMapIndexKeys(1L);
            }
        }
        this.internalIndexStats.incUpdatesInProgress(1);
        long start = System.nanoTime();
        rg.addMapping(indexKey, value, entry);
        this.internalIndexStats.incUpdatesInProgress(-1);
        long end = System.nanoTime() - start;
        this.internalIndexStats.incUpdateTime(end);
        this.entryToMapKeysMap.add(entry, mapKey);
    }

    @Override
    protected void saveIndexAddition(Object mapKey, Object indexKey, Object value, RegionEntry entry) throws IMQException {
        boolean isPr = this.region instanceof BucketRegion;
        RangeIndex rg = (RangeIndex)this.mapKeyToValueIndex.get(mapKey);
        if (rg == null) {
            AbstractIndex.InternalIndexStatistics stats = this.internalIndexStats;
            PartitionedIndex prIndex = null;
            if (isPr) {
                prIndex = (PartitionedIndex)this.getPRIndex();
                prIndex.incNumMapKeysStats(mapKey);
            }
            rg = new RangeIndex(this.cache, this.indexName + "-" + mapKey, this.region, this.fromClause, this.indexedExpression, this.projectionAttributes, this.originalFromClause, this.originalIndexedExpression, this.canonicalizedDefinitions, stats);
            rg.evaluator = this.evaluator;
            this.mapKeyToValueIndex.put(mapKey, rg);
            if (!isPr) {
                this.internalIndexStats.incNumMapIndexKeys(1L);
            }
        }
        long start = System.nanoTime();
        rg.saveMapping(indexKey, value, entry);
        this.internalIndexStats.incUpdatesInProgress(-1);
        long end = System.nanoTime() - start;
        this.internalIndexStats.incUpdateTime(end);
        this.entryToMapKeysMap.add(entry, mapKey);
    }
}

